/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Calendar;
import java.util.LinkedList;

public class ActivityState
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9039439291143138148L;
    private static final int ORDER_ID_MAXCOUNT = 10;
    private transient ILogger logger = AdjustFactory.getLogger();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("uuid", String.class), new ObjectStreamField("enabled", Boolean.TYPE), new ObjectStreamField("isGdprForgotten", Boolean.TYPE), new ObjectStreamField("isThirdPartySharingDisabled", Boolean.TYPE), new ObjectStreamField("askingAttribution", Boolean.TYPE), new ObjectStreamField("eventCount", Integer.TYPE), new ObjectStreamField("sessionCount", Integer.TYPE), new ObjectStreamField("subsessionCount", Integer.TYPE), new ObjectStreamField("sessionLength", Long.TYPE), new ObjectStreamField("timeSpent", Long.TYPE), new ObjectStreamField("lastActivity", Long.TYPE), new ObjectStreamField("lastInterval", Long.TYPE), new ObjectStreamField("updatePackages", Boolean.TYPE), new ObjectStreamField("orderIds", LinkedList.class), new ObjectStreamField("pushToken", String.class), new ObjectStreamField("adid", String.class), new ObjectStreamField("clickTime", Long.TYPE), new ObjectStreamField("installBegin", Long.TYPE), new ObjectStreamField("installReferrer", String.class), new ObjectStreamField("googlePlayInstant", Boolean.class), new ObjectStreamField("clickTimeServer", Long.TYPE), new ObjectStreamField("installBeginServer", Long.TYPE), new ObjectStreamField("installVersion", String.class), new ObjectStreamField("clickTimeHuawei", Long.TYPE), new ObjectStreamField("installBeginHuawei", Long.TYPE), new ObjectStreamField("installReferrerHuawei", String.class), new ObjectStreamField("installReferrerHuaweiAppGallery", String.class)};
    protected String uuid = Util.createUuid();
    protected boolean enabled = true;
    protected boolean isGdprForgotten = false;
    protected boolean isThirdPartySharingDisabled = false;
    protected boolean askingAttribution = false;
    protected int eventCount = 0;
    protected int sessionCount = 0;
    protected int subsessionCount = -1;
    protected long sessionLength = -1L;
    protected long timeSpent = -1L;
    protected long lastActivity = -1L;
    protected long lastInterval = -1L;
    protected boolean updatePackages = false;
    protected LinkedList<String> orderIds = null;
    protected String pushToken = null;
    protected String adid = null;
    protected long clickTime = 0L;
    protected long installBegin = 0L;
    protected String installReferrer = null;
    protected Boolean googlePlayInstant = null;
    protected long clickTimeServer = 0L;
    protected long installBeginServer = 0L;
    protected String installVersion = null;
    protected long clickTimeHuawei = 0L;
    protected long installBeginHuawei = 0L;
    protected String installReferrerHuawei = null;
    protected String installReferrerHuaweiAppGallery = null;

    protected ActivityState() {
    }

    protected void resetSessionAttributes(long now) {
        this.subsessionCount = 1;
        this.sessionLength = 0L;
        this.timeSpent = 0L;
        this.lastActivity = now;
        this.lastInterval = -1L;
    }

    protected void addOrderId(String orderId) {
        if (this.orderIds == null) {
            this.orderIds = new LinkedList();
        }
        if (this.orderIds.size() >= 10) {
            this.orderIds.removeLast();
        }
        this.orderIds.addFirst(orderId);
    }

    protected boolean findOrderId(String orderId) {
        if (this.orderIds == null) {
            return false;
        }
        return this.orderIds.contains(orderId);
    }

    public String toString() {
        return Util.formatString("ec:%d sc:%d ssc:%d sl:%.1f ts:%.1f la:%s uuid:%s", this.eventCount, this.sessionCount, this.subsessionCount, (double)this.sessionLength / 1000.0, (double)this.timeSpent / 1000.0, ActivityState.stamp(this.lastActivity), this.uuid);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ActivityState otherActivityState = (ActivityState)other;
        if (!Util.equalString(this.uuid, otherActivityState.uuid)) {
            return false;
        }
        if (!Util.equalBoolean(this.enabled, otherActivityState.enabled)) {
            return false;
        }
        if (!Util.equalBoolean(this.isGdprForgotten, otherActivityState.isGdprForgotten)) {
            return false;
        }
        if (!Util.equalBoolean(this.isThirdPartySharingDisabled, otherActivityState.isThirdPartySharingDisabled)) {
            return false;
        }
        if (!Util.equalBoolean(this.askingAttribution, otherActivityState.askingAttribution)) {
            return false;
        }
        if (!Util.equalInt(this.eventCount, otherActivityState.eventCount)) {
            return false;
        }
        if (!Util.equalInt(this.sessionCount, otherActivityState.sessionCount)) {
            return false;
        }
        if (!Util.equalInt(this.subsessionCount, otherActivityState.subsessionCount)) {
            return false;
        }
        if (!Util.equalLong(this.sessionLength, otherActivityState.sessionLength)) {
            return false;
        }
        if (!Util.equalLong(this.timeSpent, otherActivityState.timeSpent)) {
            return false;
        }
        if (!Util.equalLong(this.lastInterval, otherActivityState.lastInterval)) {
            return false;
        }
        if (!Util.equalBoolean(this.updatePackages, otherActivityState.updatePackages)) {
            return false;
        }
        if (!Util.equalObject(this.orderIds, otherActivityState.orderIds)) {
            return false;
        }
        if (!Util.equalString(this.pushToken, otherActivityState.pushToken)) {
            return false;
        }
        if (!Util.equalString(this.adid, otherActivityState.adid)) {
            return false;
        }
        if (!Util.equalLong(this.clickTime, otherActivityState.clickTime)) {
            return false;
        }
        if (!Util.equalLong(this.installBegin, otherActivityState.installBegin)) {
            return false;
        }
        if (!Util.equalString(this.installReferrer, otherActivityState.installReferrer)) {
            return false;
        }
        if (!Util.equalBoolean(this.googlePlayInstant, otherActivityState.googlePlayInstant)) {
            return false;
        }
        if (!Util.equalLong(this.clickTimeServer, otherActivityState.clickTimeServer)) {
            return false;
        }
        if (!Util.equalLong(this.installBeginServer, otherActivityState.installBeginServer)) {
            return false;
        }
        if (!Util.equalString(this.installVersion, otherActivityState.installVersion)) {
            return false;
        }
        if (!Util.equalLong(this.clickTimeHuawei, otherActivityState.clickTimeHuawei)) {
            return false;
        }
        if (!Util.equalLong(this.installBeginHuawei, otherActivityState.installBeginHuawei)) {
            return false;
        }
        if (!Util.equalString(this.installReferrerHuawei, otherActivityState.installReferrerHuawei)) {
            return false;
        }
        return Util.equalString(this.installReferrerHuaweiAppGallery, otherActivityState.installReferrerHuaweiAppGallery);
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + Util.hashString(this.uuid);
        hashCode = 37 * hashCode + Util.hashBoolean(this.enabled);
        hashCode = 37 * hashCode + Util.hashBoolean(this.isGdprForgotten);
        hashCode = 37 * hashCode + Util.hashBoolean(this.isThirdPartySharingDisabled);
        hashCode = 37 * hashCode + Util.hashBoolean(this.askingAttribution);
        hashCode = 37 * hashCode + this.eventCount;
        hashCode = 37 * hashCode + this.sessionCount;
        hashCode = 37 * hashCode + this.subsessionCount;
        hashCode = 37 * hashCode + Util.hashLong(this.sessionLength);
        hashCode = 37 * hashCode + Util.hashLong(this.timeSpent);
        hashCode = 37 * hashCode + Util.hashLong(this.lastInterval);
        hashCode = 37 * hashCode + Util.hashBoolean(this.updatePackages);
        hashCode = 37 * hashCode + Util.hashObject(this.orderIds);
        hashCode = 37 * hashCode + Util.hashString(this.pushToken);
        hashCode = 37 * hashCode + Util.hashString(this.adid);
        hashCode = 37 * hashCode + Util.hashLong(this.clickTime);
        hashCode = 37 * hashCode + Util.hashLong(this.installBegin);
        hashCode = 37 * hashCode + Util.hashString(this.installReferrer);
        hashCode = 37 * hashCode + Util.hashBoolean(this.googlePlayInstant);
        hashCode = 37 * hashCode + Util.hashLong(this.clickTimeServer);
        hashCode = 37 * hashCode + Util.hashLong(this.installBeginServer);
        hashCode = 37 * hashCode + Util.hashString(this.installVersion);
        hashCode = 37 * hashCode + Util.hashLong(this.clickTimeHuawei);
        hashCode = 37 * hashCode + Util.hashLong(this.installBeginHuawei);
        hashCode = 37 * hashCode + Util.hashString(this.installReferrerHuawei);
        hashCode = 37 * hashCode + Util.hashString(this.installReferrerHuaweiAppGallery);
        return hashCode;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.eventCount = Util.readIntField(fields, "eventCount", 0);
        this.sessionCount = Util.readIntField(fields, "sessionCount", 0);
        this.subsessionCount = Util.readIntField(fields, "subsessionCount", -1);
        this.sessionLength = Util.readLongField(fields, "sessionLength", -1L);
        this.timeSpent = Util.readLongField(fields, "timeSpent", -1L);
        this.lastActivity = Util.readLongField(fields, "lastActivity", -1L);
        this.lastInterval = Util.readLongField(fields, "lastInterval", -1L);
        this.uuid = Util.readStringField(fields, "uuid", null);
        this.enabled = Util.readBooleanField(fields, "enabled", true);
        this.isGdprForgotten = Util.readBooleanField(fields, "isGdprForgotten", false);
        this.isThirdPartySharingDisabled = Util.readBooleanField(fields, "isThirdPartySharingDisabled", false);
        this.askingAttribution = Util.readBooleanField(fields, "askingAttribution", false);
        this.updatePackages = Util.readBooleanField(fields, "updatePackages", false);
        this.orderIds = Util.readObjectField(fields, "orderIds", null);
        this.pushToken = Util.readStringField(fields, "pushToken", null);
        this.adid = Util.readStringField(fields, "adid", null);
        this.clickTime = Util.readLongField(fields, "clickTime", -1L);
        this.installBegin = Util.readLongField(fields, "installBegin", -1L);
        this.installReferrer = Util.readStringField(fields, "installReferrer", null);
        this.googlePlayInstant = Util.readObjectField(fields, "googlePlayInstant", null);
        this.clickTimeServer = Util.readLongField(fields, "clickTimeServer", -1L);
        this.installBeginServer = Util.readLongField(fields, "installBeginServer", -1L);
        this.installVersion = Util.readStringField(fields, "installVersion", null);
        this.clickTimeHuawei = Util.readLongField(fields, "clickTimeHuawei", -1L);
        this.installBeginHuawei = Util.readLongField(fields, "installBeginHuawei", -1L);
        this.installReferrerHuawei = Util.readStringField(fields, "installReferrerHuawei", null);
        this.installReferrerHuaweiAppGallery = Util.readStringField(fields, "installReferrerHuaweiAppGallery", null);
        if (this.uuid == null) {
            this.uuid = Util.createUuid();
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private static String stamp(long dateMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dateMillis);
        Object[] objectArray = new Object[3];
        objectArray[0] = 11;
        objectArray[1] = 12;
        objectArray[2] = 13;
        return Util.formatString("%02d:%02d:%02d", objectArray);
    }
}

