/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.network;

import android.net.Uri;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.network.UrlStrategy;
import com.adjust.sdk.network.UtilNetworking;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadExecutor;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityPackageSender
implements IActivityPackageSender {
    private String basePath;
    private String gdprPath;
    private String subscriptionPath;
    private String clientSdk;
    private ILogger logger;
    private ThreadExecutor executor;
    private UrlStrategy urlStrategy;
    private UtilNetworking.IHttpsURLConnectionProvider httpsURLConnectionProvider;
    private UtilNetworking.IConnectionOptions connectionOptions;

    public ActivityPackageSender(String adjustUrlStrategy, String basePath, String gdprPath, String subscriptionPath, String clientSdk) {
        this.basePath = basePath;
        this.gdprPath = gdprPath;
        this.subscriptionPath = subscriptionPath;
        this.clientSdk = clientSdk;
        this.logger = AdjustFactory.getLogger();
        this.executor = new SingleThreadCachedScheduler("ActivityPackageSender");
        this.urlStrategy = new UrlStrategy(AdjustFactory.getBaseUrl(), AdjustFactory.getGdprUrl(), AdjustFactory.getSubscriptionUrl(), adjustUrlStrategy);
        this.httpsURLConnectionProvider = AdjustFactory.getHttpsURLConnectionProvider();
        this.connectionOptions = AdjustFactory.getConnectionOptions();
    }

    @Override
    public void sendActivityPackage(final ActivityPackage activityPackage, final Map<String, String> sendingParameters, final IActivityPackageSender.ResponseDataCallbackSubscriber responseCallback) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                responseCallback.onResponseDataCallback(ActivityPackageSender.this.sendActivityPackageSync(activityPackage, sendingParameters));
            }
        });
    }

    @Override
    public ResponseData sendActivityPackageSync(ActivityPackage activityPackage, Map<String, String> sendingParameters) {
        ResponseData responseData;
        boolean retryToSend;
        do {
            responseData = ResponseData.buildResponseData(activityPackage, sendingParameters);
            this.tryToGetResponse(responseData);
        } while (retryToSend = this.shouldRetryToSend(responseData));
        return responseData;
    }

    private boolean shouldRetryToSend(ResponseData responseData) {
        if (!responseData.willRetry) {
            this.logger.debug("Will not retry with current url strategy", new Object[0]);
            this.urlStrategy.resetAfterSuccess();
            return false;
        }
        if (this.urlStrategy.shouldRetryAfterFailure(responseData.activityKind)) {
            this.logger.error("Failed with current url strategy, but it will retry with new", new Object[0]);
            return true;
        }
        this.logger.error("Failed with current url strategy and it will not retry", new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToGetResponse(ResponseData responseData) {
        DataOutputStream dataOutputStream = null;
        try {
            String urlString;
            boolean shouldUseGET;
            ActivityPackage activityPackage = responseData.activityPackage;
            HashMap<String, String> activityPackageParameters = new HashMap<String, String>(activityPackage.getParameters());
            Map<String, String> sendingParameters = responseData.sendingParameters;
            String authorizationHeader = this.buildAndExtractAuthorizationHeader(activityPackageParameters, activityPackage.getActivityKind());
            boolean bl = shouldUseGET = responseData.activityPackage.getActivityKind() == ActivityKind.ATTRIBUTION;
            if (shouldUseGET) {
                ActivityPackageSender.extractEventCallbackId(activityPackageParameters);
                urlString = this.generateUrlStringForGET(activityPackage.getActivityKind(), activityPackage.getPath(), activityPackageParameters, sendingParameters);
            } else {
                urlString = this.generateUrlStringForPOST(activityPackage.getActivityKind(), activityPackage.getPath());
            }
            URL url = new URL(urlString);
            HttpsURLConnection connection = this.httpsURLConnectionProvider.generateHttpsURLConnection(url);
            this.connectionOptions.applyConnectionOptions(connection, activityPackage.getClientSdk());
            if (authorizationHeader != null) {
                connection.setRequestProperty("Authorization", authorizationHeader);
            }
            if (shouldUseGET) {
                dataOutputStream = this.configConnectionForGET(connection);
            } else {
                ActivityPackageSender.extractEventCallbackId(activityPackageParameters);
                dataOutputStream = this.configConnectionForPOST(connection, activityPackageParameters, sendingParameters);
            }
            Integer responseCode = this.readConnectionResponse(connection, responseData);
            responseData.success = responseData.jsonResponse != null && responseData.retryIn == null && responseCode != null && responseCode == 200;
            responseData.willRetry = responseData.jsonResponse == null || responseData.retryIn != null;
        }
        catch (UnsupportedEncodingException exception) {
            this.localError(exception, "Failed to encode parameters", responseData);
        }
        catch (MalformedURLException exception) {
            this.localError(exception, "Malformed URL", responseData);
        }
        catch (ProtocolException exception) {
            this.localError(exception, "Protocol Error", responseData);
        }
        catch (SocketTimeoutException exception) {
            this.remoteError(exception, "Request timed out", responseData);
        }
        catch (SSLHandshakeException exception) {
            this.remoteError(exception, "Certificate failed", responseData);
        }
        catch (IOException exception) {
            this.remoteError(exception, "Request failed", responseData);
        }
        catch (Throwable t) {
            this.localError(t, "Sending SDK package", responseData);
        }
        finally {
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
            }
            catch (IOException ioException) {
                String errorMessage = this.errorMessage(ioException, "Flushing and closing connection output stream", responseData.activityPackage);
                this.logger.error(errorMessage, new Object[0]);
            }
        }
    }

    private void localError(Throwable throwable, String description, ResponseData responseData) {
        String finalMessage = this.errorMessage(throwable, description, responseData.activityPackage);
        this.logger.error(finalMessage, new Object[0]);
        responseData.message = finalMessage;
        responseData.willRetry = false;
    }

    private void remoteError(Throwable throwable, String description, ResponseData responseData) {
        String finalMessage = this.errorMessage(throwable, description, responseData.activityPackage) + " Will retry later";
        this.logger.error(finalMessage, new Object[0]);
        responseData.message = finalMessage;
        responseData.willRetry = true;
    }

    private String errorMessage(Throwable throwable, String description, ActivityPackage activityPackage) {
        String failureMessage = activityPackage.getFailureMessage();
        String reasonString = Util.getReasonString(description, throwable);
        return Util.formatString("%s. (%s)", failureMessage, reasonString);
    }

    private String generateUrlStringForGET(ActivityKind activityKind, String activityPackagePath, Map<String, String> activityPackageParameters, Map<String, String> sendingParameters) throws MalformedURLException {
        String targetUrl = this.urlStrategy.targetUrlByActivityKind(activityKind);
        String urlWithPath = this.urlWithExtraPathByActivityKind(activityKind, targetUrl);
        URL urlObject = new URL(urlWithPath);
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.scheme(urlObject.getProtocol());
        uriBuilder.encodedAuthority(urlObject.getAuthority());
        uriBuilder.path(urlObject.getPath());
        uriBuilder.appendPath(activityPackagePath);
        this.logger.debug("Making request to url: %s", uriBuilder.toString());
        for (Map.Entry<String, String> entry : activityPackageParameters.entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        if (sendingParameters != null) {
            for (Map.Entry<String, String> entry : sendingParameters.entrySet()) {
                uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        return uriBuilder.build().toString();
    }

    private String generateUrlStringForPOST(ActivityKind activityKind, String activityPackagePath) {
        String targetUrl = this.urlStrategy.targetUrlByActivityKind(activityKind);
        String urlWithPath = this.urlWithExtraPathByActivityKind(activityKind, targetUrl);
        String urlString = Util.formatString("%s%s", urlWithPath, activityPackagePath);
        this.logger.debug("Making request to url : %s", urlString);
        return urlString;
    }

    private String urlWithExtraPathByActivityKind(ActivityKind activityKind, String targetUrl) {
        if (activityKind == ActivityKind.GDPR) {
            return this.gdprPath != null ? targetUrl + this.gdprPath : targetUrl;
        }
        if (activityKind == ActivityKind.SUBSCRIPTION) {
            return this.subscriptionPath != null ? targetUrl + this.subscriptionPath : targetUrl;
        }
        return this.basePath != null ? targetUrl + this.basePath : targetUrl;
    }

    private DataOutputStream configConnectionForGET(HttpsURLConnection connection) throws ProtocolException {
        connection.setRequestMethod("GET");
        return null;
    }

    private DataOutputStream configConnectionForPOST(HttpsURLConnection connection, Map<String, String> activityPackageParameters, Map<String, String> sendingParameters) throws ProtocolException, UnsupportedEncodingException, IOException {
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        String postBodyString = this.generatePOSTBodyString(activityPackageParameters, sendingParameters);
        if (postBodyString == null) {
            return null;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
        dataOutputStream.writeBytes(postBodyString);
        return dataOutputStream;
    }

    private String generatePOSTBodyString(Map<String, String> parameters, Map<String, String> sendingParameters) throws UnsupportedEncodingException {
        if (parameters.isEmpty()) {
            return null;
        }
        StringBuilder postStringBuilder = new StringBuilder();
        this.injectParametersToPOSTStringBuilder(parameters, postStringBuilder);
        this.injectParametersToPOSTStringBuilder(sendingParameters, postStringBuilder);
        if (postStringBuilder.length() > 0 && postStringBuilder.charAt(postStringBuilder.length() - 1) == '&') {
            postStringBuilder.deleteCharAt(postStringBuilder.length() - 1);
        }
        return postStringBuilder.toString();
    }

    private void injectParametersToPOSTStringBuilder(Map<String, String> parametersToInject, StringBuilder postStringBuilder) throws UnsupportedEncodingException {
        if (parametersToInject == null || parametersToInject.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : parametersToInject.entrySet()) {
            String encodedName = URLEncoder.encode(entry.getKey(), "UTF-8");
            String value = entry.getValue();
            String encodedValue = value != null ? URLEncoder.encode(value, "UTF-8") : "";
            postStringBuilder.append(encodedName);
            postStringBuilder.append("=");
            postStringBuilder.append(encodedValue);
            postStringBuilder.append("&");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer readConnectionResponse(HttpsURLConnection connection, ResponseData responseData) {
        StringBuilder responseStringBuilder = new StringBuilder();
        Integer responseCode = null;
        try {
            String line;
            connection.connect();
            responseCode = connection.getResponseCode();
            InputStream inputStream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                responseStringBuilder.append(line);
            }
        }
        catch (IOException ioException) {
            String errorMessage = this.errorMessage(ioException, "Connecting and reading response", responseData.activityPackage);
            this.logger.error(errorMessage, new Object[0]);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (responseStringBuilder.length() == 0) {
            this.logger.error("Empty response string buffer", new Object[0]);
            return responseCode;
        }
        if (responseCode == 429) {
            this.logger.error("Too frequent requests to the endpoint (429)", new Object[0]);
            return responseCode;
        }
        String responseString = responseStringBuilder.toString();
        this.logger.debug("Response string: %s", responseString);
        this.parseResponse(responseData, responseString);
        String responseMessage = responseData.message;
        if (responseMessage == null) {
            return responseCode;
        }
        if (responseCode != null && responseCode == 200) {
            this.logger.info("Response message: %s", responseMessage);
        } else {
            this.logger.error("Response message: %s", responseMessage);
        }
        return responseCode;
    }

    private void parseResponse(ResponseData responseData, String responseString) {
        if (responseString.length() == 0) {
            this.logger.error("Empty response string", new Object[0]);
            return;
        }
        JSONObject jsonResponse = null;
        try {
            jsonResponse = new JSONObject(responseString);
        }
        catch (JSONException jsonException) {
            String errorMessage = this.errorMessage(jsonException, "Failed to parse JSON response", responseData.activityPackage);
            this.logger.error(errorMessage, new Object[0]);
        }
        if (jsonResponse == null) {
            return;
        }
        responseData.jsonResponse = jsonResponse;
        responseData.message = UtilNetworking.extractJsonString(jsonResponse, "message");
        responseData.adid = UtilNetworking.extractJsonString(jsonResponse, "adid");
        responseData.timestamp = UtilNetworking.extractJsonString(jsonResponse, "timestamp");
        String trackingState = UtilNetworking.extractJsonString(jsonResponse, "tracking_state");
        if (trackingState != null && trackingState.equals("opted_out")) {
            responseData.trackingState = TrackingState.OPTED_OUT;
        }
        responseData.askIn = UtilNetworking.extractJsonLong(jsonResponse, "ask_in");
        responseData.retryIn = UtilNetworking.extractJsonLong(jsonResponse, "retry_in");
        responseData.continueIn = UtilNetworking.extractJsonLong(jsonResponse, "continue_in");
        JSONObject attributionJson = jsonResponse.optJSONObject("attribution");
        responseData.attribution = AdjustAttribution.fromJson(attributionJson, responseData.adid, Util.getSdkPrefixPlatform(this.clientSdk));
    }

    private String buildAndExtractAuthorizationHeader(Map<String, String> parameters, ActivityKind activityKind) {
        String nativeVersion;
        String algorithm;
        String activityKindString = activityKind.toString();
        String secretId = ActivityPackageSender.extractSecretId(parameters);
        String headersId = ActivityPackageSender.extractHeadersId(parameters);
        String signature = ActivityPackageSender.extractSignature(parameters);
        String authorizationHeader = this.buildAuthorizationHeaderV2(signature, secretId, headersId, algorithm = ActivityPackageSender.extractAlgorithm(parameters), nativeVersion = ActivityPackageSender.extractNativeVersion(parameters));
        if (authorizationHeader != null) {
            return authorizationHeader;
        }
        String appSecret = ActivityPackageSender.extractAppSecret(parameters);
        return this.buildAuthorizationHeaderV1(parameters, appSecret, secretId, activityKindString);
    }

    private String buildAuthorizationHeaderV1(Map<String, String> parameters, String appSecret, String secretId, String activityKindString) {
        if (appSecret == null || appSecret.length() == 0) {
            return null;
        }
        String appSecretName = "app_secret";
        Map<String, String> signatureDetails = this.getSignature(parameters, activityKindString, appSecret);
        String algorithm = "sha256";
        String signature = Util.sha256(signatureDetails.get("clear_signature"));
        String fields = signatureDetails.get("fields");
        String secretIdHeader = Util.formatString("secret_id=\"%s\"", secretId);
        String signatureHeader = Util.formatString("signature=\"%s\"", signature);
        String algorithmHeader = Util.formatString("algorithm=\"%s\"", algorithm);
        String fieldsHeader = Util.formatString("headers=\"%s\"", fields);
        String authorizationHeader = Util.formatString("Signature %s,%s,%s,%s", secretIdHeader, signatureHeader, algorithmHeader, fieldsHeader);
        this.logger.verbose("authorizationHeader: %s", authorizationHeader);
        return authorizationHeader;
    }

    private String buildAuthorizationHeaderV2(String signature, String secretId, String headersId, String algorithm, String nativeVersion) {
        if (secretId == null || signature == null || headersId == null) {
            return null;
        }
        String signatureHeader = Util.formatString("signature=\"%s\"", signature);
        String secretIdHeader = Util.formatString("secret_id=\"%s\"", secretId);
        String idHeader = Util.formatString("headers_id=\"%s\"", headersId);
        String algorithmHeader = Util.formatString("algorithm=\"%s\"", algorithm != null ? algorithm : "adj1");
        String nativeVersionHeader = Util.formatString("native_version=\"%s\"", nativeVersion != null ? nativeVersion : "");
        String authorizationHeader = Util.formatString("Signature %s,%s,%s,%s,%s", signatureHeader, secretIdHeader, algorithmHeader, idHeader, nativeVersionHeader);
        this.logger.verbose("authorizationHeader: %s", authorizationHeader);
        return authorizationHeader;
    }

    private Map<String, String> getSignature(Map<String, String> parameters, String activityKindString, String appSecret) {
        String activityKindName = "activity_kind";
        String activityKindValue = activityKindString;
        String createdAtName = "created_at";
        String createdAt = parameters.get(createdAtName);
        String deviceIdentifierName = this.getValidIdentifier(parameters);
        String deviceIdentifier = parameters.get(deviceIdentifierName);
        String sourceName = "source";
        String sourceValue = parameters.get(sourceName);
        String payloadName = "payload";
        String payloadValue = parameters.get(payloadName);
        HashMap<String, String> signatureParams = new HashMap<String, String>();
        signatureParams.put("app_secret", appSecret);
        signatureParams.put(createdAtName, createdAt);
        signatureParams.put(activityKindName, activityKindValue);
        signatureParams.put(deviceIdentifierName, deviceIdentifier);
        if (sourceValue != null) {
            signatureParams.put(sourceName, sourceValue);
        }
        if (payloadValue != null) {
            signatureParams.put(payloadName, payloadValue);
        }
        String fields = "";
        String clearSignature = "";
        for (Map.Entry entry : signatureParams.entrySet()) {
            if (entry.getValue() == null) continue;
            fields = fields + (String)entry.getKey() + " ";
            clearSignature = clearSignature + (String)entry.getValue();
        }
        fields = fields.substring(0, fields.length() - 1);
        HashMap<String, String> signature = new HashMap<String, String>();
        signature.put("clear_signature", clearSignature);
        signature.put("fields", fields);
        return signature;
    }

    private String getValidIdentifier(Map<String, String> parameters) {
        String googleAdIdName = "gps_adid";
        String fireAdIdName = "fire_adid";
        String androidIdName = "android_id";
        String macSha1Name = "mac_sha1";
        String macMd5Name = "mac_md5";
        String androidUUIDName = "android_uuid";
        if (parameters.get(googleAdIdName) != null) {
            return googleAdIdName;
        }
        if (parameters.get(fireAdIdName) != null) {
            return fireAdIdName;
        }
        if (parameters.get(androidIdName) != null) {
            return androidIdName;
        }
        if (parameters.get(macSha1Name) != null) {
            return macSha1Name;
        }
        if (parameters.get(macMd5Name) != null) {
            return macMd5Name;
        }
        if (parameters.get(androidUUIDName) != null) {
            return androidUUIDName;
        }
        return null;
    }

    private static String extractAppSecret(Map<String, String> parameters) {
        return parameters.remove("app_secret");
    }

    private static String extractSecretId(Map<String, String> parameters) {
        return parameters.remove("secret_id");
    }

    private static String extractSignature(Map<String, String> parameters) {
        return parameters.remove("signature");
    }

    private static String extractAlgorithm(Map<String, String> parameters) {
        return parameters.remove("algorithm");
    }

    private static String extractNativeVersion(Map<String, String> parameters) {
        return parameters.remove("native_version");
    }

    private static String extractHeadersId(Map<String, String> parameters) {
        return parameters.remove("headers_id");
    }

    private static void extractEventCallbackId(Map<String, String> parameters) {
        parameters.remove("event_callback_id");
    }
}

