/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.scheduler;

import com.adjust.sdk.AdjustFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ThreadFactoryWrapper
implements ThreadFactory {
    private String source;

    public ThreadFactoryWrapper(String source) {
        this.source = source;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setPriority(9);
        thread.setName("Adjust-" + thread.getName() + "-" + this.source);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable tr) {
                AdjustFactory.getLogger().error("Thread [%s] with error [%s]", th.getName(), tr.getMessage());
            }
        });
        return thread;
    }
}

