/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.EventResponseData;
import com.adjust.sdk.SdkClickResponseData;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import java.util.Map;
import org.json.JSONObject;

public class ResponseData {
    public boolean success = false;
    public boolean willRetry = false;
    public String adid;
    public String message;
    public String timestamp;
    public JSONObject jsonResponse;
    public ActivityKind activityKind;
    public TrackingState trackingState;
    public AdjustAttribution attribution;
    public Long askIn;
    public Long retryIn;
    public Long continueIn;
    public ActivityPackage activityPackage;
    public Map<String, String> sendingParameters;

    protected ResponseData() {
    }

    public static ResponseData buildResponseData(ActivityPackage activityPackage, Map<String, String> sendingParameters) {
        ResponseData responseData;
        ActivityKind activityKind = activityPackage.getActivityKind();
        switch (activityKind) {
            case SESSION: {
                responseData = new SessionResponseData(activityPackage);
                break;
            }
            case CLICK: {
                responseData = new SdkClickResponseData();
                break;
            }
            case ATTRIBUTION: {
                responseData = new AttributionResponseData();
                break;
            }
            case EVENT: {
                responseData = new EventResponseData(activityPackage);
                break;
            }
            default: {
                responseData = new ResponseData();
            }
        }
        responseData.activityKind = activityKind;
        responseData.activityPackage = activityPackage;
        responseData.sendingParameters = sendingParameters;
        return responseData;
    }

    public String toString() {
        return Util.formatString("message:%s timestamp:%s json:%s", this.message, this.timestamp, this.jsonResponse);
    }
}

