/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.text.TextUtils;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAdRevenue;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustPlayStoreSubscription;
import com.adjust.sdk.AdjustSigner;
import com.adjust.sdk.AdjustThirdPartySharing;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.SessionParameters;
import com.adjust.sdk.Util;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PackageBuilder {
    private static ILogger logger = AdjustFactory.getLogger();
    private long createdAt;
    private DeviceInfo deviceInfo;
    private AdjustConfig adjustConfig;
    private ActivityStateCopy activityStateCopy;
    private SessionParameters sessionParameters;
    long clickTimeInSeconds = -1L;
    long clickTimeInMilliseconds = -1L;
    long installBeginTimeInSeconds = -1L;
    long clickTimeServerInSeconds = -1L;
    long installBeginTimeServerInSeconds = -1L;
    String reftag;
    String deeplink;
    String referrer;
    String installVersion;
    String rawReferrer;
    String referrerApi;
    String preinstallPayload;
    String preinstallLocation;
    Boolean googlePlayInstant;
    AdjustAttribution attribution;
    Map<String, String> extraParameters;

    PackageBuilder(AdjustConfig adjustConfig, DeviceInfo deviceInfo, ActivityState activityState, SessionParameters sessionParameters, long createdAt) {
        this.createdAt = createdAt;
        this.deviceInfo = deviceInfo;
        this.adjustConfig = adjustConfig;
        this.activityStateCopy = new ActivityStateCopy(activityState);
        this.sessionParameters = sessionParameters;
    }

    ActivityPackage buildSessionPackage(boolean isInDelay) {
        Map<String, String> parameters = this.getSessionParameters(isInDelay);
        ActivityPackage sessionPackage = this.getDefaultActivityPackage(ActivityKind.SESSION);
        sessionPackage.setPath("/session");
        sessionPackage.setSuffix("");
        AdjustSigner.sign(parameters, ActivityKind.SESSION.toString(), sessionPackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        sessionPackage.setParameters(parameters);
        return sessionPackage;
    }

    ActivityPackage buildEventPackage(AdjustEvent event, boolean isInDelay) {
        Map<String, String> parameters = this.getEventParameters(event, isInDelay);
        ActivityPackage eventPackage = this.getDefaultActivityPackage(ActivityKind.EVENT);
        eventPackage.setPath("/event");
        eventPackage.setSuffix(this.getEventSuffix(event));
        AdjustSigner.sign(parameters, ActivityKind.EVENT.toString(), eventPackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        eventPackage.setParameters(parameters);
        if (isInDelay) {
            eventPackage.setCallbackParameters(event.callbackParameters);
            eventPackage.setPartnerParameters(event.partnerParameters);
        }
        return eventPackage;
    }

    ActivityPackage buildInfoPackage(String source) {
        Map<String, String> parameters = this.getInfoParameters(source);
        ActivityPackage infoPackage = this.getDefaultActivityPackage(ActivityKind.INFO);
        infoPackage.setPath("/sdk_info");
        infoPackage.setSuffix("");
        AdjustSigner.sign(parameters, ActivityKind.INFO.toString(), infoPackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        infoPackage.setParameters(parameters);
        return infoPackage;
    }

    ActivityPackage buildClickPackage(String source) {
        Map<String, String> parameters = this.getClickParameters(source);
        ActivityPackage clickPackage = this.getDefaultActivityPackage(ActivityKind.CLICK);
        clickPackage.setPath("/sdk_click");
        clickPackage.setSuffix("");
        clickPackage.setClickTimeInMilliseconds(this.clickTimeInMilliseconds);
        clickPackage.setClickTimeInSeconds(this.clickTimeInSeconds);
        clickPackage.setInstallBeginTimeInSeconds(this.installBeginTimeInSeconds);
        clickPackage.setClickTimeServerInSeconds(this.clickTimeServerInSeconds);
        clickPackage.setInstallBeginTimeServerInSeconds(this.installBeginTimeServerInSeconds);
        clickPackage.setInstallVersion(this.installVersion);
        clickPackage.setGooglePlayInstant(this.googlePlayInstant);
        AdjustSigner.sign(parameters, ActivityKind.CLICK.toString(), clickPackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        clickPackage.setParameters(parameters);
        return clickPackage;
    }

    ActivityPackage buildAttributionPackage(String initiatedByDescription) {
        Map<String, String> parameters = this.getAttributionParameters(initiatedByDescription);
        ActivityPackage attributionPackage = this.getDefaultActivityPackage(ActivityKind.ATTRIBUTION);
        attributionPackage.setPath("attribution");
        attributionPackage.setSuffix("");
        AdjustSigner.sign(parameters, ActivityKind.ATTRIBUTION.toString(), attributionPackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        attributionPackage.setParameters(parameters);
        return attributionPackage;
    }

    ActivityPackage buildGdprPackage() {
        Map<String, String> parameters = this.getGdprParameters();
        ActivityPackage gdprPackage = this.getDefaultActivityPackage(ActivityKind.GDPR);
        gdprPackage.setPath("/gdpr_forget_device");
        gdprPackage.setSuffix("");
        AdjustSigner.sign(parameters, ActivityKind.GDPR.toString(), gdprPackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        gdprPackage.setParameters(parameters);
        return gdprPackage;
    }

    ActivityPackage buildDisableThirdPartySharingPackage() {
        Map<String, String> parameters = this.getDisableThirdPartySharingParameters();
        ActivityPackage activityPackage = this.getDefaultActivityPackage(ActivityKind.DISABLE_THIRD_PARTY_SHARING);
        activityPackage.setPath("/disable_third_party_sharing");
        activityPackage.setSuffix("");
        AdjustSigner.sign(parameters, ActivityKind.DISABLE_THIRD_PARTY_SHARING.toString(), activityPackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        activityPackage.setParameters(parameters);
        return activityPackage;
    }

    ActivityPackage buildThirdPartySharingPackage(AdjustThirdPartySharing adjustThirdPartySharing) {
        Map<String, String> parameters = this.getThirdPartySharingParameters(adjustThirdPartySharing);
        ActivityPackage activityPackage = this.getDefaultActivityPackage(ActivityKind.THIRD_PARTY_SHARING);
        activityPackage.setPath("/third_party_sharing");
        activityPackage.setSuffix("");
        AdjustSigner.sign(parameters, ActivityKind.THIRD_PARTY_SHARING.toString(), activityPackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        activityPackage.setParameters(parameters);
        return activityPackage;
    }

    ActivityPackage buildMeasurementConsentPackage(boolean consentMeasurement) {
        Map<String, String> parameters = this.getMeasurementConsentParameters(consentMeasurement);
        ActivityPackage activityPackage = this.getDefaultActivityPackage(ActivityKind.MEASUREMENT_CONSENT);
        activityPackage.setPath("/measurement_consent");
        activityPackage.setSuffix("");
        AdjustSigner.sign(parameters, ActivityKind.MEASUREMENT_CONSENT.toString(), activityPackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        activityPackage.setParameters(parameters);
        return activityPackage;
    }

    ActivityPackage buildAdRevenuePackage(String source, JSONObject adRevenueJson) {
        Map<String, String> parameters = this.getAdRevenueParameters(source, adRevenueJson);
        ActivityPackage adRevenuePackage = this.getDefaultActivityPackage(ActivityKind.AD_REVENUE);
        adRevenuePackage.setPath("/ad_revenue");
        adRevenuePackage.setSuffix("");
        AdjustSigner.sign(parameters, ActivityKind.AD_REVENUE.toString(), adRevenuePackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        adRevenuePackage.setParameters(parameters);
        return adRevenuePackage;
    }

    ActivityPackage buildAdRevenuePackage(AdjustAdRevenue adjustAdRevenue, boolean isInDelay) {
        Map<String, String> parameters = this.getAdRevenueParameters(adjustAdRevenue, isInDelay);
        ActivityPackage adRevenuePackage = this.getDefaultActivityPackage(ActivityKind.AD_REVENUE);
        adRevenuePackage.setPath("/ad_revenue");
        adRevenuePackage.setSuffix("");
        AdjustSigner.sign(parameters, ActivityKind.AD_REVENUE.toString(), adRevenuePackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        adRevenuePackage.setParameters(parameters);
        if (isInDelay) {
            adRevenuePackage.setCallbackParameters(adjustAdRevenue.callbackParameters);
            adRevenuePackage.setPartnerParameters(adjustAdRevenue.partnerParameters);
        }
        return adRevenuePackage;
    }

    ActivityPackage buildSubscriptionPackage(AdjustPlayStoreSubscription subscription, boolean isInDelay) {
        Map<String, String> parameters = this.getSubscriptionParameters(subscription, isInDelay);
        ActivityPackage subscriptionPackage = this.getDefaultActivityPackage(ActivityKind.SUBSCRIPTION);
        subscriptionPackage.setPath("/v2/purchase");
        subscriptionPackage.setSuffix("");
        AdjustSigner.sign(parameters, ActivityKind.SUBSCRIPTION.toString(), subscriptionPackage.getClientSdk(), this.adjustConfig.context, this.adjustConfig.logger);
        subscriptionPackage.setParameters(parameters);
        return subscriptionPackage;
    }

    private Map<String, String> getSessionParameters(boolean isInDelay) {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", this.sessionParameters.callbackParameters);
            PackageBuilder.addMapJson(parameters, "partner_params", this.sessionParameters.partnerParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "default_tracker", this.adjustConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adjustConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adjustConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addLong(parameters, "network_type", Util.getNetworkType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    public Map<String, String> getEventParameters(AdjustEvent event, boolean isInDelay) {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", Util.mergeParameters(this.sessionParameters.callbackParameters, event.callbackParameters, "Callback"));
            PackageBuilder.addMapJson(parameters, "partner_params", Util.mergeParameters(this.sessionParameters.partnerParameters, event.partnerParameters, "Partner"));
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "currency", event.currency);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adjustConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addString(parameters, "event_callback_id", event.callbackId);
        PackageBuilder.addLong(parameters, "event_count", this.activityStateCopy.eventCount);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "event_token", event.eventToken);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adjustConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addLong(parameters, "network_type", Util.getNetworkType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addDouble(parameters, "revenue", event.revenue);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getInfoParameters(String source) {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adjustConfig.needsCost);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addString(parameters, "source", source);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getClickParameters(String source) {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        if (this.attribution != null) {
            PackageBuilder.addString(parameters, "tracker", this.attribution.trackerName);
            PackageBuilder.addString(parameters, "campaign", this.attribution.campaign);
            PackageBuilder.addString(parameters, "adgroup", this.attribution.adgroup);
            PackageBuilder.addString(parameters, "creative", this.attribution.creative);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addMapJson(parameters, "callback_params", this.sessionParameters.callbackParameters);
        PackageBuilder.addDateInMilliseconds(parameters, "click_time", this.clickTimeInMilliseconds);
        PackageBuilder.addDateInSeconds(parameters, "click_time", this.clickTimeInSeconds);
        PackageBuilder.addDateInSeconds(parameters, "click_time_server", this.clickTimeServerInSeconds);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "deeplink", this.deeplink);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adjustConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addBoolean(parameters, "google_play_instant", this.googlePlayInstant);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addDateInSeconds(parameters, "install_begin_time", this.installBeginTimeInSeconds);
        PackageBuilder.addDateInSeconds(parameters, "install_begin_time_server", this.installBeginTimeServerInSeconds);
        PackageBuilder.addString(parameters, "install_version", this.installVersion);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adjustConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addLong(parameters, "network_type", Util.getNetworkType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addMapJson(parameters, "params", this.extraParameters);
        PackageBuilder.addMapJson(parameters, "partner_params", this.sessionParameters.partnerParameters);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "raw_referrer", this.rawReferrer);
        PackageBuilder.addString(parameters, "referrer", this.referrer);
        PackageBuilder.addString(parameters, "referrer_api", this.referrerApi);
        PackageBuilder.addString(parameters, "reftag", this.reftag);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addString(parameters, "source", source);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        PackageBuilder.addString(parameters, "payload", this.preinstallPayload);
        PackageBuilder.addString(parameters, "found_location", this.preinstallLocation);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getAttributionParameters(String initiatedBy) {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adjustConfig.needsCost);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "initiated_by", initiatedBy);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getGdprParameters() {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adjustConfig.needsCost);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getDisableThirdPartySharingParameters() {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adjustConfig.needsCost);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getThirdPartySharingParameters(AdjustThirdPartySharing adjustThirdPartySharing) {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        if (adjustThirdPartySharing.isEnabled != null) {
            PackageBuilder.addString(parameters, "sharing", adjustThirdPartySharing.isEnabled != false ? "enable" : "disable");
        }
        PackageBuilder.addMapJson(parameters, "granular_third_party_sharing_options", adjustThirdPartySharing.granularOptions);
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getMeasurementConsentParameters(boolean consentMeasurement) {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        PackageBuilder.addString(parameters, "measurement", consentMeasurement ? "enable" : "disable");
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getAdRevenueParameters(String source, JSONObject adRevenueJson) {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "default_tracker", this.adjustConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adjustConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adjustConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addLong(parameters, "network_type", Util.getNetworkType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addString(parameters, "source", source);
        PackageBuilder.addJsonObject(parameters, "payload", adRevenueJson);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getAdRevenueParameters(AdjustAdRevenue adjustAdRevenue, boolean isInDelay) {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", Util.mergeParameters(this.sessionParameters.callbackParameters, adjustAdRevenue.callbackParameters, "Callback"));
            PackageBuilder.addMapJson(parameters, "partner_params", Util.mergeParameters(this.sessionParameters.partnerParameters, adjustAdRevenue.partnerParameters, "Partner"));
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "default_tracker", this.adjustConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adjustConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adjustConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addLong(parameters, "network_type", Util.getNetworkType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addString(parameters, "source", adjustAdRevenue.source);
        PackageBuilder.addDoubleWithoutRounding(parameters, "revenue", adjustAdRevenue.revenue);
        PackageBuilder.addString(parameters, "currency", adjustAdRevenue.currency);
        PackageBuilder.addInteger(parameters, "ad_impressions_count", adjustAdRevenue.adImpressionsCount);
        PackageBuilder.addString(parameters, "ad_revenue_network", adjustAdRevenue.adRevenueNetwork);
        PackageBuilder.addString(parameters, "ad_revenue_unit", adjustAdRevenue.adRevenueUnit);
        PackageBuilder.addString(parameters, "ad_revenue_placement", adjustAdRevenue.adRevenuePlacement);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getSubscriptionParameters(AdjustPlayStoreSubscription subscription, boolean isInDelay) {
        Map<String, String> oaidParameters;
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if ((oaidParameters = Reflection.getOaidParameters(this.adjustConfig.context, logger)) != null) {
            parameters.putAll(oaidParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addLong(parameters, "gps_adid_attempt", this.deviceInfo.playAdIdAttempt);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        if (!this.containsPlayIds(parameters) && !this.containsFireIds(parameters)) {
            logger.warn("Google Advertising ID or Fire Advertising ID not detected, fallback to non Google Play and Fire identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        }
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", Util.mergeParameters(this.sessionParameters.callbackParameters, subscription.getCallbackParameters(), "Callback"));
            PackageBuilder.addMapJson(parameters, "partner_params", Util.mergeParameters(this.sessionParameters.partnerParameters, subscription.getPartnerParameters(), "Partner"));
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "default_tracker", this.adjustConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_cost", this.adjustConfig.needsCost);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "external_device_id", this.adjustConfig.externalDeviceId);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adjustConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addLong(parameters, "network_type", Util.getNetworkType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        PackageBuilder.addString(parameters, "billing_store", subscription.getBillingStore());
        PackageBuilder.addString(parameters, "currency", subscription.getCurrency());
        PackageBuilder.addString(parameters, "product_id", subscription.getSku());
        PackageBuilder.addString(parameters, "purchase_token", subscription.getPurchaseToken());
        PackageBuilder.addString(parameters, "receipt", subscription.getSignature());
        PackageBuilder.addLong(parameters, "revenue", subscription.getPrice());
        PackageBuilder.addDateInMilliseconds(parameters, "transaction_date", subscription.getPurchaseTime());
        PackageBuilder.addString(parameters, "transaction_id", subscription.getOrderId());
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private ActivityPackage getDefaultActivityPackage(ActivityKind activityKind) {
        ActivityPackage activityPackage = new ActivityPackage(activityKind);
        activityPackage.setClientSdk(this.deviceInfo.clientSdk);
        return activityPackage;
    }

    public static void addString(Map<String, String> parameters, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        parameters.put(key, value);
    }

    public static void addBoolean(Map<String, String> parameters, String key, Boolean value) {
        if (value == null) {
            return;
        }
        int intValue = value != false ? 1 : 0;
        PackageBuilder.addLong(parameters, key, intValue);
    }

    static void addJsonObject(Map<String, String> parameters, String key, JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        PackageBuilder.addString(parameters, key, jsonObject.toString());
    }

    static void addMapJson(Map<String, String> parameters, String key, Map map) {
        if (map == null) {
            return;
        }
        if (map.size() == 0) {
            return;
        }
        JSONObject jsonObject = new JSONObject(map);
        String jsonString = jsonObject.toString();
        PackageBuilder.addString(parameters, key, jsonString);
    }

    public static void addLong(Map<String, String> parameters, String key, long value) {
        if (value < 0L) {
            return;
        }
        String valueString = Long.toString(value);
        PackageBuilder.addString(parameters, key, valueString);
    }

    private static void addDateInMilliseconds(Map<String, String> parameters, String key, long value) {
        if (value <= 0L) {
            return;
        }
        Date date = new Date(value);
        PackageBuilder.addDate(parameters, key, date);
    }

    private static void addDateInSeconds(Map<String, String> parameters, String key, long value) {
        if (value <= 0L) {
            return;
        }
        Date date = new Date(value * 1000L);
        PackageBuilder.addDate(parameters, key, date);
    }

    private static void addDate(Map<String, String> parameters, String key, Date value) {
        if (value == null) {
            return;
        }
        String dateString = Util.dateFormatter.format(value);
        PackageBuilder.addString(parameters, key, dateString);
    }

    private static void addDuration(Map<String, String> parameters, String key, long durationInMilliSeconds) {
        if (durationInMilliSeconds < 0L) {
            return;
        }
        long durationInSeconds = (durationInMilliSeconds + 500L) / 1000L;
        PackageBuilder.addLong(parameters, key, durationInSeconds);
    }

    private static void addDouble(Map<String, String> parameters, String key, Double value) {
        if (value == null) {
            return;
        }
        String doubleString = Util.formatString("%.5f", value);
        PackageBuilder.addString(parameters, key, doubleString);
    }

    private static void addDoubleWithoutRounding(Map<String, String> parameters, String key, Double value) {
        if (value == null) {
            return;
        }
        String doubleString = Double.toString(value);
        PackageBuilder.addString(parameters, key, doubleString);
    }

    private static void addInteger(Map<String, String> parameters, String key, Integer value) {
        if (value == null) {
            return;
        }
        String intString = Integer.toString(value);
        PackageBuilder.addString(parameters, key, intString);
    }

    private boolean containsPlayIds(Map<String, String> parameters) {
        if (parameters == null) {
            return false;
        }
        return parameters.containsKey("gps_adid");
    }

    private boolean containsFireIds(Map<String, String> parameters) {
        if (parameters == null) {
            return false;
        }
        return parameters.containsKey("fire_adid");
    }

    private void checkDeviceIds(Map<String, String> parameters) {
        if (!(parameters == null || parameters.containsKey("mac_sha1") || parameters.containsKey("mac_md5") || parameters.containsKey("android_id") || parameters.containsKey("gps_adid") || parameters.containsKey("oaid") || parameters.containsKey("imei") || parameters.containsKey("meid") || parameters.containsKey("device_id") || parameters.containsKey("imeis") || parameters.containsKey("meids") || parameters.containsKey("device_ids"))) {
            logger.error("Missing device id's. Please check if Proguard is correctly set with Adjust SDK", new Object[0]);
        }
    }

    private String getEventSuffix(AdjustEvent event) {
        if (event.revenue == null) {
            return Util.formatString("'%s'", event.eventToken);
        }
        return Util.formatString("(%.5f %s, '%s')", event.revenue, event.currency, event.eventToken);
    }

    private class ActivityStateCopy {
        int eventCount = -1;
        int sessionCount = -1;
        int subsessionCount = -1;
        long timeSpent = -1L;
        long lastInterval = -1L;
        long sessionLength = -1L;
        String uuid = null;
        String pushToken = null;

        ActivityStateCopy(ActivityState activityState) {
            if (activityState == null) {
                return;
            }
            this.eventCount = activityState.eventCount;
            this.sessionCount = activityState.sessionCount;
            this.subsessionCount = activityState.subsessionCount;
            this.timeSpent = activityState.timeSpent;
            this.lastInterval = activityState.lastInterval;
            this.sessionLength = activityState.sessionLength;
            this.uuid = activityState.uuid;
            this.pushToken = activityState.pushToken;
        }
    }
}

