/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ActivityPackage
implements Serializable {
    private static final long serialVersionUID = -35935556512024097L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("path", String.class), new ObjectStreamField("clientSdk", String.class), new ObjectStreamField("parameters", Map.class), new ObjectStreamField("activityKind", ActivityKind.class), new ObjectStreamField("suffix", String.class), new ObjectStreamField("callbackParameters", Map.class), new ObjectStreamField("partnerParameters", Map.class)};
    private transient int hashCode;
    private String path;
    private String clientSdk;
    private Map<String, String> parameters;
    private ActivityKind activityKind = ActivityKind.UNKNOWN;
    private String suffix;
    private Map<String, String> callbackParameters;
    private Map<String, String> partnerParameters;
    private int retries;
    private long clickTimeInMilliseconds;
    private long clickTimeInSeconds;
    private long installBeginTimeInSeconds;
    private long clickTimeServerInSeconds;
    private long installBeginTimeServerInSeconds;
    private String installVersion;
    private Boolean googlePlayInstant;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getClientSdk() {
        return this.clientSdk;
    }

    public void setClientSdk(String clientSdk) {
        this.clientSdk = clientSdk;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setCallbackParameters(Map<String, String> callbackParameters) {
        this.callbackParameters = callbackParameters;
    }

    public void setPartnerParameters(Map<String, String> partnerParameters) {
        this.partnerParameters = partnerParameters;
    }

    public ActivityKind getActivityKind() {
        return this.activityKind;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public int getRetries() {
        return this.retries;
    }

    public int increaseRetries() {
        ++this.retries;
        return this.retries;
    }

    public long getClickTimeInMilliseconds() {
        return this.clickTimeInMilliseconds;
    }

    public void setClickTimeInMilliseconds(long clickTimeInMilliseconds) {
        this.clickTimeInMilliseconds = clickTimeInMilliseconds;
    }

    public long getClickTimeInSeconds() {
        return this.clickTimeInSeconds;
    }

    public void setClickTimeInSeconds(long clickTimeInSeconds) {
        this.clickTimeInSeconds = clickTimeInSeconds;
    }

    public long getInstallBeginTimeInSeconds() {
        return this.installBeginTimeInSeconds;
    }

    public void setInstallBeginTimeInSeconds(long installBeginTimeInSeconds) {
        this.installBeginTimeInSeconds = installBeginTimeInSeconds;
    }

    public long getClickTimeServerInSeconds() {
        return this.clickTimeServerInSeconds;
    }

    public void setClickTimeServerInSeconds(long clickTimeServerInSeconds) {
        this.clickTimeServerInSeconds = clickTimeServerInSeconds;
    }

    public long getInstallBeginTimeServerInSeconds() {
        return this.installBeginTimeServerInSeconds;
    }

    public void setInstallBeginTimeServerInSeconds(long installBeginTimeServerInSeconds) {
        this.installBeginTimeServerInSeconds = installBeginTimeServerInSeconds;
    }

    public String getInstallVersion() {
        return this.installVersion;
    }

    public void setInstallVersion(String installVersion) {
        this.installVersion = installVersion;
    }

    public Boolean getGooglePlayInstant() {
        return this.googlePlayInstant;
    }

    public void setGooglePlayInstant(Boolean googlePlayInstant) {
        this.googlePlayInstant = googlePlayInstant;
    }

    public Map<String, String> getCallbackParameters() {
        return this.callbackParameters;
    }

    public Map<String, String> getPartnerParameters() {
        return this.partnerParameters;
    }

    public ActivityPackage(ActivityKind activityKind) {
        this.activityKind = activityKind;
    }

    public String toString() {
        return Util.formatString("%s%s", this.activityKind.toString(), this.suffix);
    }

    public String getExtendedString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Util.formatString("Path:      %s\n", this.path));
        builder.append(Util.formatString("ClientSdk: %s\n", this.clientSdk));
        if (this.parameters != null) {
            builder.append("Parameters:");
            TreeMap<String, String> sortedParameters = new TreeMap<String, String>(this.parameters);
            List<String> stringsToExclude = Arrays.asList("app_secret", "secret_id", "event_callback_id");
            for (Map.Entry entry : sortedParameters.entrySet()) {
                String key = (String)entry.getKey();
                if (stringsToExclude.contains(key)) continue;
                builder.append(Util.formatString("\n\t%-16s %s", key, entry.getValue()));
            }
        }
        return builder.toString();
    }

    public String getFailureMessage() {
        return Util.formatString("Failed to track %s%s", this.activityKind.toString(), this.suffix);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.path = Util.readStringField(fields, "path", null);
        this.clientSdk = Util.readStringField(fields, "clientSdk", null);
        this.parameters = Util.readObjectField(fields, "parameters", null);
        this.activityKind = Util.readObjectField(fields, "activityKind", ActivityKind.UNKNOWN);
        this.suffix = Util.readStringField(fields, "suffix", null);
        this.callbackParameters = Util.readObjectField(fields, "callbackParameters", null);
        this.partnerParameters = Util.readObjectField(fields, "partnerParameters", null);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ActivityPackage otherActivityPackage = (ActivityPackage)other;
        if (!Util.equalString(this.path, otherActivityPackage.path)) {
            return false;
        }
        if (!Util.equalString(this.clientSdk, otherActivityPackage.clientSdk)) {
            return false;
        }
        if (!Util.equalObject(this.parameters, otherActivityPackage.parameters)) {
            return false;
        }
        if (!Util.equalEnum(this.activityKind, otherActivityPackage.activityKind)) {
            return false;
        }
        if (!Util.equalString(this.suffix, otherActivityPackage.suffix)) {
            return false;
        }
        if (!Util.equalObject(this.callbackParameters, otherActivityPackage.callbackParameters)) {
            return false;
        }
        return Util.equalObject(this.partnerParameters, otherActivityPackage.partnerParameters);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + Util.hashString(this.path);
            this.hashCode = 37 * this.hashCode + Util.hashString(this.clientSdk);
            this.hashCode = 37 * this.hashCode + Util.hashObject(this.parameters);
            this.hashCode = 37 * this.hashCode + Util.hashEnum(this.activityKind);
            this.hashCode = 37 * this.hashCode + Util.hashString(this.suffix);
            this.hashCode = 37 * this.hashCode + Util.hashObject(this.callbackParameters);
            this.hashCode = 37 * this.hashCode + Util.hashObject(this.partnerParameters);
        }
        return this.hashCode;
    }
}

