/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.LocaleList;
import android.os.Looper;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AndroidIdUtil;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.GooglePlayServicesClient;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.MacAddressUtil;
import com.adjust.sdk.OnDeviceIdsRead;
import com.adjust.sdk.ReferrerDetails;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.scheduler.SingleThreadFutureScheduler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z";
    private static final String fieldReadErrorMessage = "Unable to read '%s' field in migration device with message (%s)";
    public static final DecimalFormat SecondsDisplayFormat = Util.newLocalDecimalFormat();
    public static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z", Locale.US);
    private static volatile SingleThreadFutureScheduler playAdIdScheduler = null;

    private static ILogger getLogger() {
        return AdjustFactory.getLogger();
    }

    protected static String createUuid() {
        return UUID.randomUUID().toString();
    }

    private static DecimalFormat newLocalDecimalFormat() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        return new DecimalFormat("0.0", symbols);
    }

    public static String quote(String string) {
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        return Util.formatString("'%s'", string);
    }

    public static Object getAdvertisingInfoObject(final Context context, long timeoutMilli) {
        return Util.runSyncInPlayAdIdSchedulerWithTimeout(context, new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    return Reflection.getAdvertisingInfoObject(context);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }, timeoutMilli);
    }

    public static String getPlayAdId(final Context context, final Object advertisingInfoObject, long timeoutMilli) {
        return Util.runSyncInPlayAdIdSchedulerWithTimeout(context, new Callable<String>(){

            @Override
            public String call() {
                return Reflection.getPlayAdId(context, advertisingInfoObject);
            }
        }, timeoutMilli);
    }

    public static Boolean isPlayTrackingEnabled(final Context context, final Object advertisingInfoObject, long timeoutMilli) {
        return Util.runSyncInPlayAdIdSchedulerWithTimeout(context, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return Reflection.isPlayTrackingEnabled(context, advertisingInfoObject);
            }
        }, timeoutMilli);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static <R> R runSyncInPlayAdIdSchedulerWithTimeout(Context context, Callable<R> callable, long timeoutMilli) {
        if (playAdIdScheduler == null) {
            Class<Util> clazz = Util.class;
            // MONITORENTER : com.adjust.sdk.Util.class
            if (playAdIdScheduler == null) {
                playAdIdScheduler = new SingleThreadFutureScheduler("PlayAdIdLibrary", true);
            }
            // MONITOREXIT : clazz
        }
        ScheduledFuture<R> playAdIdFuture = playAdIdScheduler.scheduleFutureWithReturn(callable, 0L);
        try {
            return (R)playAdIdFuture.get(timeoutMilli, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return null;
    }

    public static void runInBackground(Runnable command) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            command.run();
            return;
        }
        new AsyncTask<Object, Void, Void>(){

            protected Void doInBackground(Object ... params) {
                Runnable command = (Runnable)params[0];
                command.run();
                return null;
            }
        }.execute(new Object[]{command});
    }

    public static void getGoogleAdId(Context context, final OnDeviceIdsRead onDeviceIdRead) {
        ILogger logger = AdjustFactory.getLogger();
        if (Looper.myLooper() != Looper.getMainLooper()) {
            logger.debug("GoogleAdId being read in the background", new Object[0]);
            String GoogleAdId = Util.getGoogleAdId(context);
            logger.debug("GoogleAdId read " + GoogleAdId, new Object[0]);
            onDeviceIdRead.onGoogleAdIdRead(GoogleAdId);
            return;
        }
        logger.debug("GoogleAdId being read in the foreground", new Object[0]);
        new AsyncTask<Context, Void, String>(){

            protected String doInBackground(Context ... params) {
                ILogger logger = AdjustFactory.getLogger();
                Context innerContext = params[0];
                String innerResult = Util.getGoogleAdId(innerContext);
                logger.debug("GoogleAdId read " + innerResult, new Object[0]);
                return innerResult;
            }

            protected void onPostExecute(String playAdiId) {
                ILogger logger = AdjustFactory.getLogger();
                onDeviceIdRead.onGoogleAdIdRead(playAdiId);
            }
        }.execute((Object[])new Context[]{context});
    }

    private static String getGoogleAdId(Context context) {
        Object advertisingInfoObject;
        String googleAdId = null;
        try {
            GooglePlayServicesClient.GooglePlayServicesInfo gpsInfo = GooglePlayServicesClient.getGooglePlayServicesInfo(context, 11000L);
            if (gpsInfo != null) {
                googleAdId = gpsInfo.getGpsAdid();
            }
        }
        catch (Exception gpsInfo) {
            // empty catch block
        }
        if (googleAdId == null && (advertisingInfoObject = Util.getAdvertisingInfoObject(context, 11000L)) != null) {
            googleAdId = Util.getPlayAdId(context, advertisingInfoObject, 1000L);
        }
        return googleAdId;
    }

    public static String getMacAddress(Context context) {
        return MacAddressUtil.getMacAddress(context);
    }

    public static String getAndroidId(Context context) {
        return AndroidIdUtil.getAndroidId(context);
    }

    public static <T> T readObject(Context context, String filename, String objectName, Class<T> type) {
        InputStream closable = null;
        T object = null;
        try {
            FileInputStream inputStream = context.openFileInput(filename);
            closable = inputStream;
            BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
            closable = bufferedStream;
            ObjectInputStream objectStream = new ObjectInputStream(bufferedStream);
            closable = objectStream;
            try {
                object = type.cast(objectStream.readObject());
                Util.getLogger().debug("Read %s: %s", objectName, object);
            }
            catch (ClassNotFoundException e) {
                Util.getLogger().error("Failed to find %s class (%s)", objectName, e.getMessage());
            }
            catch (ClassCastException e) {
                Util.getLogger().error("Failed to cast %s object (%s)", objectName, e.getMessage());
            }
            catch (Exception e) {
                Util.getLogger().error("Failed to read %s object (%s)", objectName, e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            Util.getLogger().debug("%s file not found", objectName);
        }
        catch (Exception e) {
            Util.getLogger().error("Failed to open %s file for reading (%s)", objectName, e);
        }
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Exception e) {
            Util.getLogger().error("Failed to close %s file for reading (%s)", objectName, e);
        }
        return object;
    }

    public static <T> void writeObject(T object, Context context, String filename, String objectName) {
        OutputStream closable = null;
        try {
            FileOutputStream outputStream = context.openFileOutput(filename, 0);
            closable = outputStream;
            BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
            closable = bufferedStream;
            ObjectOutputStream objectStream = new ObjectOutputStream(bufferedStream);
            closable = objectStream;
            try {
                objectStream.writeObject(object);
                Util.getLogger().debug("Wrote %s: %s", objectName, object);
            }
            catch (NotSerializableException e) {
                Util.getLogger().error("Failed to serialize %s", objectName);
            }
        }
        catch (Exception e) {
            Util.getLogger().error("Failed to open %s for writing (%s)", objectName, e);
        }
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Exception e) {
            Util.getLogger().error("Failed to close %s file for writing (%s)", objectName, e);
        }
    }

    public static boolean checkPermission(Context context, String permission2) {
        try {
            int result = context.checkCallingOrSelfPermission(permission2);
            return result == 0;
        }
        catch (Exception e) {
            Util.getLogger().debug("Unable to check permission '%s' with message (%s)", permission2, e.getMessage());
            return false;
        }
    }

    public static String readStringField(ObjectInputStream.GetField fields, String name, String defaultValue) {
        return Util.readObjectField(fields, name, defaultValue);
    }

    public static <T> T readObjectField(ObjectInputStream.GetField fields, String name, T defaultValue) {
        try {
            return (T)fields.get(name, defaultValue);
        }
        catch (Exception e) {
            Util.getLogger().debug(fieldReadErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    public static boolean readBooleanField(ObjectInputStream.GetField fields, String name, boolean defaultValue) {
        try {
            return fields.get(name, defaultValue);
        }
        catch (Exception e) {
            Util.getLogger().debug(fieldReadErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    public static int readIntField(ObjectInputStream.GetField fields, String name, int defaultValue) {
        try {
            return fields.get(name, defaultValue);
        }
        catch (Exception e) {
            Util.getLogger().debug(fieldReadErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    public static long readLongField(ObjectInputStream.GetField fields, String name, long defaultValue) {
        try {
            return fields.get(name, defaultValue);
        }
        catch (Exception e) {
            Util.getLogger().debug(fieldReadErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    public static boolean equalObject(Object first, Object second) {
        if (first == null || second == null) {
            return first == null && second == null;
        }
        return first.equals(second);
    }

    public static boolean equalsDouble(Double first, Double second) {
        if (first == null || second == null) {
            return first == null && second == null;
        }
        return Double.doubleToLongBits(first) == Double.doubleToLongBits(second);
    }

    public static boolean equalString(String first, String second) {
        return Util.equalObject(first, second);
    }

    public static boolean equalEnum(Enum first, Enum second) {
        return Util.equalObject(first, second);
    }

    public static boolean equalLong(Long first, Long second) {
        return Util.equalObject(first, second);
    }

    public static boolean equalInt(Integer first, Integer second) {
        return Util.equalObject(first, second);
    }

    public static boolean equalBoolean(Boolean first, Boolean second) {
        return Util.equalObject(first, second);
    }

    public static int hashBoolean(Boolean value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static int hashLong(Long value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static int hashDouble(Double value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static int hashString(String value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static int hashEnum(Enum value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static int hashObject(Object value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static String sha1(String text) {
        return Util.hash(text, "SHA-1");
    }

    public static String sha256(String text) {
        return Util.hash(text, "SHA-256");
    }

    public static String md5(String text) {
        return Util.hash(text, "MD5");
    }

    public static String hash(String text, String method) {
        String hashString = null;
        try {
            byte[] bytes = text.getBytes("UTF-8");
            MessageDigest mesd = MessageDigest.getInstance(method);
            mesd.update(bytes, 0, bytes.length);
            byte[] hash = mesd.digest();
            hashString = Util.convertToHex(hash);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashString;
    }

    public static String convertToHex(byte[] bytes) {
        BigInteger bigInt = new BigInteger(1, bytes);
        String formatString = "%0" + (bytes.length << 1) + "x";
        return Util.formatString(formatString, bigInt);
    }

    public static String[] getSupportedAbis() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        return null;
    }

    public static String getCpuAbi() {
        if (Build.VERSION.SDK_INT < 21) {
            return Build.CPU_ABI;
        }
        return null;
    }

    public static String getReasonString(String message, Throwable throwable) {
        if (throwable != null) {
            return Util.formatString("%s: %s", message, throwable);
        }
        return Util.formatString("%s", message);
    }

    public static long getWaitingTime(int retries, BackoffStrategy backoffStrategy) {
        if (retries < backoffStrategy.minRetries) {
            return 0L;
        }
        int expon = retries - backoffStrategy.minRetries;
        long exponentialTime = (long)Math.pow(2.0, expon) * backoffStrategy.milliSecondMultiplier;
        long ceilingTime = Math.min(exponentialTime, backoffStrategy.maxWait);
        double randomDouble = Util.randomInRange(backoffStrategy.minRange, backoffStrategy.maxRange);
        double waitingTime = (double)ceilingTime * randomDouble;
        return (long)waitingTime;
    }

    private static double randomInRange(double minRange, double maxRange) {
        Random random = new Random();
        double range = maxRange - minRange;
        double scaled = random.nextDouble() * range;
        double shifted = scaled + minRange;
        return shifted;
    }

    public static boolean isValidParameter(String attribute, String attributeType, String parameterName) {
        if (attribute == null) {
            Util.getLogger().error("%s parameter %s is missing", parameterName, attributeType);
            return false;
        }
        if (attribute.equals("")) {
            Util.getLogger().error("%s parameter %s is empty", parameterName, attributeType);
            return false;
        }
        return true;
    }

    public static Map<String, String> mergeParameters(Map<String, String> target, Map<String, String> source, String parameterName) {
        if (target == null) {
            return source;
        }
        if (source == null) {
            return target;
        }
        HashMap<String, String> mergedParameters = new HashMap<String, String>(target);
        ILogger logger = Util.getLogger();
        for (Map.Entry<String, String> parameterSourceEntry : source.entrySet()) {
            String oldValue = mergedParameters.put(parameterSourceEntry.getKey(), parameterSourceEntry.getValue());
            if (oldValue == null) continue;
            logger.warn("Key %s with value %s from %s parameter was replaced by value %s", parameterSourceEntry.getKey(), oldValue, parameterName, parameterSourceEntry.getValue());
        }
        return mergedParameters;
    }

    public static Locale getLocale(Configuration configuration) {
        LocaleList localesList;
        if (Build.VERSION.SDK_INT >= 24 && (localesList = configuration.getLocales()) != null && !localesList.isEmpty()) {
            return localesList.get(0);
        }
        if (Build.VERSION.SDK_INT < 24) {
            return configuration.locale;
        }
        return null;
    }

    public static String getFireAdvertisingId(ContentResolver contentResolver) {
        if (contentResolver == null) {
            return null;
        }
        try {
            return Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Boolean getFireTrackingEnabled(ContentResolver contentResolver) {
        try {
            return Settings.Secure.getInt((ContentResolver)contentResolver, (String)"limit_ad_tracking") == 0;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getConnectivityType(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return -1;
            }
            if (Build.VERSION.SDK_INT < 23) {
                NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
                return activeNetwork.getType();
            }
            Network activeNetwork = cm.getActiveNetwork();
            if (activeNetwork == null) {
                return -1;
            }
            NetworkCapabilities activeNetworkCapabilities = cm.getNetworkCapabilities(activeNetwork);
            if (activeNetworkCapabilities == null) {
                return -1;
            }
            if (activeNetworkCapabilities.hasTransport(1)) {
                return 1;
            }
            if (activeNetworkCapabilities.hasTransport(0)) {
                return 0;
            }
            if (activeNetworkCapabilities.hasTransport(3)) {
                return 3;
            }
            if (activeNetworkCapabilities.hasTransport(4)) {
                return 4;
            }
            if (activeNetworkCapabilities.hasTransport(2)) {
                return 2;
            }
            if (Build.VERSION.SDK_INT < 26) {
                return -1;
            }
            if (activeNetworkCapabilities.hasTransport(5)) {
                return 5;
            }
            if (Build.VERSION.SDK_INT < 27) {
                return -1;
            }
            if (activeNetworkCapabilities.hasTransport(6)) {
                return 6;
            }
        }
        catch (Exception e) {
            Util.getLogger().warn("Couldn't read connectivity type (%s)", e.getMessage());
        }
        return -1;
    }

    public static int getNetworkType(Context context) {
        int networkType = -1;
        try {
            TelephonyManager teleMan = (TelephonyManager)context.getSystemService("phone");
            networkType = Build.VERSION.SDK_INT >= 30 ? teleMan.getDataNetworkType() : teleMan.getNetworkType();
        }
        catch (Exception e) {
            Util.getLogger().warn("Couldn't read network type (%s)", e.getMessage());
        }
        return networkType;
    }

    public static String getMcc(Context context) {
        try {
            TelephonyManager tel = (TelephonyManager)context.getSystemService("phone");
            String networkOperator = tel.getNetworkOperator();
            if (TextUtils.isEmpty((CharSequence)networkOperator)) {
                AdjustFactory.getLogger().warn("Couldn't receive networkOperator string to read MCC", new Object[0]);
                return null;
            }
            return networkOperator.substring(0, 3);
        }
        catch (Exception ex) {
            AdjustFactory.getLogger().warn("Couldn't return mcc", new Object[0]);
            return null;
        }
    }

    public static String getMnc(Context context) {
        try {
            TelephonyManager tel = (TelephonyManager)context.getSystemService("phone");
            String networkOperator = tel.getNetworkOperator();
            if (TextUtils.isEmpty((CharSequence)networkOperator)) {
                AdjustFactory.getLogger().warn("Couldn't receive networkOperator string to read MNC", new Object[0]);
                return null;
            }
            return networkOperator.substring(3);
        }
        catch (Exception ex) {
            AdjustFactory.getLogger().warn("Couldn't return mnc", new Object[0]);
            return null;
        }
    }

    public static String formatString(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    public static boolean hasRootCause(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String sStackTrace = sw.toString();
        return sStackTrace.contains("Caused by:");
    }

    public static String getRootCause(Exception ex) {
        if (!Util.hasRootCause(ex)) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String sStackTrace = sw.toString();
        int startOccuranceOfRootCause = sStackTrace.indexOf("Caused by:");
        int endOccuranceOfRootCause = sStackTrace.indexOf("\n", startOccuranceOfRootCause);
        return sStackTrace.substring(startOccuranceOfRootCause, endOccuranceOfRootCause);
    }

    private static String getSdkPrefix(String clientSdk) {
        if (clientSdk == null) {
            return null;
        }
        if (!clientSdk.contains("@")) {
            return null;
        }
        String[] splitted = clientSdk.split("@");
        if (splitted == null) {
            return null;
        }
        if (splitted.length != 2) {
            return null;
        }
        return splitted[0];
    }

    public static String getSdkPrefixPlatform(String clientSdk) {
        String sdkPrefix = Util.getSdkPrefix(clientSdk);
        if (sdkPrefix == null) {
            return null;
        }
        String[] splitted = sdkPrefix.split("\\d+", 2);
        if (splitted == null) {
            return null;
        }
        if (splitted.length == 0) {
            return null;
        }
        return splitted[0];
    }

    public static boolean isUrlFilteredOut(Uri url) {
        if (url == null) {
            return true;
        }
        String urlString = url.toString();
        if (urlString == null || urlString.length() == 0) {
            return true;
        }
        return urlString.matches("^(fb|vk)[0-9]{5,}[^:]*://authorize.*access_token=.*");
    }

    public static String getSdkVersion() {
        return "android4.26.2";
    }

    public static boolean resolveContentProvider(Context applicationContext, String authority) {
        try {
            return applicationContext.getPackageManager().resolveContentProvider(authority, 0) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEqualReferrerDetails(ReferrerDetails referrerDetails, String referrerApi, ActivityState activityState) {
        if (referrerApi.equals("google")) {
            return Util.isEqualGoogleReferrerDetails(referrerDetails, activityState);
        }
        if (referrerApi.equals("huawei")) {
            return Util.isEqualHuaweiReferrerDetails(referrerDetails, activityState);
        }
        return false;
    }

    private static boolean isEqualGoogleReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTime && referrerDetails.installBeginTimestampSeconds == activityState.installBegin && referrerDetails.referrerClickTimestampServerSeconds == activityState.clickTimeServer && referrerDetails.installBeginTimestampServerSeconds == activityState.installBeginServer && Util.equalString(referrerDetails.installReferrer, activityState.installReferrer) && Util.equalString(referrerDetails.installVersion, activityState.installVersion) && Util.equalBoolean(referrerDetails.googlePlayInstant, activityState.googlePlayInstant);
    }

    private static boolean isEqualHuaweiReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeHuawei && referrerDetails.installBeginTimestampSeconds == activityState.installBeginHuawei && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerHuawei);
    }
}

