/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.InstallReferrerReadListener;
import com.adjust.sdk.Util;
import java.util.concurrent.atomic.AtomicBoolean;

public class InstallReferrerHuawei {
    private static final String REFERRER_PROVIDER_AUTHORITY = "com.huawei.appmarket.commondata";
    private static final String REFERRER_PROVIDER_URI = "content://com.huawei.appmarket.commondata/item/5";
    private ILogger logger = AdjustFactory.getLogger();
    private Context context;
    private final InstallReferrerReadListener referrerCallback;
    private final AtomicBoolean shouldTryToRead;

    public InstallReferrerHuawei(Context context, InstallReferrerReadListener referrerCallback) {
        this.context = context;
        this.referrerCallback = referrerCallback;
        this.shouldTryToRead = new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readReferrer() {
        if (!this.shouldTryToRead.get()) {
            this.logger.debug("Should not try to read Install referrer Huawei", new Object[0]);
            return;
        }
        if (!Util.resolveContentProvider(this.context, REFERRER_PROVIDER_AUTHORITY)) {
            return;
        }
        Cursor cursor = null;
        Uri uri = Uri.parse((String)REFERRER_PROVIDER_URI);
        ContentResolver contentResolver = this.context.getContentResolver();
        String[] packageName = new String[]{this.context.getPackageName()};
        try {
            cursor = contentResolver.query(uri, null, null, packageName, null);
            if (cursor != null && cursor.moveToFirst()) {
                String installReferrer = cursor.getString(0);
                String clickTime = cursor.getString(1);
                String installTime = cursor.getString(2);
                this.logger.debug("InstallReferrerHuawei reads referrer[%s] clickTime[%s] installTime[%s]", installReferrer, clickTime, installTime);
                long referrerClickTimestampSeconds = Long.parseLong(clickTime);
                long installBeginTimestampSeconds = Long.parseLong(installTime);
                this.referrerCallback.onInstallReferrerRead(installReferrer, referrerClickTimestampSeconds, installBeginTimestampSeconds);
            } else {
                this.logger.debug("InstallReferrerHuawei fail to read referrer for package [%s] and content uri [%s]", this.context.getPackageName(), uri.toString());
            }
        }
        catch (Exception e) {
            this.logger.debug("InstallReferrerHuawei error [%s]", e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        this.shouldTryToRead.set(false);
    }
}

