/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class GooglePlayServicesClient {
    public static GooglePlayServicesInfo getGooglePlayServicesInfo(Context context) throws Exception {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Google Play Services info can't be accessed from the main thread");
        }
        PackageManager pm = context.getPackageManager();
        pm.getPackageInfo("com.android.vending", 0);
        GooglePlayServicesConnection connection = new GooglePlayServicesConnection();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (context.bindService(intent, (ServiceConnection)connection, 1)) {
            try {
                GooglePlayServicesInfo googlePlayServicesInfo;
                GooglePlayServicesInterface gpsInterface = new GooglePlayServicesInterface(connection.getBinder());
                GooglePlayServicesInfo googlePlayServicesInfo2 = googlePlayServicesInfo = new GooglePlayServicesInfo(gpsInterface.getGpsAdid(), gpsInterface.getTrackingEnabled(true));
                return googlePlayServicesInfo2;
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                context.unbindService((ServiceConnection)connection);
            }
        }
        throw new IOException("Google Play connection failed");
    }

    private static final class GooglePlayServicesInterface
    implements IInterface {
        private IBinder binder;

        public GooglePlayServicesInterface(IBinder pBinder) {
            this.binder = pBinder;
        }

        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getGpsAdid() throws RemoteException {
            String id;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                id = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean getTrackingEnabled(boolean paramBoolean) throws RemoteException {
            Boolean limitAdTracking;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return limitAdTracking != null ? Boolean.valueOf(limitAdTracking == false) : null;
        }
    }

    private static final class GooglePlayServicesConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        private GooglePlayServicesConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.queue.put(service);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder getBinder() throws InterruptedException {
            if (this.retrieved) {
                throw new IllegalStateException();
            }
            this.retrieved = true;
            return this.queue.poll(1000L, TimeUnit.MILLISECONDS);
        }
    }

    public static final class GooglePlayServicesInfo {
        private final String gpsAdid;
        private final Boolean trackingEnabled;

        GooglePlayServicesInfo(String gpdAdid, Boolean trackingEnabled) {
            this.gpsAdid = gpdAdid;
            this.trackingEnabled = trackingEnabled;
        }

        public String getGpsAdid() {
            return this.gpsAdid;
        }

        public Boolean isTrackingEnabled() {
            return this.trackingEnabled;
        }
    }
}

