/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TimerCycle {
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture waitingTask;
    private Runnable command;
    private long initialDelay;
    private long cycleDelay;
    private boolean isPaused;

    public TimerCycle(Runnable command, long initialDelay, long cycleDelay) {
        this.command = command;
        this.initialDelay = initialDelay;
        this.cycleDelay = cycleDelay;
        this.isPaused = true;
    }

    public void start() {
        if (!this.isPaused) {
            return;
        }
        this.waitingTask = this.scheduler.scheduleWithFixedDelay(this.command, this.initialDelay, this.cycleDelay, TimeUnit.MILLISECONDS);
        this.isPaused = false;
    }

    public void suspend() {
        if (this.isPaused) {
            return;
        }
        this.initialDelay = this.waitingTask.getDelay(TimeUnit.MILLISECONDS);
        this.waitingTask.cancel(false);
        this.isPaused = true;
    }
}

