/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.net.Uri;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustTestOptions;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IRunActivityHandler;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.Util;
import java.util.ArrayList;
import java.util.List;

public class AdjustInstance {
    private String pushToken;
    private Boolean startEnabled = null;
    private boolean startOffline = false;
    private IActivityHandler activityHandler;
    private List<IRunActivityHandler> preLaunchActionsArray;
    private String basePath;

    public void onCreate(AdjustConfig adjustConfig) {
        if (adjustConfig == null) {
            AdjustFactory.getLogger().error("AdjustConfig missing", new Object[0]);
            return;
        }
        if (!adjustConfig.isValid()) {
            AdjustFactory.getLogger().error("AdjustConfig not initialized correctly", new Object[0]);
            return;
        }
        if (this.activityHandler != null) {
            AdjustFactory.getLogger().error("Adjust already initialized", new Object[0]);
            return;
        }
        adjustConfig.preLaunchActionsArray = this.preLaunchActionsArray;
        adjustConfig.pushToken = this.pushToken;
        adjustConfig.startEnabled = this.startEnabled;
        adjustConfig.startOffline = this.startOffline;
        adjustConfig.basePath = this.basePath;
        this.activityHandler = AdjustFactory.getActivityHandler(adjustConfig);
        this.setSendingReferrersAsNotSent(adjustConfig.context);
    }

    public void trackEvent(AdjustEvent event) {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.trackEvent(event);
    }

    public void onResume() {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.onResume();
    }

    public void onPause() {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.onPause();
    }

    public void setEnabled(boolean enabled) {
        this.startEnabled = enabled;
        if (this.checkActivityHandler(enabled, "enabled mode", "disabled mode")) {
            this.activityHandler.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        if (!this.checkActivityHandler()) {
            return this.isInstanceEnabled();
        }
        return this.activityHandler.isEnabled();
    }

    public void appWillOpenUrl(Uri url) {
        if (!this.checkActivityHandler()) {
            return;
        }
        long clickTime = System.currentTimeMillis();
        this.activityHandler.readOpenUrl(url, clickTime);
    }

    public void sendReferrer(String rawReferrer, Context context) {
        long clickTime = System.currentTimeMillis();
        if (rawReferrer == null || rawReferrer.length() == 0) {
            return;
        }
        this.saveRawReferrer(rawReferrer, clickTime, context);
        if (this.checkActivityHandler("referrer") && this.activityHandler.isEnabled()) {
            this.activityHandler.sendReftagReferrer();
        }
    }

    public void setOfflineMode(boolean enabled) {
        if (!this.checkActivityHandler(enabled, "offline mode", "online mode")) {
            this.startOffline = enabled;
        } else {
            this.activityHandler.setOfflineMode(enabled);
        }
    }

    public void sendFirstPackages() {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.sendFirstPackages();
    }

    public void addSessionCallbackParameter(final String key, final String value) {
        if (this.checkActivityHandler("adding session callback parameter")) {
            this.activityHandler.addSessionCallbackParameter(key, value);
            return;
        }
        if (this.preLaunchActionsArray == null) {
            this.preLaunchActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.addSessionCallbackParameterI(key, value);
            }
        });
    }

    public void addSessionPartnerParameter(final String key, final String value) {
        if (this.checkActivityHandler("adding session partner parameter")) {
            this.activityHandler.addSessionPartnerParameter(key, value);
            return;
        }
        if (this.preLaunchActionsArray == null) {
            this.preLaunchActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.addSessionPartnerParameterI(key, value);
            }
        });
    }

    public void removeSessionCallbackParameter(final String key) {
        if (this.checkActivityHandler("removing session callback parameter")) {
            this.activityHandler.removeSessionCallbackParameter(key);
            return;
        }
        if (this.preLaunchActionsArray == null) {
            this.preLaunchActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.removeSessionCallbackParameterI(key);
            }
        });
    }

    public void removeSessionPartnerParameter(final String key) {
        if (this.checkActivityHandler("removing session partner parameter")) {
            this.activityHandler.removeSessionPartnerParameter(key);
            return;
        }
        if (this.preLaunchActionsArray == null) {
            this.preLaunchActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.removeSessionPartnerParameterI(key);
            }
        });
    }

    public void resetSessionCallbackParameters() {
        if (this.checkActivityHandler("resetting session callback parameters")) {
            this.activityHandler.resetSessionCallbackParameters();
            return;
        }
        if (this.preLaunchActionsArray == null) {
            this.preLaunchActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.resetSessionCallbackParametersI();
            }
        });
    }

    public void resetSessionPartnerParameters() {
        if (this.checkActivityHandler("resetting session partner parameters")) {
            this.activityHandler.resetSessionPartnerParameters();
            return;
        }
        if (this.preLaunchActionsArray == null) {
            this.preLaunchActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.resetSessionPartnerParametersI();
            }
        });
    }

    public void teardown() {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.teardown();
        this.activityHandler = null;
    }

    public void setPushToken(String token) {
        if (!this.checkActivityHandler("push token")) {
            this.pushToken = token;
        } else {
            this.activityHandler.setPushToken(token, false);
        }
    }

    public void setPushToken(String token, Context context) {
        this.savePushToken(token, context);
        if (this.checkActivityHandler("push token") && this.activityHandler.isEnabled()) {
            this.activityHandler.setPushToken(token, true);
        }
    }

    public String getAdid() {
        if (!this.checkActivityHandler()) {
            return null;
        }
        return this.activityHandler.getAdid();
    }

    public AdjustAttribution getAttribution() {
        if (!this.checkActivityHandler()) {
            return null;
        }
        return this.activityHandler.getAttribution();
    }

    private boolean checkActivityHandler() {
        return this.checkActivityHandler(null);
    }

    private boolean checkActivityHandler(boolean status, String trueMessage, String falseMessage) {
        if (status) {
            return this.checkActivityHandler(trueMessage);
        }
        return this.checkActivityHandler(falseMessage);
    }

    private boolean checkActivityHandler(String savedForLaunchWarningSuffixMessage) {
        if (this.activityHandler == null) {
            if (savedForLaunchWarningSuffixMessage != null) {
                AdjustFactory.getLogger().warn("Adjust not initialized, but %s saved for launch", savedForLaunchWarningSuffixMessage);
            } else {
                AdjustFactory.getLogger().error("Adjust not initialized correctly", new Object[0]);
            }
            return false;
        }
        return true;
    }

    private void saveRawReferrer(final String rawReferrer, final long clickTime, final Context context) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(context);
                sharedPreferencesManager.saveRawReferrer(rawReferrer, clickTime);
            }
        };
        Util.runInBackground(command);
    }

    private void savePushToken(final String pushToken, final Context context) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(context);
                sharedPreferencesManager.savePushToken(pushToken);
            }
        };
        Util.runInBackground(command);
    }

    private void setSendingReferrersAsNotSent(final Context context) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(context);
                sharedPreferencesManager.setSendingReferrersAsNotSent();
            }
        };
        Util.runInBackground(command);
    }

    private boolean isInstanceEnabled() {
        return this.startEnabled == null || this.startEnabled != false;
    }

    public void setTestOptions(AdjustTestOptions testOptions) {
        if (testOptions.basePath != null) {
            this.basePath = testOptions.basePath;
        }
        if (testOptions.baseUrl != null) {
            AdjustFactory.setBaseUrl(testOptions.baseUrl);
        }
        if (testOptions.useTestConnectionOptions != null && testOptions.useTestConnectionOptions.booleanValue()) {
            AdjustFactory.useTestConnectionOptions();
        }
        if (testOptions.timerIntervalInMilliseconds != null) {
            AdjustFactory.setTimerInterval(testOptions.timerIntervalInMilliseconds);
        }
        if (testOptions.timerStartInMilliseconds != null) {
            AdjustFactory.setTimerStart(testOptions.timerIntervalInMilliseconds);
        }
        if (testOptions.sessionIntervalInMilliseconds != null) {
            AdjustFactory.setSessionInterval(testOptions.sessionIntervalInMilliseconds);
        }
        if (testOptions.subsessionIntervalInMilliseconds != null) {
            AdjustFactory.setSubsessionInterval(testOptions.subsessionIntervalInMilliseconds);
        }
        if (testOptions.tryInstallReferrer != null) {
            AdjustFactory.setTryInstallReferrer(testOptions.tryInstallReferrer);
        }
    }
}

