/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.content.res.Configuration;
import android.telephony.TelephonyManager;
import com.adjust.sdk.Constants;
import com.adjust.sdk.plugin.Plugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Reflection {
    public static Object getVMRuntimeObject() {
        try {
            return Reflection.invokeStaticMethod("dalvik.system.VMRuntime", "getRuntime", null, new Object[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getVmInstructionSet() {
        try {
            Object VMRuntimeObject = Reflection.getVMRuntimeObject();
            String vmInstructionSet = (String)Reflection.invokeInstanceMethod(VMRuntimeObject, "vmInstructionSet", null, new Object[0]);
            return vmInstructionSet;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getPlayAdId(Context context) {
        try {
            Object AdvertisingInfoObject = Reflection.getAdvertisingInfoObject(context);
            String playAdid = (String)Reflection.invokeInstanceMethod(AdvertisingInfoObject, "getId", null, new Object[0]);
            return playAdid;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Boolean isPlayTrackingEnabled(Context context) {
        try {
            Object AdvertisingInfoObject = Reflection.getAdvertisingInfoObject(context);
            Boolean isLimitedTrackingEnabled = (Boolean)Reflection.invokeInstanceMethod(AdvertisingInfoObject, "isLimitAdTrackingEnabled", null, new Object[0]);
            Boolean isPlayTrackingEnabled = isLimitedTrackingEnabled == null ? null : Boolean.valueOf(isLimitedTrackingEnabled == false);
            return isPlayTrackingEnabled;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getMacAddress(Context context) {
        try {
            String macSha1 = (String)Reflection.invokeStaticMethod("com.adjust.sdk.plugin.MacAddressUtil", "getMacAddress", new Class[]{Context.class}, context);
            return macSha1;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getAndroidId(Context context) {
        try {
            String androidId = (String)Reflection.invokeStaticMethod("com.adjust.sdk.plugin.AndroidIdUtil", "getAndroidId", new Class[]{Context.class}, context);
            return androidId;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getImei(TelephonyManager telephonyManager) {
        try {
            return (String)Reflection.invokeInstanceMethod(telephonyManager, "getImei", null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getImei(TelephonyManager telephonyManager, int index) {
        try {
            return (String)Reflection.invokeInstanceMethod(telephonyManager, "getImei", new Class[]{Integer.TYPE}, index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMeid(TelephonyManager telephonyManager) {
        try {
            return (String)Reflection.invokeInstanceMethod(telephonyManager, "getMeid", null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMeid(TelephonyManager telephonyManager, int index) {
        try {
            return (String)Reflection.invokeInstanceMethod(telephonyManager, "getMeid", new Class[]{Integer.TYPE}, index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTelephonyId(TelephonyManager telephonyManager) {
        try {
            return (String)Reflection.invokeInstanceMethod(telephonyManager, "getDeviceId", null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTelephonyId(TelephonyManager telephonyManager, int index) {
        try {
            return (String)Reflection.invokeInstanceMethod(telephonyManager, "getDeviceId", new Class[]{Integer.TYPE}, index);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getAdvertisingInfoObject(Context context) throws Exception {
        return Reflection.invokeStaticMethod("com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo", new Class[]{Context.class}, context);
    }

    public static String[] getSupportedAbis() {
        String[] supportedAbis = null;
        try {
            supportedAbis = (String[])Reflection.readField("android.os.Build", "SUPPORTED_ABIS");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return supportedAbis;
    }

    public static String getCpuAbi() {
        String cpuAbi = null;
        try {
            cpuAbi = (String)Reflection.readField("android.os.Build", "CPU_ABI");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return cpuAbi;
    }

    public static Locale getLocaleFromLocaleList(Configuration configuration) {
        Locale locale = null;
        try {
            Object localesList = Reflection.invokeInstanceMethod(configuration, "getLocales", null, new Object[0]);
            if (localesList == null) {
                return null;
            }
            locale = (Locale)Reflection.invokeInstanceMethod(localesList, "get", new Class[]{Integer.TYPE}, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return locale;
    }

    public static Locale getLocaleFromField(Configuration configuration) {
        Locale locale = null;
        try {
            locale = (Locale)Reflection.readField("android.content.res.Configuration", "locale", configuration);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return locale;
    }

    public static Class forName(String className) {
        try {
            Class<?> classObject = Class.forName(className);
            return classObject;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Object createDefaultInstance(String className) {
        Class classObject = Reflection.forName(className);
        Object instance = Reflection.createDefaultInstance(classObject);
        return instance;
    }

    public static Object createDefaultInstance(Class classObject) {
        try {
            Object instance = classObject.newInstance();
            return instance;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Object createInstance(String className, Class[] cArgs, Object ... args) {
        try {
            Class<?> classObject = Class.forName(className);
            Constructor<?> constructor = classObject.getConstructor(cArgs);
            Object instance = constructor.newInstance(args);
            return instance;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Object invokeStaticMethod(String className, String methodName, Class[] cArgs, Object ... args) throws Exception {
        Class<?> classObject = Class.forName(className);
        return Reflection.invokeMethod(classObject, methodName, null, cArgs, args);
    }

    public static Object invokeInstanceMethod(Object instance, String methodName, Class[] cArgs, Object ... args) throws Exception {
        Class<?> classObject = instance.getClass();
        return Reflection.invokeMethod(classObject, methodName, instance, cArgs, args);
    }

    public static Object invokeMethod(Class classObject, String methodName, Object instance, Class[] cArgs, Object ... args) throws Exception {
        Method methodObject = classObject.getMethod(methodName, cArgs);
        if (methodObject == null) {
            return null;
        }
        Object resultObject = methodObject.invoke(instance, args);
        return resultObject;
    }

    public static Object readField(String className, String fieldName) throws Exception {
        return Reflection.readField(className, fieldName, null);
    }

    public static Object readField(String className, String fieldName, Object instance) throws Exception {
        Class classObject = Reflection.forName(className);
        if (classObject == null) {
            return null;
        }
        Field fieldObject = classObject.getField(fieldName);
        if (fieldObject == null) {
            return null;
        }
        return fieldObject.get(instance);
    }

    public static Map<String, String> getPluginKeys(Context context) {
        HashMap<String, String> pluginKeys = new HashMap<String, String>();
        for (Plugin plugin : Reflection.getPlugins()) {
            Map.Entry<String, String> pluginEntry = plugin.getParameter(context);
            if (pluginEntry == null) continue;
            pluginKeys.put(pluginEntry.getKey(), pluginEntry.getValue());
        }
        if (pluginKeys.size() == 0) {
            return null;
        }
        return pluginKeys;
    }

    private static List<Plugin> getPlugins() {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(Constants.PLUGINS.size());
        for (String pluginName : Constants.PLUGINS) {
            Object pluginObject = Reflection.createDefaultInstance(pluginName);
            if (pluginObject == null || !(pluginObject instanceof Plugin)) continue;
            plugins.add((Plugin)pluginObject);
        }
        return plugins;
    }
}

