/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.CustomScheduledExecutor;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.TimerOnce;
import com.adjust.sdk.Util;
import com.adjust.sdk.UtilNetworking;
import java.lang.ref.WeakReference;
import org.json.JSONObject;

public class AttributionHandler
implements IAttributionHandler {
    private CustomScheduledExecutor scheduledExecutor = new CustomScheduledExecutor("AttributionHandler", false);
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private ILogger logger = AdjustFactory.getLogger();
    private ActivityPackage attributionPackage;
    private TimerOnce timer = new TimerOnce(new Runnable(){

        @Override
        public void run() {
            AttributionHandler.this.sendAttributionRequest();
        }
    }, "Attribution timer");
    private static final String ATTRIBUTION_TIMER_NAME = "Attribution timer";
    private boolean paused;

    @Override
    public void teardown() {
        this.logger.verbose("AttributionHandler teardown", new Object[0]);
        if (this.timer != null) {
            this.timer.teardown();
        }
        if (this.scheduledExecutor != null) {
            try {
                this.scheduledExecutor.shutdownNow();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.activityHandlerWeakRef != null) {
            this.activityHandlerWeakRef.clear();
        }
        this.scheduledExecutor = null;
        this.activityHandlerWeakRef = null;
        this.logger = null;
        this.attributionPackage = null;
        this.timer = null;
    }

    public AttributionHandler(IActivityHandler activityHandler, ActivityPackage attributionPackage, boolean startsSending) {
        this.init(activityHandler, attributionPackage, startsSending);
    }

    @Override
    public void init(IActivityHandler activityHandler, ActivityPackage attributionPackage, boolean startsSending) {
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
        this.attributionPackage = attributionPackage;
        this.paused = !startsSending;
    }

    @Override
    public void getAttribution() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.getAttributionI(0L);
            }
        });
    }

    @Override
    public void checkSessionResponse(final SessionResponseData sessionResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkSessionResponseI(activityHandler, sessionResponseData);
            }
        });
    }

    public void checkAttributionResponse(final AttributionResponseData attributionResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkAttributionResponseI(activityHandler, attributionResponseData);
            }
        });
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    public void sendAttributionRequest() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.sendAttributionRequestI();
            }
        });
    }

    private void getAttributionI(long delayInMilliseconds) {
        if (this.timer.getFireIn() > delayInMilliseconds) {
            return;
        }
        if (delayInMilliseconds != 0L) {
            double waitTimeSeconds = (double)delayInMilliseconds / 1000.0;
            String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
            this.logger.debug("Waiting to query attribution in %s seconds", secondsString);
        }
        this.timer.startIn(delayInMilliseconds);
    }

    private void checkAttributionI(IActivityHandler activityHandler, ResponseData responseData) {
        if (responseData.jsonResponse == null) {
            return;
        }
        long timerMilliseconds = responseData.jsonResponse.optLong("ask_in", -1L);
        if (timerMilliseconds >= 0L) {
            activityHandler.setAskingAttribution(true);
            this.getAttributionI(timerMilliseconds);
            return;
        }
        activityHandler.setAskingAttribution(false);
        JSONObject attributionJson = responseData.jsonResponse.optJSONObject("attribution");
        responseData.attribution = AdjustAttribution.fromJson(attributionJson, responseData.adid);
    }

    private void checkSessionResponseI(IActivityHandler activityHandler, SessionResponseData sessionResponseData) {
        this.checkAttributionI(activityHandler, sessionResponseData);
        activityHandler.launchSessionResponseTasks(sessionResponseData);
    }

    private void checkAttributionResponseI(IActivityHandler activityHandler, AttributionResponseData attributionResponseData) {
        this.checkAttributionI(activityHandler, attributionResponseData);
        this.checkDeeplinkI(attributionResponseData);
        activityHandler.launchAttributionResponseTasks(attributionResponseData);
    }

    private void checkDeeplinkI(AttributionResponseData attributionResponseData) {
        if (attributionResponseData.jsonResponse == null) {
            return;
        }
        JSONObject attributionJson = attributionResponseData.jsonResponse.optJSONObject("attribution");
        if (attributionJson == null) {
            return;
        }
        String deeplinkString = attributionJson.optString("deeplink", null);
        if (deeplinkString == null) {
            return;
        }
        attributionResponseData.deeplink = Uri.parse((String)deeplinkString);
    }

    private void sendAttributionRequestI() {
        if (this.paused) {
            this.logger.debug("Attribution handler is paused", new Object[0]);
            return;
        }
        this.logger.verbose("%s", this.attributionPackage.getExtendedString());
        try {
            ResponseData responseData = UtilNetworking.createGETHttpsURLConnection(this.attributionPackage);
            if (!(responseData instanceof AttributionResponseData)) {
                return;
            }
            this.checkAttributionResponse((AttributionResponseData)responseData);
        }
        catch (Exception e) {
            this.logger.error("Failed to get attribution (%s)", e.getMessage());
            return;
        }
    }
}

