/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IRunActivityHandler;
import java.util.ArrayList;
import java.util.List;

public class AdjustInstance {
    private String referrer;
    private long referrerClickTime;
    private ActivityHandler activityHandler;
    private List<IRunActivityHandler> sessionParametersActionsArray;
    private String pushToken;

    private static ILogger getLogger() {
        return AdjustFactory.getLogger();
    }

    public void onCreate(AdjustConfig adjustConfig) {
        if (this.activityHandler != null) {
            AdjustInstance.getLogger().error("Adjust already initialized", new Object[0]);
            return;
        }
        adjustConfig.referrer = this.referrer;
        adjustConfig.referrerClickTime = this.referrerClickTime;
        adjustConfig.sessionParametersActionsArray = this.sessionParametersActionsArray;
        adjustConfig.pushToken = this.pushToken;
        this.activityHandler = ActivityHandler.getInstance(adjustConfig);
    }

    public void trackEvent(AdjustEvent event) {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.trackEvent(event);
    }

    public void onResume() {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.onResume();
    }

    public void onPause() {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.onPause();
    }

    public void setEnabled(boolean enabled) {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.setEnabled(enabled);
    }

    public boolean isEnabled() {
        if (!this.checkActivityHandler()) {
            return false;
        }
        return this.activityHandler.isEnabled();
    }

    public void appWillOpenUrl(Uri url) {
        if (!this.checkActivityHandler()) {
            return;
        }
        long clickTime = System.currentTimeMillis();
        this.activityHandler.readOpenUrl(url, clickTime);
    }

    public void sendReferrer(String referrer) {
        long clickTime = System.currentTimeMillis();
        if (this.activityHandler == null) {
            this.referrer = referrer;
            this.referrerClickTime = clickTime;
        } else {
            this.activityHandler.sendReferrer(referrer, clickTime);
        }
    }

    public void setOfflineMode(boolean enabled) {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.setOfflineMode(enabled);
    }

    public void sendFirstPackages() {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.sendFirstPackages();
    }

    public void addSessionCallbackParameter(final String key, final String value) {
        if (this.activityHandler != null) {
            this.activityHandler.addSessionCallbackParameter(key, value);
            return;
        }
        if (this.sessionParametersActionsArray == null) {
            this.sessionParametersActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.sessionParametersActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.addSessionCallbackParameterI(key, value);
            }
        });
    }

    public void addSessionPartnerParameter(final String key, final String value) {
        if (this.activityHandler != null) {
            this.activityHandler.addSessionPartnerParameter(key, value);
            return;
        }
        if (this.sessionParametersActionsArray == null) {
            this.sessionParametersActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.sessionParametersActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.addSessionPartnerParameterI(key, value);
            }
        });
    }

    public void removeSessionCallbackParameter(final String key) {
        if (this.activityHandler != null) {
            this.activityHandler.removeSessionCallbackParameter(key);
            return;
        }
        if (this.sessionParametersActionsArray == null) {
            this.sessionParametersActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.sessionParametersActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.removeSessionCallbackParameterI(key);
            }
        });
    }

    public void removeSessionPartnerParameter(final String key) {
        if (this.activityHandler != null) {
            this.activityHandler.removeSessionPartnerParameter(key);
            return;
        }
        if (this.sessionParametersActionsArray == null) {
            this.sessionParametersActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.sessionParametersActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.removeSessionPartnerParameterI(key);
            }
        });
    }

    public void resetSessionCallbackParameters() {
        if (this.activityHandler != null) {
            this.activityHandler.resetSessionCallbackParameters();
            return;
        }
        if (this.sessionParametersActionsArray == null) {
            this.sessionParametersActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.sessionParametersActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.resetSessionCallbackParametersI();
            }
        });
    }

    public void resetSessionPartnerParameters() {
        if (this.activityHandler != null) {
            this.activityHandler.resetSessionPartnerParameters();
            return;
        }
        if (this.sessionParametersActionsArray == null) {
            this.sessionParametersActionsArray = new ArrayList<IRunActivityHandler>();
        }
        this.sessionParametersActionsArray.add(new IRunActivityHandler(){

            @Override
            public void run(ActivityHandler activityHandler) {
                activityHandler.resetSessionPartnerParametersI();
            }
        });
    }

    public void teardown(boolean deleteState) {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.teardown(deleteState);
        this.activityHandler = null;
    }

    public void setPushToken(String token) {
        this.pushToken = token;
        if (this.activityHandler != null) {
            this.activityHandler.setPushToken(token);
            return;
        }
    }

    public String getAdid() {
        if (!this.checkActivityHandler()) {
            return null;
        }
        return this.activityHandler.getAdid();
    }

    public AdjustAttribution getAttribution() {
        if (!this.checkActivityHandler()) {
            return null;
        }
        return this.activityHandler.getAttribution();
    }

    private boolean checkActivityHandler() {
        if (this.activityHandler == null) {
            AdjustInstance.getLogger().error("Adjust not initialized correctly", new Object[0]);
            return false;
        }
        return true;
    }
}

