/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.CustomScheduledExecutor;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.SocketTimeoutException;
import javax.net.ssl.HttpsURLConnection;

public class RequestHandler
implements IRequestHandler {
    private CustomScheduledExecutor scheduledExecutor;
    private WeakReference<IPackageHandler> packageHandlerWeakRef;
    private ILogger logger = AdjustFactory.getLogger();

    public RequestHandler(IPackageHandler packageHandler) {
        this.scheduledExecutor = new CustomScheduledExecutor("RequestHandler", false);
        this.init(packageHandler);
    }

    @Override
    public void init(IPackageHandler packageHandler) {
        this.packageHandlerWeakRef = new WeakReference<IPackageHandler>(packageHandler);
    }

    @Override
    public void sendPackage(final ActivityPackage activityPackage, final int queueSize) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                RequestHandler.this.sendI(activityPackage, queueSize);
            }
        });
    }

    @Override
    public void teardown() {
        this.logger.verbose("RequestHandler teardown", new Object[0]);
        if (this.scheduledExecutor != null) {
            try {
                this.scheduledExecutor.shutdownNow();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.packageHandlerWeakRef != null) {
            this.packageHandlerWeakRef.clear();
        }
        this.scheduledExecutor = null;
        this.packageHandlerWeakRef = null;
        this.logger = null;
    }

    private void sendI(ActivityPackage activityPackage, int queueSize) {
        String targetURL = "https://app.adjust.com" + activityPackage.getPath();
        try {
            HttpsURLConnection connection = Util.createPOSTHttpsURLConnection(targetURL, activityPackage.getClientSdk(), activityPackage.getParameters(), queueSize);
            ResponseData responseData = Util.readHttpResponse(connection, activityPackage);
            IPackageHandler packageHandler = (IPackageHandler)this.packageHandlerWeakRef.get();
            if (packageHandler == null) {
                return;
            }
            if (responseData.jsonResponse == null) {
                packageHandler.closeFirstPackage(responseData, activityPackage);
                return;
            }
            packageHandler.sendNextPackage(responseData);
        }
        catch (UnsupportedEncodingException e) {
            this.sendNextPackageI(activityPackage, "Failed to encode parameters", e);
        }
        catch (SocketTimeoutException e) {
            this.closePackageI(activityPackage, "Request timed out", e);
        }
        catch (IOException e) {
            this.closePackageI(activityPackage, "Request failed", e);
        }
        catch (Throwable e) {
            this.sendNextPackageI(activityPackage, "Runtime exception", e);
        }
    }

    private void closePackageI(ActivityPackage activityPackage, String message, Throwable throwable) {
        String packageMessage = activityPackage.getFailureMessage();
        String reasonString = Util.getReasonString(message, throwable);
        String finalMessage = String.format("%s. (%s) Will retry later", packageMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        responseData.message = finalMessage;
        IPackageHandler packageHandler = (IPackageHandler)this.packageHandlerWeakRef.get();
        if (packageHandler == null) {
            return;
        }
        packageHandler.closeFirstPackage(responseData, activityPackage);
    }

    private void sendNextPackageI(ActivityPackage activityPackage, String message, Throwable throwable) {
        String failureMessage = activityPackage.getFailureMessage();
        String reasonString = Util.getReasonString(message, throwable);
        String finalMessage = String.format("%s. (%s)", failureMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        responseData.message = finalMessage;
        IPackageHandler packageHandler = (IPackageHandler)this.packageHandlerWeakRef.get();
        if (packageHandler == null) {
            return;
        }
        packageHandler.sendNextPackage(responseData);
    }
}

