/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.CustomScheduledExecutor;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.lang.ref.WeakReference;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TimerCycle {
    private WeakReference<CustomScheduledExecutor> scheduledExecutorWeakRef;
    private ScheduledFuture waitingTask;
    private String name;
    private Runnable command;
    private long initialDelay;
    private long cycleDelay;
    private boolean isPaused;
    private ILogger logger;

    public TimerCycle(CustomScheduledExecutor scheduler, Runnable command, long initialDelay, long cycleDelay, String name) {
        this.scheduledExecutorWeakRef = new WeakReference<CustomScheduledExecutor>(scheduler);
        this.name = name;
        this.command = command;
        this.initialDelay = initialDelay;
        this.cycleDelay = cycleDelay;
        this.isPaused = true;
        this.logger = AdjustFactory.getLogger();
        String cycleDelaySecondsString = Util.SecondsDisplayFormat.format((double)cycleDelay / 1000.0);
        String initialDelaySecondsString = Util.SecondsDisplayFormat.format((double)initialDelay / 1000.0);
        this.logger.verbose("%s configured to fire after %s seconds of starting and cycles every %s seconds", name, initialDelaySecondsString, cycleDelaySecondsString);
    }

    public void start() {
        if (!this.isPaused) {
            this.logger.verbose("%s is already started", this.name);
            return;
        }
        CustomScheduledExecutor scheduledExecutor = (CustomScheduledExecutor)this.scheduledExecutorWeakRef.get();
        if (scheduledExecutor == null) {
            return;
        }
        this.logger.verbose("%s starting", this.name);
        this.waitingTask = scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TimerCycle.this.logger.verbose("%s fired", TimerCycle.this.name);
                TimerCycle.this.command.run();
            }
        }, this.initialDelay, this.cycleDelay, TimeUnit.MILLISECONDS);
        this.isPaused = false;
    }

    public void suspend() {
        if (this.isPaused) {
            this.logger.verbose("%s is already suspended", this.name);
            return;
        }
        this.initialDelay = this.waitingTask.getDelay(TimeUnit.MILLISECONDS);
        this.waitingTask.cancel(false);
        String initialDelaySeconds = Util.SecondsDisplayFormat.format((double)this.initialDelay / 1000.0);
        this.logger.verbose("%s suspended with %s seconds left", this.name, initialDelaySeconds);
        this.isPaused = true;
    }

    private void cancel(boolean mayInterruptIfRunning) {
        if (this.waitingTask != null) {
            this.waitingTask.cancel(mayInterruptIfRunning);
        }
        this.waitingTask = null;
    }

    public void teardown() {
        this.cancel(true);
        if (this.scheduledExecutorWeakRef != null) {
            this.scheduledExecutorWeakRef.clear();
        }
        this.scheduledExecutorWeakRef = null;
    }
}

