/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.text.TextUtils;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

class PackageBuilder {
    private AdjustConfig adjustConfig;
    private DeviceInfo deviceInfo;
    private ActivityState activityState;
    private long createdAt;
    Map<String, String> extraParameters;
    AdjustAttribution attribution;
    String reftag;
    private static ILogger logger = AdjustFactory.getLogger();

    public PackageBuilder(AdjustConfig adjustConfig, DeviceInfo deviceInfo, ActivityState activityState, long createdAt) {
        this.adjustConfig = adjustConfig;
        this.deviceInfo = deviceInfo;
        this.activityState = activityState == null ? null : activityState.shallowCopy();
        this.createdAt = createdAt;
    }

    public ActivityPackage buildSessionPackage() {
        Map<String, String> parameters = this.getDefaultParameters();
        this.addDuration(parameters, "last_interval", this.activityState.lastInterval);
        this.addString(parameters, "default_tracker", this.adjustConfig.defaultTracker);
        ActivityPackage sessionPackage = this.getDefaultActivityPackage(ActivityKind.SESSION);
        sessionPackage.setPath("/session");
        sessionPackage.setSuffix("");
        sessionPackage.setParameters(parameters);
        return sessionPackage;
    }

    public ActivityPackage buildEventPackage(AdjustEvent event) {
        Map<String, String> parameters = this.getDefaultParameters();
        this.addInt(parameters, "event_count", this.activityState.eventCount);
        this.addString(parameters, "event_token", event.eventToken);
        this.addDouble(parameters, "revenue", event.revenue);
        this.addString(parameters, "currency", event.currency);
        this.addMapJson(parameters, "callback_params", event.callbackParameters);
        this.addMapJson(parameters, "partner_params", event.partnerParameters);
        ActivityPackage eventPackage = this.getDefaultActivityPackage(ActivityKind.EVENT);
        eventPackage.setPath("/event");
        eventPackage.setSuffix(this.getEventSuffix(event));
        eventPackage.setParameters(parameters);
        return eventPackage;
    }

    public ActivityPackage buildClickPackage(String source, long clickTime) {
        Map<String, String> parameters = this.getIdsParameters();
        this.addString(parameters, "source", source);
        this.addDate(parameters, "click_time", clickTime);
        this.addString(parameters, "reftag", this.reftag);
        this.addMapJson(parameters, "params", this.extraParameters);
        this.injectAttribution(parameters);
        ActivityPackage clickPackage = this.getDefaultActivityPackage(ActivityKind.CLICK);
        clickPackage.setPath("/sdk_click");
        clickPackage.setSuffix("");
        clickPackage.setParameters(parameters);
        return clickPackage;
    }

    public ActivityPackage buildAttributionPackage() {
        Map<String, String> parameters = this.getIdsParameters();
        ActivityPackage attributionPackage = this.getDefaultActivityPackage(ActivityKind.ATTRIBUTION);
        attributionPackage.setPath("attribution");
        attributionPackage.setSuffix("");
        attributionPackage.setParameters(parameters);
        return attributionPackage;
    }

    private ActivityPackage getDefaultActivityPackage(ActivityKind activityKind) {
        ActivityPackage activityPackage = new ActivityPackage(activityKind);
        activityPackage.setClientSdk(this.deviceInfo.clientSdk);
        return activityPackage;
    }

    private Map<String, String> getDefaultParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.injectDeviceInfo(parameters);
        this.injectConfig(parameters);
        this.injectActivityState(parameters);
        this.injectCreatedAt(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getIdsParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.injectDeviceInfoIds(parameters);
        this.injectConfig(parameters);
        this.injectCreatedAt(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private void injectDeviceInfo(Map<String, String> parameters) {
        this.injectDeviceInfoIds(parameters);
        this.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        this.addString(parameters, "package_name", this.deviceInfo.packageName);
        this.addString(parameters, "app_version", this.deviceInfo.appVersion);
        this.addString(parameters, "device_type", this.deviceInfo.deviceType);
        this.addString(parameters, "device_name", this.deviceInfo.deviceName);
        this.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        this.addString(parameters, "os_name", this.deviceInfo.osName);
        this.addString(parameters, "os_version", this.deviceInfo.osVersion);
        this.addString(parameters, "language", this.deviceInfo.language);
        this.addString(parameters, "country", this.deviceInfo.country);
        this.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        this.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        this.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        this.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        this.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        this.fillPluginKeys(parameters);
    }

    private void injectDeviceInfoIds(Map<String, String> parameters) {
        this.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        this.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
        this.addString(parameters, "android_id", this.deviceInfo.androidId);
    }

    private void injectConfig(Map<String, String> parameters) {
        this.addString(parameters, "app_token", this.adjustConfig.appToken);
        this.addString(parameters, "environment", this.adjustConfig.environment);
        this.addBoolean(parameters, "device_known", this.adjustConfig.knownDevice);
        this.addBoolean(parameters, "needs_attribution_data", this.adjustConfig.hasListener());
        String playAdId = Util.getPlayAdId(this.adjustConfig.context);
        this.addString(parameters, "gps_adid", playAdId);
        Boolean isTrackingEnabled = Util.isPlayTrackingEnabled(this.adjustConfig.context);
        this.addBoolean(parameters, "tracking_enabled", isTrackingEnabled);
    }

    private void injectActivityState(Map<String, String> parameters) {
        this.addString(parameters, "android_uuid", this.activityState.uuid);
        this.addInt(parameters, "session_count", this.activityState.sessionCount);
        this.addInt(parameters, "subsession_count", this.activityState.subsessionCount);
        this.addDuration(parameters, "session_length", this.activityState.sessionLength);
        this.addDuration(parameters, "time_spent", this.activityState.timeSpent);
    }

    private void injectCreatedAt(Map<String, String> parameters) {
        this.addDate(parameters, "created_at", this.createdAt);
    }

    private void injectAttribution(Map<String, String> parameters) {
        if (this.attribution == null) {
            return;
        }
        this.addString(parameters, "tracker", this.attribution.trackerName);
        this.addString(parameters, "campaign", this.attribution.campaign);
        this.addString(parameters, "adgroup", this.attribution.adgroup);
        this.addString(parameters, "creative", this.attribution.creative);
    }

    private void checkDeviceIds(Map<String, String> parameters) {
        if (!(parameters.containsKey("mac_sha1") || parameters.containsKey("mac_md5") || parameters.containsKey("android_id") || parameters.containsKey("gps_adid"))) {
            logger.error("Missing device id's. Please check if Proguard is correctly set with Adjust SDK", new Object[0]);
        }
    }

    private void fillPluginKeys(Map<String, String> parameters) {
        if (this.deviceInfo.pluginKeys == null) {
            return;
        }
        for (Map.Entry<String, String> entry : this.deviceInfo.pluginKeys.entrySet()) {
            this.addString(parameters, entry.getKey(), entry.getValue());
        }
    }

    private String getEventSuffix(AdjustEvent event) {
        if (event.revenue == null) {
            return String.format(Locale.US, "'%s'", event.eventToken);
        }
        return String.format(Locale.US, "(%.5f %s, '%s')", event.revenue, event.currency, event.eventToken);
    }

    private void addString(Map<String, String> parameters, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        parameters.put(key, value);
    }

    private void addInt(Map<String, String> parameters, String key, long value) {
        if (value < 0L) {
            return;
        }
        String valueString = Long.toString(value);
        this.addString(parameters, key, valueString);
    }

    private void addDate(Map<String, String> parameters, String key, long value) {
        if (value < 0L) {
            return;
        }
        String dateString = Util.dateFormat(value);
        this.addString(parameters, key, dateString);
    }

    private void addDuration(Map<String, String> parameters, String key, long durationInMilliSeconds) {
        if (durationInMilliSeconds < 0L) {
            return;
        }
        long durationInSeconds = (durationInMilliSeconds + 500L) / 1000L;
        this.addInt(parameters, key, durationInSeconds);
    }

    private void addMapJson(Map<String, String> parameters, String key, Map<String, String> map) {
        if (map == null) {
            return;
        }
        if (map.size() == 0) {
            return;
        }
        JSONObject jsonObject = new JSONObject(map);
        String jsonString = jsonObject.toString();
        this.addString(parameters, key, jsonString);
    }

    private void addBoolean(Map<String, String> parameters, String key, Boolean value) {
        if (value == null) {
            return;
        }
        int intValue = value != false ? 1 : 0;
        this.addInt(parameters, key, intValue);
    }

    private void addDouble(Map<String, String> parameters, String key, Double value) {
        if (value == null) {
            return;
        }
        String doubleString = String.format(Locale.US, "%.5f", value);
        this.addString(parameters, key, doubleString);
    }
}

