/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import java.util.HashMap;
import java.util.Map;

public class AdjustEvent {
    String eventToken;
    Double revenue;
    String currency;
    Map<String, String> callbackParameters;
    Map<String, String> partnerParameters;
    private static ILogger logger = AdjustFactory.getLogger();

    public AdjustEvent(String eventToken) {
        if (!AdjustEvent.checkEventToken(eventToken, logger)) {
            return;
        }
        this.eventToken = eventToken;
    }

    public void setRevenue(double revenue, String currency) {
        if (!this.checkRevenue(revenue, currency)) {
            return;
        }
        this.revenue = revenue;
        this.currency = currency;
    }

    public void addCallbackParameter(String key, String value) {
        String previousValue;
        if (!this.isValidParameter(key, "key", "Callback")) {
            return;
        }
        if (!this.isValidParameter(value, "value", "Callback")) {
            return;
        }
        if (this.callbackParameters == null) {
            this.callbackParameters = new HashMap<String, String>();
        }
        if ((previousValue = this.callbackParameters.put(key, value)) != null) {
            logger.warn("key %s was overwritten", key);
        }
    }

    public void addPartnerParameter(String key, String value) {
        String previousValue;
        if (!this.isValidParameter(key, "key", "Partner")) {
            return;
        }
        if (!this.isValidParameter(value, "value", "Partner")) {
            return;
        }
        if (this.partnerParameters == null) {
            this.partnerParameters = new HashMap<String, String>();
        }
        if ((previousValue = this.partnerParameters.put(key, value)) != null) {
            logger.warn("key %s was overwritten", key);
        }
    }

    public boolean isValid() {
        return this.eventToken != null;
    }

    private static boolean checkEventToken(String eventToken, ILogger logger) {
        if (eventToken == null) {
            logger.error("Missing Event Token", new Object[0]);
            return false;
        }
        if (eventToken.length() != 6) {
            logger.error("Malformed Event Token '%s'", eventToken);
            return false;
        }
        return true;
    }

    private boolean checkRevenue(Double revenue, String currency) {
        if (revenue != null) {
            if (revenue < 0.0) {
                logger.error("Invalid amount %.4f", revenue);
                return false;
            }
            if (currency == null) {
                logger.error("Currency must be set with revenue", new Object[0]);
                return false;
            }
            if (currency.equals("")) {
                logger.error("Currency is empty", new Object[0]);
                return false;
            }
        } else if (currency != null) {
            logger.error("Revenue must be set with currency", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean isValidParameter(String attribute, String attributeType, String parameterName) {
        if (attribute == null) {
            logger.error("%s parameter %s is missing", parameterName, attributeType);
            return false;
        }
        if (attribute.equals("")) {
            logger.error("%s parameter %s is empty", parameterName, attributeType);
            return false;
        }
        return true;
    }
}

