/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.adjust.sdk.Reflection;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class Util {
    private static SimpleDateFormat dateFormat;
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'Z";

    protected static String getUserAgent(Context context) {
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Configuration configuration = resources.getConfiguration();
        Locale locale = configuration.locale;
        int screenLayout = configuration.screenLayout;
        Object[] parts = new String[]{Util.getPackageName(context), Util.getAppVersion(context), Util.getDeviceType(screenLayout), Util.getDeviceName(), Util.getOsName(), Util.getOsVersion(), Util.getLanguage(locale), Util.getCountry(locale), Util.getScreenSize(screenLayout), Util.getScreenFormat(screenLayout), Util.getScreenDensity(displayMetrics), Util.getDisplayWidth(displayMetrics), Util.getDisplayHeight(displayMetrics)};
        return TextUtils.join((CharSequence)" ", (Object[])parts);
    }

    private static String getPackageName(Context context) {
        String packageName = context.getPackageName();
        return Util.sanitizeString(packageName);
    }

    private static String getAppVersion(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            String name = context.getPackageName();
            PackageInfo info = packageManager.getPackageInfo(name, 0);
            String versionName = info.versionName;
            return Util.sanitizeString(versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            return "unknown";
        }
    }

    private static String getDeviceType(int screenLayout) {
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: 
            case 2: {
                return "phone";
            }
            case 3: 
            case 4: {
                return "tablet";
            }
        }
        return "unknown";
    }

    private static String getDeviceName() {
        String deviceName = Build.MODEL;
        return Util.sanitizeString(deviceName);
    }

    private static String getOsName() {
        return "android";
    }

    private static String getOsVersion() {
        String osVersion = "" + Build.VERSION.SDK_INT;
        return Util.sanitizeString(osVersion);
    }

    private static String getLanguage(Locale locale) {
        String language = locale.getLanguage();
        return Util.sanitizeStringShort(language);
    }

    private static String getCountry(Locale locale) {
        String country = locale.getCountry();
        return Util.sanitizeStringShort(country);
    }

    private static String getScreenSize(int screenLayout) {
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: {
                return "small";
            }
            case 2: {
                return "normal";
            }
            case 3: {
                return "large";
            }
            case 4: {
                return "xlarge";
            }
        }
        return "unknown";
    }

    private static String getScreenFormat(int screenLayout) {
        int screenFormat = screenLayout & 0x30;
        switch (screenFormat) {
            case 32: {
                return "long";
            }
            case 16: {
                return "normal";
            }
        }
        return "unknown";
    }

    private static String getScreenDensity(DisplayMetrics displayMetrics) {
        int density = displayMetrics.densityDpi;
        int low = 140;
        int high = 200;
        if (0 == density) {
            return "unknown";
        }
        if (density < 140) {
            return "low";
        }
        if (density > 200) {
            return "high";
        }
        return "medium";
    }

    private static String getDisplayWidth(DisplayMetrics displayMetrics) {
        String displayWidth = String.valueOf(displayMetrics.widthPixels);
        return Util.sanitizeString(displayWidth);
    }

    private static String getDisplayHeight(DisplayMetrics displayMetrics) {
        String displayHeight = String.valueOf(displayMetrics.heightPixels);
        return Util.sanitizeString(displayHeight);
    }

    protected static String createUuid() {
        return UUID.randomUUID().toString();
    }

    private static String sanitizeString(String string) {
        return Util.sanitizeString(string, "unknown");
    }

    private static String sanitizeStringShort(String string) {
        return Util.sanitizeString(string, "zz");
    }

    private static String sanitizeString(String string, String defaultString) {
        String result = string;
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = defaultString;
        }
        if (TextUtils.isEmpty((CharSequence)(result = result.replaceAll("\\s", "")))) {
            result = defaultString;
        }
        return result;
    }

    protected static String getAttributionId(Context context) {
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
            String columnName = "aid";
            String[] projection = new String[]{"aid"};
            Cursor cursor = contentResolver.query(uri, projection, null, null, null);
            if (null == cursor) {
                return null;
            }
            if (!cursor.moveToFirst()) {
                cursor.close();
                return null;
            }
            String attributionId = cursor.getString(cursor.getColumnIndex("aid"));
            cursor.close();
            return attributionId;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String quote(String string) {
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        return String.format("'%s'", string);
    }

    public static String dateFormat(long date) {
        if (null == dateFormat) {
            dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        }
        return dateFormat.format(date);
    }

    public static JSONObject buildJsonObject(String jsonString) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonString);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public static String getPlayAdId(Context context) {
        return Reflection.getPlayAdId(context);
    }

    public static Boolean isPlayTrackingEnabled(Context context) {
        return Reflection.isPlayTrackingEnabled(context);
    }

    public static boolean isGooglePlayServicesAvailable(Context context) {
        return Reflection.isGooglePlayServicesAvailable(context);
    }

    public static String getMacAddress(Context context) {
        return Reflection.getMacAddress(context);
    }

    public static String getMacSha1(String macAddress) {
        if (macAddress == null) {
            return null;
        }
        String macSha1 = Util.sha1(macAddress);
        return macSha1;
    }

    public static String getMacShortMd5(String macAddress) {
        if (macAddress == null) {
            return null;
        }
        String macShort = macAddress.replaceAll(":", "");
        String macShortMd5 = Util.md5(macShort);
        return macShortMd5;
    }

    public static String getAndroidId(Context context) {
        return Reflection.getAndroidId(context);
    }

    private static String sha1(String text) {
        return Util.hash(text, "SHA-1");
    }

    private static String md5(String text) {
        return Util.hash(text, "MD5");
    }

    private static String hash(String text, String method) {
        try {
            byte[] bytes = text.getBytes("UTF-8");
            MessageDigest mesd = MessageDigest.getInstance(method);
            mesd.update(bytes, 0, bytes.length);
            byte[] hash = mesd.digest();
            return Util.convertToHex(hash);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String convertToHex(byte[] bytes) {
        BigInteger bigInt = new BigInteger(1, bytes);
        String formatString = "%0" + (bytes.length << 1) + "x";
        return String.format(formatString, bigInt);
    }
}

