/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityKind;
import java.io.Serializable;
import java.util.Map;

public class ActivityPackage
implements Serializable {
    private static final long serialVersionUID = -35935556512024097L;
    private String path;
    private String userAgent;
    private String clientSdk;
    private Map<String, String> parameters;
    private ActivityKind activityKind;
    private String suffix;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getClientSdk() {
        return this.clientSdk;
    }

    public void setClientSdk(String clientSdk) {
        this.clientSdk = clientSdk;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public ActivityKind getActivityKind() {
        return this.activityKind;
    }

    public void setActivityKind(ActivityKind activityKind) {
        this.activityKind = activityKind;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String toString() {
        return String.format("%s%s", this.activityKind.toString(), this.suffix);
    }

    public String getExtendedString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Path:      %s\n", this.path));
        builder.append(String.format("UserAgent: %s\n", this.userAgent));
        builder.append(String.format("ClientSdk: %s\n", this.clientSdk));
        if (this.parameters != null) {
            builder.append("Parameters:");
            for (Map.Entry<String, String> entity : this.parameters.entrySet()) {
                builder.append(String.format("\n\t%-16s %s", entity.getKey(), entity.getValue()));
            }
        }
        return builder.toString();
    }

    protected String getSuccessMessage() {
        try {
            return String.format("Tracked %s%s", this.activityKind.toString(), this.suffix);
        }
        catch (NullPointerException e) {
            return "Tracked ???";
        }
    }

    protected String getFailureMessage() {
        try {
            return String.format("Failed to track %s%s", this.activityKind.toString(), this.suffix);
        }
        catch (NullPointerException e) {
            return "Failed to track ???";
        }
    }
}

