/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.preference.PreferenceManager;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.Logger;
import com.adjust.sdk.OnFinishedListener;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ActivityHandler
extends HandlerThread {
    private static long TIMER_INTERVAL;
    private static long SESSION_INTERVAL;
    private static long SUBSESSION_INTERVAL;
    private static final String TIME_TRAVEL = "Time travel!";
    private static final String ADJUST_PREFIX = "adjust_";
    private SessionHandler sessionHandler;
    private IPackageHandler packageHandler;
    private OnFinishedListener onFinishedListener;
    private ActivityState activityState;
    private Logger logger;
    private static ScheduledExecutorService timer;
    private Context context;
    private String environment;
    private String defaultTracker;
    private boolean eventBuffering;
    private boolean dropOfflineActivities;
    private boolean enabled;
    private String appToken;
    private String macSha1;
    private String macShortMd5;
    private String androidId;
    private String fbAttributionId;
    private String userAgent;
    private String clientSdk;

    public ActivityHandler(Activity activity) {
        super("Adjust", 1);
        this.initActivityHandler(activity);
        Message message = Message.obtain();
        message.arg1 = 72630;
        this.sessionHandler.sendMessage(message);
    }

    public ActivityHandler(Activity activity, String appToken, String environment, String logLevel, boolean eventBuffering) {
        super("Adjust", 1);
        this.initActivityHandler(activity);
        this.environment = environment;
        this.eventBuffering = eventBuffering;
        this.logger.setLogLevelString(logLevel);
        Message message = Message.obtain();
        message.arg1 = 72633;
        message.obj = appToken;
        this.sessionHandler.sendMessage(message);
    }

    private void initActivityHandler(Activity activity) {
        this.setDaemon(true);
        this.start();
        TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        SESSION_INTERVAL = AdjustFactory.getSessionInterval();
        SUBSESSION_INTERVAL = AdjustFactory.getSubsessionInterval();
        this.sessionHandler = new SessionHandler(this.getLooper(), this);
        this.context = activity.getApplicationContext();
        this.clientSdk = "android3.5.0";
        this.enabled = true;
        this.logger = AdjustFactory.getLogger();
    }

    public void setSdkPrefix(String sdkPrefx) {
        this.clientSdk = String.format("%s@%s", sdkPrefx, this.clientSdk);
    }

    public void setOnFinishedListener(OnFinishedListener listener) {
        this.onFinishedListener = listener;
    }

    public void trackSubsessionStart() {
        Message message = Message.obtain();
        message.arg1 = 72640;
        this.sessionHandler.sendMessage(message);
    }

    public void trackSubsessionEnd() {
        Message message = Message.obtain();
        message.arg1 = 72650;
        this.sessionHandler.sendMessage(message);
    }

    public void trackEvent(String eventToken, Map<String, String> parameters) {
        PackageBuilder builder = new PackageBuilder(this.context);
        builder.setEventToken(eventToken);
        builder.setCallbackParameters(parameters);
        Message message = Message.obtain();
        message.arg1 = 72660;
        message.obj = builder;
        this.sessionHandler.sendMessage(message);
    }

    public void trackRevenue(double amountInCents, String eventToken, Map<String, String> parameters) {
        PackageBuilder builder = new PackageBuilder(this.context);
        builder.setAmountInCents(amountInCents);
        builder.setEventToken(eventToken);
        builder.setCallbackParameters(parameters);
        Message message = Message.obtain();
        message.arg1 = 72670;
        message.obj = builder;
        this.sessionHandler.sendMessage(message);
    }

    public void finishedTrackingActivity(final ResponseData responseData, final String deepLink) {
        if (this.onFinishedListener == null && deepLink == null) {
            return;
        }
        Handler handler = new Handler(this.context.getMainLooper());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ActivityHandler.this.runDelegateMain(responseData);
                    ActivityHandler.this.launchDeepLinkMain(deepLink);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        };
        handler.post(runnable);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
        if (this.checkActivityState(this.activityState)) {
            this.activityState.enabled = enabled;
        }
        if (enabled.booleanValue()) {
            this.trackSubsessionStart();
        } else {
            this.trackSubsessionEnd();
        }
    }

    public Boolean isEnabled() {
        if (this.checkActivityState(this.activityState)) {
            return this.activityState.enabled;
        }
        return this.enabled;
    }

    public void readOpenUrl(Uri url) {
        Message message = Message.obtain();
        message.arg1 = 72680;
        message.obj = url;
        this.sessionHandler.sendMessage(message);
    }

    private void initInternal(boolean fromBundle, String appToken) {
        if (fromBundle) {
            appToken = this.processApplicationBundle();
        } else {
            this.setEnvironment(this.environment);
            this.setEventBuffering(this.eventBuffering);
        }
        if (!this.canInit(appToken)) {
            return;
        }
        this.appToken = appToken;
        this.androidId = Util.getAndroidId(this.context);
        this.fbAttributionId = Util.getAttributionId(this.context);
        this.userAgent = Util.getUserAgent(this.context);
        String playAdId = Util.getPlayAdId(this.context);
        if (playAdId == null) {
            this.logger.info("Unable to get Google Play Services Advertising ID at start time", new Object[0]);
        }
        if (!Util.isGooglePlayServicesAvailable(this.context)) {
            String macAddress = Util.getMacAddress(this.context);
            this.macSha1 = Util.getMacSha1(macAddress);
            this.macShortMd5 = Util.getMacShortMd5(macAddress);
        }
        this.packageHandler = AdjustFactory.getPackageHandler(this, this.context, this.dropOfflineActivities);
        this.readActivityState();
    }

    private boolean canInit(String appToken) {
        return this.checkAppTokenNotNull(appToken) && this.checkAppTokenLength(appToken) && this.checkContext(this.context) && this.checkPermissions(this.context);
    }

    private void startInternal() {
        if (!this.checkAppTokenNotNull(this.appToken)) {
            return;
        }
        if (this.activityState != null && !this.activityState.enabled.booleanValue()) {
            return;
        }
        this.packageHandler.resumeSending();
        this.startTimer();
        long now = System.currentTimeMillis();
        if (null == this.activityState) {
            this.activityState = new ActivityState();
            this.activityState.sessionCount = 1;
            this.activityState.createdAt = now;
            this.transferSessionPackage();
            this.activityState.resetSessionAttributes(now);
            this.activityState.enabled = this.enabled;
            this.writeActivityState();
            this.logger.info("First session", new Object[0]);
            return;
        }
        long lastInterval = now - this.activityState.lastActivity;
        if (lastInterval < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
            this.activityState.lastActivity = now;
            this.writeActivityState();
            return;
        }
        if (lastInterval > SESSION_INTERVAL) {
            ++this.activityState.sessionCount;
            this.activityState.createdAt = now;
            this.activityState.lastInterval = lastInterval;
            this.transferSessionPackage();
            this.activityState.resetSessionAttributes(now);
            this.writeActivityState();
            this.logger.debug("Session %d", this.activityState.sessionCount);
            return;
        }
        if (lastInterval > SUBSESSION_INTERVAL) {
            ++this.activityState.subsessionCount;
            this.logger.info("Started subsession %d of session %d", this.activityState.subsessionCount, this.activityState.sessionCount);
        }
        this.activityState.sessionLength += lastInterval;
        this.activityState.lastActivity = now;
        this.writeActivityState();
    }

    private void endInternal() {
        if (!this.checkAppTokenNotNull(this.appToken)) {
            return;
        }
        this.packageHandler.pauseSending();
        this.stopTimer();
        this.updateActivityState(System.currentTimeMillis());
        this.writeActivityState();
    }

    private void trackEventInternal(PackageBuilder eventBuilder) {
        long now;
        if (!this.canTrackEvent(eventBuilder)) {
            return;
        }
        if (!this.activityState.enabled.booleanValue()) {
            return;
        }
        this.activityState.createdAt = now = System.currentTimeMillis();
        ++this.activityState.eventCount;
        this.updateActivityState(now);
        this.injectGeneralAttributes(eventBuilder);
        this.activityState.injectEventAttributes(eventBuilder);
        ActivityPackage eventPackage = eventBuilder.buildEventPackage();
        this.packageHandler.addPackage(eventPackage);
        if (this.eventBuffering) {
            this.logger.info("Buffered event %s", eventPackage.getSuffix());
        } else {
            this.packageHandler.sendFirstPackage();
        }
        this.writeActivityState();
        this.logger.debug("Event %d", this.activityState.eventCount);
    }

    private void trackRevenueInternal(PackageBuilder revenueBuilder) {
        long now;
        if (!this.canTrackRevenue(revenueBuilder)) {
            return;
        }
        if (!this.activityState.enabled.booleanValue()) {
            return;
        }
        this.activityState.createdAt = now = System.currentTimeMillis();
        ++this.activityState.eventCount;
        this.updateActivityState(now);
        this.injectGeneralAttributes(revenueBuilder);
        this.activityState.injectEventAttributes(revenueBuilder);
        ActivityPackage eventPackage = revenueBuilder.buildRevenuePackage();
        this.packageHandler.addPackage(eventPackage);
        if (this.eventBuffering) {
            this.logger.info("Buffered revenue %s", eventPackage.getSuffix());
        } else {
            this.packageHandler.sendFirstPackage();
        }
        this.writeActivityState();
        this.logger.debug("Event %d (revenue)", this.activityState.eventCount);
    }

    private void readOpenUrlInternal(Uri url) {
        String[] queryPairs;
        if (url == null) {
            return;
        }
        String queryString = url.getQuery();
        if (queryString == null) {
            return;
        }
        HashMap<String, String> adjustDeepLinks = new HashMap<String, String>();
        for (String pair : queryPairs = queryString.split("&")) {
            String keyWOutPrefix;
            String value;
            String key;
            String[] pairComponents = pair.split("=");
            if (pairComponents.length != 2 || !(key = pairComponents[0]).startsWith(ADJUST_PREFIX) || (value = pairComponents[1]).length() == 0 || (keyWOutPrefix = key.substring(ADJUST_PREFIX.length())).length() == 0) continue;
            adjustDeepLinks.put(keyWOutPrefix, value);
        }
        if (adjustDeepLinks.size() == 0) {
            return;
        }
        PackageBuilder builder = new PackageBuilder(this.context);
        builder.setDeepLinkParameters(adjustDeepLinks);
        this.injectGeneralAttributes(builder);
        ActivityPackage reattributionPackage = builder.buildReattributionPackage();
        this.packageHandler.addPackage(reattributionPackage);
        this.packageHandler.sendFirstPackage();
        this.logger.debug("Reattribution %s", ((Object)adjustDeepLinks).toString());
    }

    private void runDelegateMain(ResponseData responseData) {
        if (this.onFinishedListener == null) {
            return;
        }
        if (responseData == null) {
            return;
        }
        this.onFinishedListener.onFinishedTracking(responseData);
    }

    private void launchDeepLinkMain(String deepLink) {
        boolean isIntentSafe;
        if (deepLink == null) {
            return;
        }
        Uri location = Uri.parse((String)deepLink);
        Intent mapIntent = new Intent("android.intent.action.VIEW", location);
        mapIntent.setFlags(0x10000000);
        PackageManager packageManager = this.context.getPackageManager();
        List activities = packageManager.queryIntentActivities(mapIntent, 0);
        boolean bl = isIntentSafe = activities.size() > 0;
        if (!isIntentSafe) {
            this.logger.error("Unable to open deep link (%s)", deepLink);
            return;
        }
        this.logger.info("Open deep link (%s)", deepLink);
        this.context.startActivity(mapIntent);
    }

    private boolean canTrackEvent(PackageBuilder revenueBuilder) {
        return this.checkAppTokenNotNull(this.appToken) && this.checkActivityState(this.activityState) && revenueBuilder.isValidForEvent();
    }

    private boolean canTrackRevenue(PackageBuilder revenueBuilder) {
        return this.checkAppTokenNotNull(this.appToken) && this.checkActivityState(this.activityState) && revenueBuilder.isValidForRevenue();
    }

    private void updateActivityState(long now) {
        if (!this.checkActivityState(this.activityState)) {
            return;
        }
        long lastInterval = now - this.activityState.lastActivity;
        if (lastInterval < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
            this.activityState.lastActivity = now;
            return;
        }
        if (lastInterval > SESSION_INTERVAL) {
            return;
        }
        this.activityState.sessionLength += lastInterval;
        this.activityState.timeSpent += lastInterval;
        this.activityState.lastActivity = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readActivityState() {
        try {
            FileInputStream inputStream = this.context.openFileInput("AdjustIoActivityState");
            BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
            ObjectInputStream objectStream = new ObjectInputStream(bufferedStream);
            try {
                this.activityState = (ActivityState)objectStream.readObject();
                this.logger.debug("Read activity state: %s uuid:%s", this.activityState, this.activityState.uuid);
                return;
            }
            catch (ClassNotFoundException e) {
                this.logger.error("Failed to find activity state class", new Object[0]);
            }
            catch (OptionalDataException e) {
            }
            catch (IOException e) {
                this.logger.error("Failed to read activity states object", new Object[0]);
            }
            catch (ClassCastException e) {
                this.logger.error("Failed to cast activity state object", new Object[0]);
            }
            finally {
                objectStream.close();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.verbose("Activity state file not found", new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Failed to open activity state file for reading (%s)", e);
        }
        this.activityState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeActivityState() {
        try {
            FileOutputStream outputStream = this.context.openFileOutput("AdjustIoActivityState", 0);
            BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
            ObjectOutputStream objectStream = new ObjectOutputStream(bufferedStream);
            try {
                objectStream.writeObject(this.activityState);
                this.logger.debug("Wrote activity state: %s", this.activityState);
            }
            catch (NotSerializableException e) {
                this.logger.error("Failed to serialize activity state", new Object[0]);
            }
            finally {
                objectStream.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to open activity state for writing (%s)", e);
        }
    }

    public static Boolean deleteActivityState(Context context) {
        return context.deleteFile("AdjustIoActivityState");
    }

    private void transferSessionPackage() {
        PackageBuilder builder = new PackageBuilder(this.context);
        this.injectGeneralAttributes(builder);
        this.injectReferrer(builder);
        this.activityState.injectSessionAttributes(builder);
        ActivityPackage sessionPackage = builder.buildSessionPackage();
        this.packageHandler.addPackage(sessionPackage);
        this.packageHandler.sendFirstPackage();
    }

    private void injectGeneralAttributes(PackageBuilder builder) {
        builder.setAppToken(this.appToken);
        builder.setMacShortMd5(this.macShortMd5);
        builder.setMacSha1(this.macSha1);
        builder.setAndroidId(this.androidId);
        builder.setFbAttributionId(this.fbAttributionId);
        builder.setUserAgent(this.userAgent);
        builder.setClientSdk(this.clientSdk);
        builder.setEnvironment(this.environment);
        builder.setDefaultTracker(this.defaultTracker);
    }

    private void injectReferrer(PackageBuilder builder) {
        try {
            SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
            builder.setReferrer(preferences.getString("AdjustInstallReferrer", null));
        }
        catch (Exception e) {
            this.logger.error("Failed to inject referrer (%s)", e);
        }
    }

    private void startTimer() {
        if (timer != null) {
            this.stopTimer();
        }
        timer = Executors.newSingleThreadScheduledExecutor();
        timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.timerFired();
            }
        }, 1000L, TIMER_INTERVAL, TimeUnit.MILLISECONDS);
    }

    private void stopTimer() {
        try {
            timer.shutdown();
        }
        catch (NullPointerException e) {
            this.logger.error("No timer found", new Object[0]);
        }
    }

    private void timerFired() {
        if (null != this.activityState && !this.activityState.enabled.booleanValue()) {
            return;
        }
        this.packageHandler.sendFirstPackage();
        this.updateActivityState(System.currentTimeMillis());
        this.writeActivityState();
    }

    private boolean checkPermissions(Context context) {
        boolean result = true;
        if (!ActivityHandler.checkPermission(context, "android.permission.INTERNET")) {
            this.logger.error("Missing permission: INTERNET", new Object[0]);
            result = false;
        }
        if (!ActivityHandler.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            this.logger.warn("Missing permission: ACCESS_WIFI_STATE", new Object[0]);
        }
        return result;
    }

    private String processApplicationBundle() {
        Bundle bundle = this.getApplicationBundle();
        if (null == bundle) {
            return null;
        }
        String appToken = bundle.getString("AdjustAppToken");
        this.setEnvironment(bundle.getString("AdjustEnvironment"));
        this.setDefaultTracker(bundle.getString("AdjustDefaultTracker"));
        this.setEventBuffering(bundle.getBoolean("AdjustEventBuffering"));
        this.logger.setLogLevelString(bundle.getString("AdjustLogLevel"));
        this.setDropOfflineActivities(bundle.getBoolean("AdjustDropOfflineActivities"));
        return appToken;
    }

    private void setEnvironment(String env) {
        this.environment = env;
        if (null == this.environment) {
            this.logger.Assert("Missing environment", new Object[0]);
            this.logger.setLogLevel(Logger.LogLevel.ASSERT);
            this.environment = "unknown";
        } else if ("sandbox".equalsIgnoreCase(this.environment)) {
            this.logger.Assert("SANDBOX: Adjust is running in Sandbox mode. Use this setting for testing. Don't forget to set the environment to `production` before publishing!", new Object[0]);
        } else if ("production".equalsIgnoreCase(this.environment)) {
            this.logger.Assert("PRODUCTION: Adjust is running in Production mode. Use this setting only for the build that you want to publish. Set the environment to `sandbox` if you want to test your app!", new Object[0]);
            this.logger.setLogLevel(Logger.LogLevel.ASSERT);
        } else {
            this.logger.Assert("Malformed environment '%s'", this.environment);
            this.logger.setLogLevel(Logger.LogLevel.ASSERT);
            this.environment = "malformed";
        }
    }

    private void setEventBuffering(boolean buffering) {
        this.eventBuffering = buffering;
        if (this.eventBuffering) {
            this.logger.info("Event buffering is enabled", new Object[0]);
        }
    }

    private void setDefaultTracker(String tracker) {
        this.defaultTracker = tracker;
        if (this.defaultTracker != null) {
            this.logger.info("Default tracker: '%s'", this.defaultTracker);
        }
    }

    private void setDropOfflineActivities(boolean drop) {
        this.dropOfflineActivities = drop;
        if (this.dropOfflineActivities) {
            this.logger.info("Offline activities will get dropped", new Object[0]);
        }
    }

    private Bundle getApplicationBundle() {
        try {
            String packageName = this.context.getPackageName();
            ApplicationInfo applicationInfo = this.context.getPackageManager().getApplicationInfo(packageName, 128);
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            this.logger.error("ApplicationInfo not found", new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Failed to get ApplicationBundle (%s)", e);
        }
        return null;
    }

    private boolean checkContext(Context context) {
        if (null == context) {
            this.logger.error("Missing context", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean checkPermission(Context context, String permission) {
        int result = context.checkCallingOrSelfPermission(permission);
        return result == 0;
    }

    private boolean checkActivityState(ActivityState activityState) {
        if (null == activityState) {
            this.logger.error("Missing activity state.", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkAppTokenNotNull(String appToken) {
        if (null == appToken) {
            this.logger.error("Missing App Token.", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkAppTokenLength(String appToken) {
        if (12 != appToken.length()) {
            this.logger.error("Malformed App Token '%s'", appToken);
            return false;
        }
        return true;
    }

    private static final class SessionHandler
    extends Handler {
        private static final int INIT_BUNDLE = 72630;
        private static final int INIT_PRESET = 72633;
        private static final int START = 72640;
        private static final int END = 72650;
        private static final int EVENT = 72660;
        private static final int REVENUE = 72670;
        private static final int DEEP_LINK = 72680;
        private final WeakReference<ActivityHandler> sessionHandlerReference;

        protected SessionHandler(Looper looper, ActivityHandler sessionHandler) {
            super(looper);
            this.sessionHandlerReference = new WeakReference<ActivityHandler>(sessionHandler);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            ActivityHandler sessionHandler = (ActivityHandler)((Object)this.sessionHandlerReference.get());
            if (sessionHandler == null) {
                return;
            }
            switch (message.arg1) {
                case 72630: {
                    sessionHandler.initInternal(true, null);
                    break;
                }
                case 72633: {
                    String appToken = (String)message.obj;
                    sessionHandler.initInternal(false, appToken);
                    break;
                }
                case 72640: {
                    sessionHandler.startInternal();
                    break;
                }
                case 72650: {
                    sessionHandler.endInternal();
                    break;
                }
                case 72660: {
                    PackageBuilder eventBuilder = (PackageBuilder)message.obj;
                    sessionHandler.trackEventInternal(eventBuilder);
                    break;
                }
                case 72670: {
                    PackageBuilder revenueBuilder = (PackageBuilder)message.obj;
                    sessionHandler.trackRevenueInternal(revenueBuilder);
                    break;
                }
                case 72680: {
                    Uri url = (Uri)message.obj;
                    sessionHandler.readOpenUrlInternal(url);
                }
            }
        }
    }
}

