/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.utils;

public class ArrayUtils {
    public static double min(double[] array) {
        double min = Double.MAX_VALUE;
        for (double d : array) {
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public static float min(float[] array) {
        float min = Float.MAX_VALUE;
        for (float d : array) {
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public static long min(long[] array) {
        long min = Long.MAX_VALUE;
        for (long d : array) {
            if (d >= min) continue;
            min = d;
        }
        return min;
    }

    public static double max(double[] array) {
        double max = Double.MIN_VALUE;
        for (double d : array) {
            if (Double.compare(d, max) != 1) continue;
            max = d;
        }
        return max;
    }

    public static float max(float[] array) {
        float max = Float.MIN_VALUE;
        for (float d : array) {
            if (Float.compare(d, max) != 1) continue;
            max = d;
        }
        return max;
    }

    public static long max(long[] array) {
        long max = Long.MIN_VALUE;
        for (long l : array) {
            if (Long.compare(l, max) != 1) continue;
            max = l;
        }
        return max;
    }

    public static double max(double[] array, int start, int stop) {
        double max = Double.MIN_VALUE;
        for (int i = start; i <= stop; ++i) {
            if (Double.compare(array[i], max) != 1) continue;
            max = array[i];
        }
        return max;
    }

    public static double min(double[] array, int start, int stop) {
        double min = Double.MAX_VALUE;
        for (int i = start; i <= stop; ++i) {
            if (Double.compare(array[i], min) != -1) continue;
            min = array[i];
        }
        return min;
    }

    public static double[] round(double[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            array[i] = Math.floor(1000.0 * array[i] + 0.5) / 1000.0;
        }
        return array;
    }

    public static double[] getDelta(double[] array) {
        double[] delta = new double[array.length];
        for (int i = 0; i < array.length - 1; ++i) {
            delta[i] = array[i + 1] - array[i];
        }
        return delta;
    }

    public static double[] makeInterpolation(double[] array, int start, int stop) {
        double step = (array[stop] - array[start]) / (double)(stop - start);
        double currentVal = array[start];
        for (int j = start; j < stop; ++j) {
            array[j] = currentVal;
            currentVal += step;
            if (step > 0.0) {
                if (!(currentVal > array[stop])) continue;
                currentVal = array[stop];
                continue;
            }
            if (!(currentVal < array[stop])) continue;
            currentVal = array[start];
        }
        return array;
    }

    public static double getYValue(long[] xArray, double[] yArray, long x) {
        if (x > xArray[xArray.length - 1]) {
            return yArray[yArray.length - 1];
        }
        if (x < xArray[0]) {
            return yArray[0];
        }
        for (int i = 0; i < xArray.length - 1; ++i) {
            long x1 = xArray[i];
            long x2 = xArray[i + 1];
            if (x1 > x || x2 < x) continue;
            float prcnt = (float)(x - x1) / (float)(x2 - x1);
            double y1 = yArray[i];
            double y2 = yArray[i + 1];
            return y1 + (y2 - y1) * (double)prcnt;
        }
        return 0.0;
    }

    public static double getMaxYFromXRange(long[] xArray, double[] yArray, long minX, long maxX) {
        long x1;
        int i;
        double resultY = -1.0;
        double maxY = Double.MIN_VALUE;
        for (i = 0; i < yArray.length; ++i) {
            x1 = xArray[i];
            if (x1 < minX || x1 > maxX || !(maxY < yArray[i])) continue;
            maxY = yArray[i];
        }
        for (i = 0; i < xArray.length - 1; ++i) {
            double y2;
            double y1;
            float prcnt;
            x1 = xArray[i];
            long x2 = xArray[i + 1];
            if (x1 <= minX && x2 >= minX) {
                prcnt = (float)(minX - x1) / (float)(x2 - x1);
                y1 = yArray[i];
                y2 = yArray[i + 1];
                resultY = y1 + (y2 - y1) * (double)prcnt;
            }
            if (x1 <= maxX && x2 >= maxX) {
                prcnt = (float)(maxX - x1) / (float)(x2 - x1);
                y1 = yArray[i];
                y2 = yArray[i + 1];
                resultY = y1 + (y2 - y1) * (double)prcnt;
            }
            if (!(maxY < resultY)) continue;
            maxY = resultY;
        }
        return maxY;
    }

    public static double getMinYFromXRange(long[] xArray, double[] yArray, long minX, long maxX) {
        long x1;
        int i;
        double resultY = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        for (i = 0; i < yArray.length; ++i) {
            x1 = xArray[i];
            if (x1 < minX || x1 > maxX || !(yArray[i] < minY)) continue;
            minY = yArray[i];
        }
        for (i = 0; i < xArray.length - 1; ++i) {
            double y2;
            double y1;
            float prcnt;
            x1 = xArray[i];
            long x2 = xArray[i + 1];
            if (x1 <= minX && x2 >= minX) {
                prcnt = (float)(minX - x1) / (float)(x2 - x1);
                y1 = yArray[i];
                y2 = yArray[i + 1];
                resultY = y1 + (y2 - y1) * (double)prcnt;
            }
            if (x1 <= maxX && x2 >= maxX) {
                prcnt = (float)(maxX - x1) / (float)(x2 - x1);
                y1 = yArray[i];
                y2 = yArray[i + 1];
                resultY = y1 + (y2 - y1) * (double)prcnt;
            }
            if (!(minY > resultY)) continue;
            minY = resultY;
        }
        return minY;
    }

    public static int indexOf(double[] arr, double val) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != val) continue;
            return i;
        }
        return -1;
    }
}

