/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.Window;
import com.adi.lib.R;
import com.adi.lib.chart.Settings;

public class AndroidUtils {
    public static float dpToPx(Context context, float dp) {
        return dp * context.getResources().getDisplayMetrics().density;
    }

    public static void changeSystemColor(AppCompatActivity activity, Toolbar toolbar, Menu menu) {
        int toolbarTextColor;
        int colorPrimary;
        if (Settings.theme == R.style.AppTheme) {
            colorPrimary = ContextCompat.getColor((Context)activity, (int)R.color.colorPrimary);
            toolbarTextColor = ContextCompat.getColor((Context)activity, (int)R.color.toolbarTextColor);
            menu.getItem(0).setIcon(ContextCompat.getDrawable((Context)activity, (int)R.drawable.ic_brightness_2_gray_36dp));
        } else {
            colorPrimary = ContextCompat.getColor((Context)activity, (int)R.color.darkColorPrimary);
            toolbarTextColor = ContextCompat.getColor((Context)activity, (int)R.color.darkToolbarTextColor);
            menu.getItem(0).setIcon(ContextCompat.getDrawable((Context)activity, (int)R.drawable.ic_brightness_2_white_36dp));
        }
        AndroidUtils.setStatusBarColor((Activity)activity);
        if (activity.getSupportActionBar() != null) {
            activity.getSupportActionBar().setBackgroundDrawable((Drawable)new ColorDrawable(colorPrimary));
            toolbar.setTitleTextColor(toolbarTextColor);
        }
    }

    public static void setStatusBarColor(Activity activity) {
        int colorPrimaryDarkSupported;
        int colorPrimaryDark;
        if (Settings.theme == R.style.AppTheme) {
            colorPrimaryDark = ContextCompat.getColor((Context)activity, (int)R.color.colorPrimaryDark);
            colorPrimaryDarkSupported = ContextCompat.getColor((Context)activity, (int)R.color.colorPrimaryDarkSupported);
        } else {
            colorPrimaryDark = ContextCompat.getColor((Context)activity, (int)R.color.darkColorPrimaryDark);
            colorPrimaryDarkSupported = ContextCompat.getColor((Context)activity, (int)R.color.darkColorPrimaryDarkSupported);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            if (Build.VERSION.SDK_INT >= 23) {
                window.setStatusBarColor(colorPrimaryDark);
                if (Settings.theme == R.style.AppTheme) {
                    window.getDecorView().setSystemUiVisibility(window.getDecorView().getSystemUiVisibility() | 0x2000);
                } else {
                    window.getDecorView().setSystemUiVisibility(window.getDecorView().getSystemUiVisibility() & 0xFFFFDFFF);
                }
            } else {
                window.setStatusBarColor(colorPrimaryDarkSupported);
            }
        }
    }
}

