/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.adi.lib.R;
import com.adi.lib.chart.ChartView;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.Scene;
import com.adi.lib.utils.AndroidUtils;
import java.util.List;

public class SliderView
extends View {
    List<ChartLine> chartLines;
    float verticalBorder;
    float horizontalBorder;
    long minX;
    long maxX;
    long sliderMinX;
    long sliderMaxX;
    long sliderWidth;
    long minSliderWith;
    Scene scene;
    private ChangeListener changeListener;
    GestureDetector gestureDetector;
    short scrollMode;
    Paint paint = new Paint();
    Paint clear = new Paint(1);
    RectF rectf = new RectF();
    int sliderDarkColor;
    int sliderLightColor;
    float screenSlideMinX;
    float screenSlideMaxX;
    float padding;
    float cornerRadius;
    float screenSliderMinX;
    float screenSliderMaxX;
    float whiteDashWidth;
    float whiteDashHeight;
    float whiteDashCornerRadius;
    Runnable stopScrollDetector;
    Handler handler = new Handler(Looper.getMainLooper());

    public SliderView(Context context) {
        super(context);
        this.init();
    }

    public SliderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SliderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.stopScrollDetector = () -> this.changeListener.onStopScroll();
        this.setLayerType(1, null);
        this.paint.setAntiAlias(true);
        this.clear.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.verticalBorder = Math.round(AndroidUtils.dpToPx(this.getContext(), 1.0f));
        this.whiteDashWidth = Math.round(AndroidUtils.dpToPx(this.getContext(), 2.0f));
        this.whiteDashHeight = Math.round(AndroidUtils.dpToPx(this.getContext(), 11.0f));
        this.whiteDashCornerRadius = Math.round(AndroidUtils.dpToPx(this.getContext(), 2.0f));
        this.horizontalBorder = Math.round(AndroidUtils.dpToPx(this.getContext(), 11.0f));
        this.cornerRadius = Math.round(AndroidUtils.dpToPx(this.getContext(), 6.0f));
        this.gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent e) {
                SliderView.this.screenSlideMinX = SliderView.this.getScreenX(SliderView.this.sliderMinX);
                SliderView.this.screenSlideMaxX = SliderView.this.getScreenX(SliderView.this.sliderMaxX);
                SliderView.this.padding = (SliderView.this.screenSlideMaxX - SliderView.this.screenSlideMinX) / 5.0f;
                if (e.getX() < SliderView.this.screenSlideMinX - SliderView.this.padding || e.getX() > SliderView.this.screenSlideMaxX + SliderView.this.padding) {
                    return false;
                }
                SliderView.this.scrollMode = e.getX() > SliderView.this.screenSlideMinX + SliderView.this.padding && e.getX() < SliderView.this.screenSlideMaxX - SliderView.this.padding ? (short)2 : (e.getX() <= SliderView.this.screenSlideMinX + SliderView.this.padding && e.getX() >= SliderView.this.screenSlideMinX - SliderView.this.padding ? (short)0 : 1);
                return true;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (e1.getX() > e2.getX()) {
                    SliderView.this.scene.setMoveDirection(0);
                } else {
                    SliderView.this.scene.setMoveDirection(1);
                }
                float scrollInPercent = distanceX / (float)SliderView.this.getWidth();
                if (SliderView.this.scrollMode == 2) {
                    SliderView.this.moveSlider(scrollInPercent);
                    SliderView.this.changeListener.onSliderChanged(SliderView.this.sliderMinX, SliderView.this.sliderMaxX, false);
                } else {
                    SliderView.this.changeSliderWidth(scrollInPercent);
                    SliderView.this.changeListener.onSliderChanged(SliderView.this.sliderMinX, SliderView.this.sliderMaxX, true);
                }
                SliderView.this.handler.removeCallbacks(SliderView.this.stopScrollDetector);
                SliderView.this.handler.postDelayed(SliderView.this.stopScrollDetector, 100L);
                SliderView.this.invalidate();
                return true;
            }
        });
        this.applyTheme();
    }

    public void applyTheme() {
        if (ChartView.THEME == 0) {
            this.sliderDarkColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.sliderDark);
            this.sliderLightColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.sliderLight);
        } else {
            this.sliderDarkColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkSliderDark);
            this.sliderLightColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkSliderLight);
        }
    }

    private void changeSliderWidth(float delta) {
        if (this.scrollMode == 0) {
            if (delta > 0.0f) {
                this.sliderMinX -= (long)Math.abs((float)(this.maxX - this.minX) * delta);
                if (this.sliderMinX < this.minX) {
                    this.sliderMinX = this.minX;
                }
            } else {
                this.sliderMinX += (long)Math.abs((float)(this.maxX - this.minX) * delta);
                if (this.sliderMaxX - this.sliderMinX < this.minSliderWith) {
                    this.sliderMinX = this.sliderMaxX - this.minSliderWith;
                }
            }
        } else if (delta > 0.0f) {
            this.sliderMaxX -= (long)Math.abs((float)(this.maxX - this.minX) * delta);
            if (this.sliderMaxX - this.sliderMinX < this.minSliderWith) {
                this.sliderMaxX = this.sliderMinX + this.minSliderWith;
            }
        } else {
            this.sliderMaxX += (long)Math.abs((float)(this.maxX - this.minX) * delta);
            if (this.sliderMaxX > this.maxX) {
                this.sliderMaxX = this.maxX;
            }
        }
        this.sliderWidth = this.sliderMaxX - this.sliderMinX;
    }

    private void moveSlider(float delta) {
        if (delta > 0.0f) {
            this.sliderMinX -= (long)Math.abs((float)(this.maxX - this.minX) * delta);
            if (this.sliderMinX < this.minX) {
                this.sliderMinX = this.minX;
            }
            this.sliderMaxX = this.sliderMinX + this.sliderWidth;
        } else {
            this.sliderMaxX += (long)Math.abs((float)(this.maxX - this.minX) * delta);
            if (this.sliderMaxX > this.maxX) {
                this.sliderMaxX = this.maxX;
            }
            this.sliderMinX = this.sliderMaxX - this.sliderWidth;
        }
    }

    public void updateChart(List<ChartLine> chartLines, Scene scene) {
        this.chartLines = chartLines;
        if (this.scene == null) {
            this.scene = scene;
            this.minX = chartLines.get(0).getX()[0];
            this.maxX = chartLines.get(0).getX()[chartLines.get(0).getX().length - 1];
            this.sliderMinX = this.maxX - scene.getMinSliderWidth();
            this.sliderMaxX = this.maxX;
            this.sliderWidth = this.sliderMaxX - this.sliderMinX;
            this.minSliderWith = scene.getMinSliderWidth();
        }
        this.changeListener.onSliderChanged(this.sliderMinX, this.sliderMaxX, true);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        this.screenSliderMinX = this.getScreenX(this.sliderMinX);
        this.screenSliderMaxX = this.getScreenX(this.sliderMaxX);
        if (ChartView.THEME == 1) {
            this.paint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkChartViewBackgroundColor));
        } else {
            this.paint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.chartViewBackgroundColor));
        }
        this.paint.setStyle(Paint.Style.FILL);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint);
        this.paint.setColor(this.sliderLightColor);
        this.rectf.set(0.0f, this.verticalBorder, (float)this.getWidth(), (float)this.getHeight() - this.verticalBorder);
        canvas.drawRoundRect(this.rectf, this.cornerRadius, this.cornerRadius, this.clear);
        canvas.drawRoundRect(this.rectf, this.cornerRadius, this.cornerRadius, this.paint);
        this.paint.setColor(this.sliderDarkColor);
        this.rectf.set(this.screenSliderMinX, 0.0f, this.screenSliderMaxX, (float)this.getHeight());
        canvas.drawRoundRect(this.rectf, this.cornerRadius, this.cornerRadius, this.paint);
        canvas.drawRect(this.screenSliderMinX + this.horizontalBorder, 0.0f + this.verticalBorder, this.screenSliderMaxX - this.horizontalBorder, (float)this.getHeight() - this.verticalBorder, this.clear);
        this.paint.setColor(-1);
        this.rectf.set(this.screenSliderMinX + (this.horizontalBorder - this.whiteDashWidth) / 2.0f, 0.0f + ((float)this.getHeight() - this.whiteDashHeight) / 2.0f, this.screenSliderMinX + (this.horizontalBorder - this.whiteDashWidth) / 2.0f + this.whiteDashWidth, (float)this.getHeight() - ((float)this.getHeight() - this.whiteDashHeight) / 2.0f);
        canvas.drawRoundRect(this.rectf, this.whiteDashCornerRadius, this.whiteDashCornerRadius, this.paint);
        this.rectf.set(this.screenSliderMaxX - (this.horizontalBorder - this.whiteDashWidth) / 2.0f - this.whiteDashWidth, 0.0f + ((float)this.getHeight() - this.whiteDashHeight) / 2.0f, this.screenSliderMaxX - (this.horizontalBorder - this.whiteDashWidth) / 2.0f, (float)this.getHeight() - ((float)this.getHeight() - this.whiteDashHeight) / 2.0f);
        canvas.drawRoundRect(this.rectf, this.whiteDashCornerRadius, this.whiteDashCornerRadius, this.paint);
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    private float getScreenX(long x) {
        return (float)(x - this.minX) / (float)(this.maxX - this.minX) * (float)this.getWidth();
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.getParent().getParent().getParent().requestDisallowInterceptTouchEvent(true);
        if (this.gestureDetector.onTouchEvent(event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    public boolean performClick() {
        return super.performClick();
    }

    public static interface ChangeListener {
        public void onSliderChanged(long var1, long var3, boolean var5);

        public void onStopScroll();
    }
}

