/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.adi.lib.R;
import com.adi.lib.chart.ChartCore;
import com.adi.lib.chart.ChartView;
import com.adi.lib.chart.entity.Chart;
import com.adi.lib.chart.entity.PickerDetails;
import com.adi.lib.chart.entity.Scene;
import com.adi.lib.utils.AndroidUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class PickerView
extends View {
    private float cardVerticalMarginTop;
    private float cardVerticalMarginLeft;
    private float cardHorizontalMargin;
    private float cardVerticalPadding;
    private float cardHorizontalPadding;
    private float cardBottomPadding;
    private float rawHeight;
    private float dateRawHeight;
    private float arrowSize;
    private float arrowPaddingRight;
    private float arrowPaddingTop;
    private float paddingBetweenDates;
    private long[] xArray;
    protected long minX;
    protected long maxX;
    protected long horizontalPaddingInPercent;
    protected int horizontalPadding;
    protected float topPadding = 0.0f;
    protected float dateTopPadding;
    float dateFontSize;
    float valFontSize;
    float date1Width;
    float date2Width;
    float valueWidth;
    DateFormat df1 = new SimpleDateFormat("EEE, dd", Locale.US);
    DateFormat df2 = new SimpleDateFormat("MMM yyyy", Locale.US);
    RectF cardRect = new RectF();
    Paint dateTextPaint = new Paint();
    Paint showDateTextPaint = new Paint();
    Paint hideDateTextPaint = new Paint();
    Paint valTextPaint = new Paint();
    Paint showValTextPaint = new Paint();
    Paint hideValTextPaint = new Paint();
    Paint nameTextPaint = new Paint();
    float cornerRoundRadius;
    float circleBorderWidth;
    float circleRadius;
    Paint paint = new Paint();
    Paint circlePaint = new Paint();
    Paint platePaint = new Paint();
    Scene scene;
    private float height;
    private float width;
    GestureDetector gestureDetector;
    private PickListener pickListener;
    Chart chart;
    float minCardWidth;
    float left;
    float top;
    float x;
    float cardWidth;
    float cardHeight;
    private boolean picked;
    private PickerDetails pickerDetails = new PickerDetails();
    private PickerDetails oldPickerDetails;
    Date date = new Date();
    Drawable arrow;
    int idx;
    private float screenX;
    private boolean animateValues;
    private boolean animateDate1;
    private boolean animateDate2;
    private ValueAnimator hideSizeAnimator = new ValueAnimator();
    private ValueAnimator showSizeAnimator = new ValueAnimator();
    private ValueAnimator hideAlphaAnimator = new ValueAnimator();
    private ValueAnimator showAlphaAnimator = new ValueAnimator();
    private AnimatorSet animatorSet = new AnimatorSet();
    int showValueAlpha;
    int hideValueAlpha;
    private String fullDate1;
    private String fullDate2;

    public PickerView(Context context, Chart chart) {
        super(context);
        this.chart = chart;
        this.xArray = chart.getChartLines().get(0).getX();
        this.init();
    }

    private void init() {
        this.setLayerType(1, null);
        this.arrow = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.arrow);
        this.arrowSize = AndroidUtils.dpToPx(this.getContext(), 24.0f);
        this.arrowPaddingRight = AndroidUtils.dpToPx(this.getContext(), 6.0f);
        this.arrowPaddingTop = AndroidUtils.dpToPx(this.getContext(), 8.0f);
        this.minCardWidth = AndroidUtils.dpToPx(this.getContext(), 156.0f);
        this.cardVerticalMarginTop = AndroidUtils.dpToPx(this.getContext(), 0.0f);
        this.cardVerticalMarginLeft = AndroidUtils.dpToPx(this.getContext(), 14.0f);
        this.cardHorizontalMargin = AndroidUtils.dpToPx(this.getContext(), 14.0f);
        this.cardHorizontalPadding = AndroidUtils.dpToPx(this.getContext(), 15.0f);
        this.cardVerticalPadding = AndroidUtils.dpToPx(this.getContext(), 14.0f);
        this.cardHorizontalPadding = AndroidUtils.dpToPx(this.getContext(), 13.0f);
        this.cardBottomPadding = AndroidUtils.dpToPx(this.getContext(), 6.0f);
        this.paddingBetweenDates = AndroidUtils.dpToPx(this.getContext(), 6.0f);
        this.dateRawHeight = AndroidUtils.dpToPx(this.getContext(), 34.0f);
        this.rawHeight = AndroidUtils.dpToPx(this.getContext(), 24.0f);
        this.circleBorderWidth = AndroidUtils.dpToPx(this.getContext(), 2.0f);
        this.circleRadius = AndroidUtils.dpToPx(this.getContext(), 5.0f);
        this.cornerRoundRadius = AndroidUtils.dpToPx(this.getContext(), 4.0f);
        this.dateTopPadding = AndroidUtils.dpToPx(this.getContext(), 10.0f);
        this.paint.setStrokeWidth(AndroidUtils.dpToPx(this.getContext(), 1.0f));
        this.paint.setAntiAlias(true);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint.setStyle(Paint.Style.STROKE);
        this.dateFontSize = AndroidUtils.dpToPx(this.getContext(), 14.0f);
        this.dateTextPaint.setAntiAlias(true);
        this.dateTextPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        this.dateTextPaint.setTextSize(this.dateFontSize);
        this.dateTextPaint.setTextAlign(Paint.Align.RIGHT);
        this.showDateTextPaint.setAntiAlias(true);
        this.showDateTextPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        this.showDateTextPaint.setTextSize(this.dateFontSize);
        this.showDateTextPaint.setTextAlign(Paint.Align.LEFT);
        this.hideDateTextPaint.setAntiAlias(true);
        this.hideDateTextPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        this.hideDateTextPaint.setTextSize(this.dateFontSize);
        this.hideDateTextPaint.setTextAlign(Paint.Align.RIGHT);
        this.valFontSize = AndroidUtils.dpToPx(this.getContext(), 14.0f);
        this.valTextPaint.setAntiAlias(true);
        this.valTextPaint.setTextSize(AndroidUtils.dpToPx(this.getContext(), 14.0f));
        this.valTextPaint.setStyle(Paint.Style.FILL);
        this.valTextPaint.setTextAlign(Paint.Align.LEFT);
        this.valTextPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        this.showValTextPaint.setAntiAlias(true);
        this.showValTextPaint.setTextSize(AndroidUtils.dpToPx(this.getContext(), 14.0f));
        this.showValTextPaint.setStyle(Paint.Style.FILL);
        this.showValTextPaint.setTextAlign(Paint.Align.LEFT);
        this.showValTextPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        this.hideValTextPaint.setAntiAlias(true);
        this.hideValTextPaint.setTextSize(AndroidUtils.dpToPx(this.getContext(), 14.0f));
        this.hideValTextPaint.setStyle(Paint.Style.FILL);
        this.hideValTextPaint.setTextAlign(Paint.Align.RIGHT);
        this.hideValTextPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        this.nameTextPaint.setAntiAlias(true);
        this.nameTextPaint.setTextSize(AndroidUtils.dpToPx(this.getContext(), 14.0f));
        this.nameTextPaint.setStyle(Paint.Style.FILL);
        this.circlePaint = new Paint();
        this.circlePaint.setColor(-1);
        this.circlePaint.setStrokeWidth(2.0f);
        this.circlePaint.setStyle(Paint.Style.STROKE);
        this.platePaint = new Paint(1);
        this.platePaint.setColor(-1);
        this.gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent e) {
                if (PickerView.this.picked) {
                    if (!(e.getX() > PickerView.this.left && e.getX() < PickerView.this.left + PickerView.this.cardWidth && e.getY() > PickerView.this.top && e.getY() < PickerView.this.top + PickerView.this.cardHeight)) {
                        PickerView.this.pick(e.getX());
                    }
                } else {
                    PickerView.this.pick(e.getX());
                }
                return true;
            }
        });
        this.applyTheme();
        this.hideSizeAnimator.addUpdateListener(a -> {
            this.hideDateTextPaint.setTextSize(((Float)a.getAnimatedValue()).floatValue());
            this.hideValTextPaint.setTextSize(((Float)a.getAnimatedValue()).floatValue());
        });
        this.showSizeAnimator.addUpdateListener(a -> {
            this.showDateTextPaint.setTextSize(((Float)a.getAnimatedValue()).floatValue());
            this.showValTextPaint.setTextSize(((Float)a.getAnimatedValue()).floatValue());
        });
        this.hideAlphaAnimator.addUpdateListener(a -> {
            this.hideDateTextPaint.setAlpha(((Integer)a.getAnimatedValue()).intValue());
            this.hideValueAlpha = (Integer)a.getAnimatedValue();
        });
        this.showAlphaAnimator.addUpdateListener(a -> {
            this.showDateTextPaint.setAlpha(((Integer)a.getAnimatedValue()).intValue());
            this.showValueAlpha = (Integer)a.getAnimatedValue();
            this.invalidate();
        });
        this.animatorSet.playTogether(new Animator[]{this.hideSizeAnimator, this.showSizeAnimator, this.hideAlphaAnimator, this.showAlphaAnimator});
        this.animatorSet.setDuration((long)ChartView.ANIMATOR_DURATION);
        this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                PickerView.this.oldPickerDetails = PickerView.this.pickerDetails.copy();
                PickerView.this.animateDate1 = false;
                PickerView.this.animateDate2 = false;
                PickerView.this.animateValues = false;
            }
        });
    }

    public void applyTheme() {
        if (ChartView.THEME == 1) {
            this.paint.setColor(this.getResources().getColor(R.color.darkPickerLineColor));
            this.dateTextPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkPlaneTextColor));
            this.showDateTextPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkPlaneTextColor));
            this.hideDateTextPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkPlaneTextColor));
            this.platePaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkPlaneColor));
            this.nameTextPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkPlaneTextColor));
            this.platePaint.setShadowLayer(AndroidUtils.dpToPx(this.getContext(), 3.0f), 0.0f, 0.0f, ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkPlateShadowColor));
        } else {
            this.dateTextPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.planeTextColor));
            this.showDateTextPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.planeTextColor));
            this.hideDateTextPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.planeTextColor));
            this.paint.setColor(this.getResources().getColor(R.color.pickerLineColor));
            this.platePaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.planeColor));
            this.nameTextPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.planeTextColor));
            this.platePaint.setShadowLayer(AndroidUtils.dpToPx(this.getContext(), 3.0f), 0.0f, 0.0f, ContextCompat.getColor((Context)this.getContext(), (int)R.color.plateShadowColor));
        }
    }

    public void refresh() {
        if (this.picked) {
            this.drawPick(this.screenX, true);
        }
    }

    public void pick(float screenX) {
        this.drawPick(screenX, false);
    }

    private void drawPick(float screenX, boolean exec) {
        this.screenX = screenX;
        int visibleCount = ChartCore.getVisibleChartLinesCount(this.chart.getChartLines());
        if (visibleCount == 0) {
            this.picked = false;
            this.pickListener.clearPick();
            this.invalidate();
            return;
        }
        PickerDetails pickerDetails = this.getPickDetails(screenX, exec);
        this.pickListener.pick(pickerDetails);
        this.cardWidth = this.minCardWidth;
        this.cardHeight = this.dateRawHeight + (float)visibleCount * this.rawHeight + this.cardBottomPadding;
        float topHeight = this.getScreenY(pickerDetails.maxValue);
        this.x = exec ? this.getScreenX(pickerDetails.x) : this.getScreenX(this.xArray[pickerDetails.closestXPosition]);
        this.date.setTime(pickerDetails.x);
        pickerDetails.date1 = this.df1.format(this.date);
        pickerDetails.date2 = this.df2.format(this.date);
        if (topHeight >= this.cardHeight + this.cardVerticalMarginTop * 2.0f + this.topPadding) {
            this.left = this.x - this.cardWidth / 2.0f;
            this.top = this.cardVerticalMarginTop + this.topPadding;
            if (this.left + this.cardWidth > this.width) {
                this.top = this.cardVerticalMarginLeft + this.topPadding;
                this.left = this.x - this.cardWidth - this.cardHorizontalMargin;
            }
            if (this.left < 0.0f) {
                this.top = this.cardVerticalMarginLeft + this.topPadding;
                this.left = this.x + this.cardHorizontalMargin;
            }
        } else {
            this.top = this.cardVerticalMarginLeft + this.topPadding;
            float leftWidth = this.getScreenX(pickerDetails.x);
            this.left = leftWidth > this.cardWidth ? this.x - this.cardWidth - this.cardHorizontalMargin : this.x + this.cardHorizontalMargin;
        }
        if (this.left + this.cardWidth > this.width) {
            this.left = this.width - this.cardWidth;
        }
        if (this.left < 0.0f) {
            this.left = 0.0f;
        }
        this.cardRect.set(this.left, this.top, this.left + this.cardWidth, this.top + this.cardHeight);
        if (!this.picked || this.oldPickerDetails == null) {
            this.oldPickerDetails = pickerDetails.copy();
            this.invalidate();
        } else {
            this.animateValues = true;
            this.animateDate1 = !pickerDetails.date1.equals(this.oldPickerDetails.date1);
            this.animateDate2 = !pickerDetails.date2.equals(this.oldPickerDetails.date2);
            this.hideSizeAnimator.setFloatValues(new float[]{this.dateFontSize, 0.0f});
            this.showSizeAnimator.setFloatValues(new float[]{0.0f, this.dateFontSize});
            this.hideAlphaAnimator.setIntValues(new int[]{255, 0});
            this.showAlphaAnimator.setIntValues(new int[]{0, 255});
            this.animatorSet.start();
        }
        this.picked = true;
    }

    public void updateScene(Scene scene) {
        this.scene = scene;
        this.horizontalPaddingInPercent = (long)((double)(scene.getMaxX() - scene.getMinX()) * (double)this.horizontalPadding / (double)this.width);
        this.minX = scene.getMinX() - this.horizontalPaddingInPercent;
        this.maxX = scene.getMaxX() + this.horizontalPaddingInPercent;
    }

    public void clear() {
        this.picked = false;
        this.pickListener.clearPick();
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.picked) {
            canvas.drawRoundRect(this.cardRect, this.cornerRoundRadius, this.cornerRoundRadius, this.platePaint);
            this.drawDates(canvas, this.pickerDetails);
            this.idx = 0;
            for (int i = 0; i < this.chart.getChartLines().size(); ++i) {
                if (!this.chart.getChartLines().get(i).isVisible()) continue;
                canvas.drawText(this.chart.getChartLines().get(i).getName(), 0, this.chart.getChartLines().get(i).getName().length, this.left + this.cardHorizontalPadding, this.top + this.cardVerticalPadding + this.dateRawHeight + this.rawHeight * (float)this.idx, this.nameTextPaint);
                this.drawValue(canvas, i);
                ++this.idx;
            }
            this.arrow.setBounds((int)(this.left + this.cardWidth - this.arrowPaddingRight - this.arrowSize), (int)(this.top + this.arrowPaddingTop), (int)(this.left + this.cardWidth - this.arrowPaddingRight), (int)(this.top + this.arrowPaddingTop + this.arrowSize));
            this.arrow.draw(canvas);
        }
    }

    private void drawValue(Canvas canvas, int index) {
        this.valueWidth = this.valTextPaint.measureText((int)this.pickerDetails.values[index] + "");
        if (this.animateValues && this.pickerDetails.values[index] != this.oldPickerDetails.values[index]) {
            this.showValTextPaint.setColor(this.chart.getChartLines().get(index).getColor());
            this.hideValTextPaint.setColor(this.chart.getChartLines().get(index).getColor());
            this.showValTextPaint.setAlpha(this.showValueAlpha);
            this.hideValTextPaint.setAlpha(this.hideValueAlpha);
            canvas.drawText((int)this.pickerDetails.values[index] + "", this.left + this.cardWidth - this.valueWidth - this.cardHorizontalPadding, this.top + this.cardVerticalPadding + this.dateRawHeight + this.rawHeight * (float)this.idx, this.showValTextPaint);
            canvas.drawText((int)this.oldPickerDetails.values[index] + "", this.left + this.cardWidth - this.cardHorizontalPadding, this.top + this.cardVerticalPadding + this.dateRawHeight + this.rawHeight * (float)this.idx, this.hideValTextPaint);
        } else {
            this.valTextPaint.setColor(this.chart.getChartLines().get(index).getColor());
            canvas.drawText((int)this.pickerDetails.values[index] + "", this.left + this.cardWidth - this.valueWidth - this.cardHorizontalPadding, this.top + this.cardVerticalPadding + this.dateRawHeight + this.rawHeight * (float)this.idx, this.valTextPaint);
        }
    }

    private void drawDates(Canvas canvas, PickerDetails pickerDetails) {
        this.date1Width = this.dateTextPaint.measureText(pickerDetails.date1);
        this.date2Width = this.dateTextPaint.measureText(pickerDetails.date2);
        if (this.animateDate1 && this.animateDate2) {
            this.fullDate1 = pickerDetails.date1 + " " + pickerDetails.date2;
            this.fullDate2 = this.oldPickerDetails.date1 + " " + this.oldPickerDetails.date2;
            this.date1Width = this.dateTextPaint.measureText(this.fullDate1);
            canvas.drawText(this.fullDate1, this.left + this.cardHorizontalPadding, this.top + this.cardVerticalPadding + this.dateTopPadding, this.showDateTextPaint);
            canvas.drawText(this.fullDate2, this.left + this.cardHorizontalPadding + this.date1Width, this.top + this.cardVerticalPadding + this.dateTopPadding, this.hideDateTextPaint);
        } else {
            if (this.animateDate1) {
                canvas.drawText(pickerDetails.date1, this.left + this.cardHorizontalPadding, this.top + this.cardVerticalPadding + this.dateTopPadding, this.showDateTextPaint);
                canvas.drawText(this.oldPickerDetails.date1, this.left + this.cardHorizontalPadding + this.date1Width, this.top + this.cardVerticalPadding + this.dateTopPadding, this.hideDateTextPaint);
            } else {
                canvas.drawText(pickerDetails.date1, this.left + this.cardHorizontalPadding + this.date1Width, this.top + this.cardVerticalPadding + this.dateTopPadding, this.dateTextPaint);
            }
            if (this.animateDate2) {
                canvas.drawText(pickerDetails.date2, this.left + this.cardHorizontalPadding + this.date1Width + this.paddingBetweenDates, this.top + this.cardVerticalPadding + this.dateTopPadding, this.showDateTextPaint);
                canvas.drawText(this.oldPickerDetails.date2, this.left + this.cardHorizontalPadding + this.date1Width + this.paddingBetweenDates + this.date2Width, this.top + this.cardVerticalPadding + this.dateTopPadding, this.hideDateTextPaint);
            } else {
                canvas.drawText(this.df2.format(this.date), this.left + this.cardHorizontalPadding + this.date1Width + this.paddingBetweenDates + this.date2Width, this.top + this.cardVerticalPadding + this.dateTopPadding, this.dateTextPaint);
            }
        }
    }

    float getScreenX(long x) {
        return (float)(x - this.minX) / (float)(this.maxX - this.minX) * this.width;
    }

    float getScreenY(double y) {
        return (float)((double)this.height - (y - this.scene.getMinY()) / (this.scene.getMaxY() - this.scene.getMinY()) * (double)this.height) + this.topPadding;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.width = right - left;
        this.height = (float)(bottom - top) - this.topPadding;
    }

    private PickerDetails getPickDetails(float screenX, boolean exect) {
        double prcnt;
        double x = (double)this.scene.getMinX() + (double)screenX / (double)this.width * ((double)this.scene.getMaxX() - (double)this.scene.getMinX());
        long x1 = 0L;
        long x2 = 0L;
        int position1 = 0;
        int position2 = 0;
        for (int i = 0; i < this.xArray.length - 1; ++i) {
            x1 = this.xArray[i];
            x2 = this.xArray[i + 1];
            if (!(x >= (double)x1) || !(x <= (double)x2)) continue;
            position1 = i;
            position2 = i + 1;
            break;
        }
        this.pickerDetails.closestXPosition = (prcnt = (x - (double)x1) / (double)(x2 - x1)) > 0.5 ? position2 : position1;
        this.pickerDetails.maxValue = this.chart.getChartLines().get(0).getType() == 1 ? Double.MIN_VALUE : 0.0;
        if (exect) {
            this.pickerDetails.x = (long)((double)x1 + prcnt * ((double)x2 - (double)x1));
            this.pickerDetails.values = new double[this.chart.getChartLines().size()];
            for (int i = 0; i < this.chart.getChartLines().size(); ++i) {
                this.pickerDetails.values[i] = this.chart.getChartLines().get(i).getY()[position1] + (this.chart.getChartLines().get(i).getY()[position2] - this.chart.getChartLines().get(i).getY()[position1]) * prcnt;
                if (this.chart.getChartLines().get(0).getType() == 1) {
                    if (!(this.pickerDetails.maxValue < this.pickerDetails.values[i])) continue;
                    this.pickerDetails.maxValue = this.pickerDetails.values[i];
                    continue;
                }
                this.pickerDetails.maxValue += this.pickerDetails.values[i];
            }
        } else {
            this.pickerDetails.x = this.xArray[this.pickerDetails.closestXPosition];
            this.pickerDetails.values = new double[this.chart.getChartLines().size()];
            for (int i = 0; i < this.chart.getChartLines().size(); ++i) {
                this.pickerDetails.values[i] = this.chart.getChartLines().get(i).getY()[this.pickerDetails.closestXPosition];
                if (this.chart.getChartLines().get(0).getType() == 1) {
                    if (!(this.pickerDetails.maxValue < this.pickerDetails.values[i])) continue;
                    this.pickerDetails.maxValue = this.pickerDetails.values[i];
                    continue;
                }
                this.pickerDetails.maxValue += this.pickerDetails.values[i];
            }
        }
        return this.pickerDetails;
    }

    public void setTopPadding(float topPadding) {
        this.topPadding = topPadding;
    }

    public void setHorizontalPadding(int horizontalPadding) {
        this.horizontalPadding = horizontalPadding;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.gestureDetector.onTouchEvent(event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    public void setPickListener(PickListener pickListener) {
        this.pickListener = pickListener;
    }

    public static interface PickListener {
        public void pick(PickerDetails var1);

        public void clearPick();
    }
}

