/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.adi.lib.R;
import com.adi.lib.chart.BaseChartView;
import com.adi.lib.chart.ChartCore;
import com.adi.lib.chart.ChartFilter;
import com.adi.lib.chart.ChartGridAnimator;
import com.adi.lib.chart.ChartGridView;
import com.adi.lib.chart.ChartLineAnimator;
import com.adi.lib.chart.ChartLinesView;
import com.adi.lib.chart.ChartPercentageAnimator;
import com.adi.lib.chart.ChartPercentageStackedView;
import com.adi.lib.chart.ChartStackedView;
import com.adi.lib.chart.ChartTopPanel;
import com.adi.lib.chart.PickerView;
import com.adi.lib.chart.SliderView;
import com.adi.lib.chart.XAxisView;
import com.adi.lib.chart.entity.Chart;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.PickerDetails;
import com.adi.lib.chart.entity.Scene;
import com.adi.lib.utils.AndroidUtils;

public class ChartView
extends ViewGroup {
    public static final int THEME_LIGHT = 0;
    public static final int THEME_DARK = 1;
    public static int THEME = 0;
    public static int ANIMATOR_DURATION = 300;
    private int topPanelHeight;
    private int navigationPanelHeight;
    private int xAxisHeight;
    private int horizontalPadding;
    private int chartHeight;
    private int filterHeight;
    private ChartTopPanel chartTopPanel;
    private BaseChartView chartLinesView;
    private PickerView pickerView;
    private ChartGridView chartGridView;
    private XAxisView xAxisView;
    private BaseChartView navigationChartLineView;
    private SliderView sliderView;
    private ChartFilter chartFilter;
    private ChartLineAnimator chartLineAnimator = new ChartLineAnimator();
    private ChartPercentageAnimator chartPercentageAnimator = new ChartPercentageAnimator();
    private ChartLineAnimator navigationChartLineAnimator = new ChartLineAnimator();
    private ChartGridAnimator greedAnimator = new ChartGridAnimator();
    private Chart chart;
    private String title;
    Scene scene;
    Scene oldScene;
    int width;
    int height;
    boolean viewInitialized;
    ChartCore chartCore = new ChartCore();

    public ChartView(Context context) {
        super(context);
        this.init();
    }

    public ChartView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ChartView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.chartHeight = (int)AndroidUtils.dpToPx(this.getContext(), 296.0f);
        this.topPanelHeight = (int)AndroidUtils.dpToPx(this.getContext(), 70.0f);
        this.navigationPanelHeight = (int)AndroidUtils.dpToPx(this.getContext(), 48.0f);
        this.xAxisHeight = (int)AndroidUtils.dpToPx(this.getContext(), 40.0f);
        this.horizontalPadding = (int)AndroidUtils.dpToPx(this.getContext(), 18.0f);
    }

    private void createViews() {
        this.removeAllViews();
        if (this.chart.getChartLines().get(0).getType() == 1) {
            this.chartLinesView = new ChartLinesView(this.getContext(), 2, true);
            this.navigationChartLineView = new ChartLinesView(this.getContext(), 1, false);
        } else if (this.chart.getChartLines().get(0).getType() == 3) {
            this.chartLinesView = new ChartPercentageStackedView(this.getContext(), true);
            this.navigationChartLineView = new ChartPercentageStackedView(this.getContext(), false);
        } else {
            this.chartLinesView = new ChartStackedView(this.getContext(), true);
            this.navigationChartLineView = new ChartStackedView(this.getContext(), false);
        }
        this.pickerView = new PickerView(this.getContext(), this.chart);
        this.sliderView = new SliderView(this.getContext());
        this.chartGridView = new ChartGridView(this.getContext(), this.chart);
        this.xAxisView = new XAxisView(this.getContext(), this.chart);
        this.chartFilter = new ChartFilter(this.getContext(), this.chart.getChartLines());
        this.chartTopPanel = new ChartTopPanel(this.getContext(), this.chart);
        this.addView(this.xAxisView);
        this.addView(this.chartLinesView);
        this.addView(this.chartGridView);
        this.addView(this.navigationChartLineView);
        this.addView(this.sliderView);
        this.addView(this.pickerView);
        this.addView(this.chartFilter);
        this.addView(this.chartTopPanel);
        this.pickerView.setPickListener(new PickerView.PickListener(){

            @Override
            public void pick(PickerDetails pickerDetails) {
                ChartView.this.chartLinesView.pick(pickerDetails);
            }

            @Override
            public void clearPick() {
                ChartView.this.chartLinesView.clearPick();
            }
        });
        this.sliderView.setChangeListener(new SliderView.ChangeListener(){

            @Override
            public void onSliderChanged(long minX, long maxX, boolean widthChanged) {
                if (ChartView.this.oldScene == null) {
                    ChartView.this.oldScene = ChartView.this.scene.copy();
                }
                if (widthChanged && ChartCore.getVisibleChartLinesCount(ChartView.this.chart.getChartLines()) != 0) {
                    ChartView.this.chartCore.updateSceneY(ChartView.this.chart, ChartView.this.scene);
                }
                ChartView.this.chartCore.updateSceneX(ChartView.this.chart, ChartView.this.scene, minX, maxX, true);
                ChartView.this.chartLinesView.updateScene(ChartView.this.scene);
                ChartView.this.xAxisView.updateScene(ChartView.this.scene);
                ChartView.this.pickerView.updateScene(ChartView.this.scene);
                ChartView.this.pickerView.clear();
            }

            @Override
            public void onStopScroll() {
                if (ChartCore.roundDouble(ChartView.this.oldScene.getMinY()) != ChartCore.roundDouble(ChartView.this.scene.getMinY()) || ChartCore.roundDouble(ChartView.this.oldScene.getMaxY()) != ChartCore.roundDouble(ChartView.this.scene.getMaxY())) {
                    ChartView.this.greedAnimator.animate(ChartView.this.chartGridView, ChartView.this.oldScene, ChartView.this.scene, ChartView.this.chart);
                    ChartView.this.oldScene = ChartView.this.scene.copy();
                }
            }
        });
        this.chartLineAnimator.setAnimationListener(scene -> {
            if (ChartCore.getVisibleChartLinesCount(this.chart.getChartLines()) != 0) {
                this.chartCore.updateSceneY(this.chart, this.scene);
                this.chartCore.updateSceneX(this.chart, this.scene, this.scene.getMinX(), this.scene.getMaxX(), false);
            }
        });
        this.chartPercentageAnimator.setAnimationListener(scene -> {
            this.chartCore.updateSceneY(this.chart, scene);
            this.chartCore.updateSceneX(this.chart, scene, scene.getMinX(), scene.getMaxX(), false);
            this.scene = scene;
        });
        this.chartFilter.setFilterListener(new ChartFilter.FilterListener(){

            @Override
            public void hide(int position) {
                ChartView.this.hide(position);
            }

            @Override
            public void show(int position) {
                ChartView.this.show(position);
            }
        });
        this.applyTheme();
    }

    private void applyTheme() {
        if (THEME == 1) {
            this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkChartViewBackgroundColor));
        } else {
            this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.chartViewBackgroundColor));
        }
    }

    private void initializeViews() {
        this.scene = this.chartCore.initializeScene(this.chart);
        this.chartLinesView.updateChartLines(this.chart.getChartLines());
        this.navigationChartLineView.updateChartLines(this.chart.getChartLines());
        this.navigationChartLineView.updateScene(this.scene.copy());
        this.sliderView.updateChart(this.chart.getChartLines(), this.scene.copy());
        this.chartGridView.updateChartLines(this.chart);
        this.chartGridView.updateScene(this.scene, this.chart);
        this.pickerView.updateScene(this.scene);
        this.chartTopPanel.drawTitle(this.title);
        this.chartTopPanel.drawShadow();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.chart.getChartLines() != null) {
            this.chartTopPanel.layout(0, 0, this.width, this.topPanelHeight);
            this.chartLinesView.setHorizontalPadding(this.horizontalPadding);
            this.chartLinesView.setTopPadding(this.topPanelHeight);
            this.chartLinesView.layout(0, 0, this.width, this.chartHeight + this.topPanelHeight);
            this.chartGridView.setTopPadding(this.topPanelHeight);
            this.chartGridView.layout(this.horizontalPadding, 0, this.width - this.horizontalPadding, this.chartHeight + this.topPanelHeight);
            this.pickerView.setTopPadding(this.topPanelHeight);
            this.pickerView.setHorizontalPadding(this.horizontalPadding);
            this.pickerView.layout(0, 0, this.width, this.chartHeight + this.topPanelHeight);
            this.xAxisView.layout(0, this.topPanelHeight + this.chartHeight, this.width, this.topPanelHeight + this.chartHeight + this.xAxisHeight);
            this.navigationChartLineView.layout(this.horizontalPadding, this.chartHeight + this.topPanelHeight + this.xAxisHeight, this.width - this.horizontalPadding, this.chartHeight + this.topPanelHeight + this.xAxisHeight + this.navigationPanelHeight);
            this.sliderView.layout(this.horizontalPadding, this.chartHeight + this.topPanelHeight + this.xAxisHeight, this.width - this.horizontalPadding, this.chartHeight + this.topPanelHeight + this.xAxisHeight + this.navigationPanelHeight);
            this.chartFilter.layout(0, this.topPanelHeight + this.chartHeight + this.xAxisHeight + this.navigationPanelHeight, this.width, this.topPanelHeight + this.chartHeight + this.xAxisHeight + this.navigationPanelHeight + this.filterHeight);
            if (!this.viewInitialized) {
                this.initializeViews();
                this.viewInitialized = true;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.filterHeight = (int)this.chartFilter.calculate(this.width);
        this.width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.height = this.topPanelHeight + this.chartHeight + this.xAxisHeight + this.navigationPanelHeight + this.filterHeight;
        int tpWidth = View.MeasureSpec.makeMeasureSpec((int)this.width, (int)0x40000000);
        int tpHeight = View.MeasureSpec.makeMeasureSpec((int)this.topPanelHeight, (int)0x40000000);
        this.chartTopPanel.measure(tpWidth, tpHeight);
        this.setMeasuredDimension(this.width, this.height);
    }

    public void updateChart(String title, Chart chart) {
        this.chart = chart;
        this.title = title;
        this.createViews();
    }

    public void hide(int index) {
        this.pickerView.refresh();
        for (ChartLine chartLine : this.chart.getChartLines()) {
            chartLine.setAnimationInProcess(false);
        }
        if (this.chart.isPercentage()) {
            this.chartPercentageAnimator.hide(this.chartLinesView, this.navigationChartLineView, this.chart.getChartLines().get(index), true, true);
        } else {
            Scene newScene = this.chartCore.initializeScene(this.chart);
            boolean animateScale = ChartCore.getVisibleChartLinesCount(this.chart.getChartLines()) != 0;
            this.navigationChartLineAnimator.hide(this.navigationChartLineView, newScene, this.chart.getChartLines().get(index), animateScale, true);
            Scene newScene2 = this.scene.copy();
            this.chartCore.updateSceneY(this.chart, newScene2);
            this.chartCore.updateSceneX(this.chart, newScene2, this.scene.getMinX(), this.scene.getMaxX(), true);
            this.chartLineAnimator.hide(this.chartLinesView, newScene2, null, animateScale, false);
            if (ChartCore.getVisibleChartLinesCount(this.chart.getChartLines()) == 0) {
                this.greedAnimator.disappear(this.chartGridView, this.scene, this.chart);
            } else {
                this.greedAnimator.animate(this.chartGridView, this.scene, newScene2, this.chart);
            }
        }
    }

    public void show(int index) {
        this.pickerView.refresh();
        for (ChartLine chartLine : this.chart.getChartLines()) {
            chartLine.setAnimationInProcess(false);
        }
        if (this.chart.isPercentage()) {
            this.chartPercentageAnimator.show(this.chartLinesView, this.navigationChartLineView, this.chart.getChartLines().get(index), true, true);
        } else {
            Scene newScene = this.chartCore.initializeScene(this.chart);
            boolean animateScale = ChartCore.getVisibleChartLinesCount(this.chart.getChartLines()) != 1;
            this.navigationChartLineAnimator.show(this.navigationChartLineView, newScene, this.chart.getChartLines().get(index), animateScale, true);
            Scene newScene2 = this.scene.copy();
            this.chartCore.updateSceneY(this.chart, newScene2);
            this.chartCore.updateSceneX(this.chart, newScene2, this.scene.getMinX(), this.scene.getMaxX(), true);
            this.chartLineAnimator.show(this.chartLinesView, newScene2, null, animateScale, false);
            if (ChartCore.getVisibleChartLinesCount(this.chart.getChartLines()) == 1) {
                this.greedAnimator.appear(this.chartGridView, newScene2, this.chart);
            } else {
                this.greedAnimator.animate(this.chartGridView, this.scene, newScene2, this.chart);
            }
        }
    }

    public void changeTheme() {
        if (this.chart.getChartLines() != null && this.title != null) {
            this.sliderView.applyTheme();
            this.sliderView.invalidate();
            this.chartLinesView.applyTheme();
            this.chartLinesView.invalidate();
            this.chartGridView.applyTheme();
            this.chartGridView.invalidate();
            this.chartTopPanel.applyTheme();
            this.chartTopPanel.drawShadow();
            this.chartTopPanel.invalidate();
            this.xAxisView.applyTheme();
            this.xAxisView.invalidate();
            this.pickerView.applyTheme();
            this.pickerView.invalidate();
            this.applyTheme();
            this.invalidate();
        }
    }
}

