/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.support.v4.content.ContextCompat;
import android.view.View;
import com.adi.lib.R;
import com.adi.lib.chart.ChartView;
import com.adi.lib.chart.entity.Chart;
import com.adi.lib.utils.AndroidUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ChartTopPanel
extends View {
    private Paint fontPaint = new Paint(1);
    private Paint datePaint = new Paint(1);
    private Paint gradientPaint = new Paint();
    private String title;
    private float titleHeight;
    private float titleWidth;
    private float horizontalPadding;
    private float paddingTop;
    DateFormat df = new SimpleDateFormat("dd MMMM yyyy", Locale.US);
    Rect textBounds = new Rect();
    LinearGradient shader;
    int width;
    int height;
    int shaderColor;
    Chart chart;
    Date startDate;
    Date endDate;

    public ChartTopPanel(Context context, Chart chart) {
        super(context);
        this.chart = chart;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(chart.getChartLines().get(0).getX()[0]);
        this.startDate = calendar.getTime();
        calendar.setTimeInMillis(chart.getChartLines().get(0).getX()[chart.getChartLines().get(0).getX().length - 1]);
        this.endDate = calendar.getTime();
        this.init();
    }

    private void init() {
        this.setLayerType(1, null);
        this.fontPaint.setTextSize(AndroidUtils.dpToPx(this.getContext(), 18.0f));
        this.fontPaint.setStyle(Paint.Style.FILL);
        this.fontPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        this.datePaint.setTextSize(AndroidUtils.dpToPx(this.getContext(), 16.0f));
        this.datePaint.setStyle(Paint.Style.FILL);
        this.datePaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        this.datePaint.setTextAlign(Paint.Align.RIGHT);
        this.horizontalPadding = AndroidUtils.dpToPx(this.getContext(), 18.0f);
        this.paddingTop = AndroidUtils.dpToPx(this.getContext(), 20.0f);
        this.applyTheme();
    }

    public void applyTheme() {
        if (ChartView.THEME == 0) {
            this.fontPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.chartTitleColor));
            this.datePaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.chartTitleColor));
            this.shaderColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.chartViewBackgroundColor);
        } else {
            this.fontPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkChartTitleColor));
            this.datePaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkChartTitleColor));
            this.shaderColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkChartViewBackgroundColor);
        }
    }

    public void drawShadow() {
        this.shader = new LinearGradient(0.0f, 0.0f, 1.0f, (float)this.getHeight(), this.shaderColor, 0, Shader.TileMode.MIRROR);
        this.gradientPaint.setDither(true);
        this.gradientPaint.setShader((Shader)this.shader);
    }

    public void drawTitle(String title) {
        this.title = title;
        this.fontPaint.getTextBounds(title, 0, title.length(), this.textBounds);
        this.titleHeight = this.textBounds.height();
        this.titleWidth = this.textBounds.width();
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.title != null) {
            canvas.drawText(this.title, this.horizontalPadding, this.paddingTop + this.titleHeight, this.fontPaint);
        }
        if (this.chart != null) {
            canvas.drawText(this.df.format(this.startDate) + " - " + this.df.format(this.endDate), (float)this.width - this.horizontalPadding, this.paddingTop + this.titleHeight, this.datePaint);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

