/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.adi.lib.chart.BaseChartView;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.PickerDetails;
import com.adi.lib.chart.entity.Scene;
import com.adi.lib.utils.AndroidUtils;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class ChartStackedView
extends BaseChartView {
    private Paint paint = new Paint();
    private float[][] points;
    float minY;
    double lastPosition;

    public ChartStackedView(Context context, boolean chartMode) {
        super(context, chartMode);
        this.init();
    }

    private void init() {
        this.paint.setStrokeWidth(AndroidUtils.dpToPx(this.getContext(), 1.0f));
        this.paint.setStyle(Paint.Style.FILL);
    }

    @Override
    void updateChartLines(List<ChartLine> chartLines) {
        super.updateChartLines(chartLines);
    }

    @Override
    void updateScene(Scene newScene) {
        super.updateScene(newScene);
        this.minY = this.height + this.topPadding;
        this.points = new float[this.chartLines.size()][this.xArray.length * 4];
        this.calculatePoints();
        this.postInvalidate(0, 0, (int)this.width, (int)this.height);
    }

    @Override
    void animateChart(float maxY, float minY) {
        this.scene.setMaxY(maxY);
    }

    @Override
    public void animateChartPercent(float percent) {
        super.animateChartPercent(percent);
        this.calculatePointsForAnimation(percent);
        this.postInvalidate(0, 0, (int)this.width, (int)this.height);
    }

    private void calculatePoints() {
        this.i = this.start;
        while (this.i <= this.stop) {
            this.lastPosition = 0.0;
            for (int k = 0; k < this.chartLines.size(); ++k) {
                if (!((ChartLine)this.chartLines.get(k)).isVisible()) continue;
                this.points[k][(this.i - this.start) * 4 + 3] = this.getScreenY(this.lastPosition);
                this.lastPosition += ((ChartLine)this.chartLines.get(k)).getY()[this.i];
                this.points[k][(this.i - this.start) * 4 + 1] = this.getScreenY(this.lastPosition);
                this.points[k][(this.i - this.start) * 4] = this.getScreenX(this.xArray[this.i]);
                this.points[k][(this.i - this.start) * 4 + 2] = this.getScreenX(this.xArray[this.i]);
            }
            ++this.i;
        }
    }

    private void calculatePointsForAnimation(float percent) {
        this.i = this.start;
        while (this.i <= this.stop) {
            this.lastPosition = 0.0;
            for (int k = 0; k < this.chartLines.size(); ++k) {
                if (((ChartLine)this.chartLines.get(k)).isAnimationInProcess()) {
                    this.points[k][(this.i - this.start) * 4 + 3] = this.getScreenY(this.lastPosition);
                    this.lastPosition += ((ChartLine)this.chartLines.get(k)).getY()[this.i] * (double)percent;
                    this.points[k][(this.i - this.start) * 4 + 1] = this.getScreenY(this.lastPosition);
                    this.points[k][(this.i - this.start) * 4] = this.getScreenX(this.xArray[this.i]);
                    this.points[k][(this.i - this.start) * 4 + 2] = this.getScreenX(this.xArray[this.i]);
                    continue;
                }
                if (!((ChartLine)this.chartLines.get(k)).isVisible()) continue;
                this.points[k][(this.i - this.start) * 4 + 3] = this.getScreenY(this.lastPosition);
                this.lastPosition += ((ChartLine)this.chartLines.get(k)).getY()[this.i];
                this.points[k][(this.i - this.start) * 4 + 1] = this.getScreenY(this.lastPosition);
            }
            ++this.i;
        }
    }

    @Override
    protected void calculateStartAndStopX() {
        super.calculateStartAndStopX();
        int count = (int)((float)this.horizontalPadding / this.gapInPixel);
        this.start -= count;
        if (this.start < 0) {
            this.start = 0;
        }
        if (this.stop != this.xArray.length - 1) {
            ++this.stop;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.chartLines != null && this.scene != null && this.scene.getMaximums() != null) {
            this.paint.setStrokeWidth(this.gapInPixel);
            for (int i = 0; i < this.chartLines.size(); ++i) {
                this.paint.setColor(((ChartLine)this.chartLines.get(i)).getColor());
                if (this.animationInProcess) {
                    this.paint.setAlpha(((ChartLine)this.chartLines.get(i)).getAlpha());
                    this.drawChart(canvas, i);
                    continue;
                }
                this.paint.setAlpha(255);
                if (!((ChartLine)this.chartLines.get(i)).isVisible()) continue;
                this.drawChart(canvas, i);
            }
        }
    }

    @Override
    public void pick(PickerDetails pickerDetails) {
        super.pick(pickerDetails);
        this.invalidate();
    }

    private void drawChart(Canvas canvas, int index) {
        if (!this.picked) {
            canvas.drawLines(this.points[index], this.paint);
        } else {
            this.paint.setAlpha(180);
            canvas.drawLines(this.points[index], this.paint);
            this.paint.setAlpha(255);
            canvas.drawLine(this.points[index][(this.pickerDetails.closestXPosition - this.start) * 4], this.points[index][(this.pickerDetails.closestXPosition - this.start) * 4 + 1], this.points[index][(this.pickerDetails.closestXPosition - this.start) * 4 + 2], this.points[index][(this.pickerDetails.closestXPosition - this.start) * 4 + 3], this.paint);
        }
    }
}

