/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.os.Handler;
import android.os.Looper;
import android.view.animation.DecelerateInterpolator;
import com.adi.lib.chart.BaseChartView;
import com.adi.lib.chart.ChartLineAnimator;
import com.adi.lib.chart.ChartView;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.Scene;

public class ChartPercentageAnimator {
    private AnimatorSet animatorSet = new AnimatorSet();
    private ValueAnimator scaleAnimator = new ValueAnimator();
    private ValueAnimator alphaAnimator = new ValueAnimator();
    private Scene scene;
    private ChartLine animationChartLine;
    private ChartLineAnimator.AnimationListener animationListener;
    private BaseChartView chartLinesView;
    private BaseChartView navigationChartLineView;
    private boolean animateAlpha;

    ChartPercentageAnimator() {
        this.alphaAnimator.addUpdateListener(a -> {
            if (this.animateAlpha) {
                this.animationChartLine.setAlpha((Integer)a.getAnimatedValue());
            }
        });
        this.scaleAnimator.addUpdateListener(a -> {
            this.chartLinesView.animateChart(((Float)a.getAnimatedValue()).floatValue(), 0.0f);
            this.navigationChartLineView.animateChart(((Float)a.getAnimatedValue()).floatValue(), 0.0f);
        });
        this.alphaAnimator.setDuration((long)ChartView.ANIMATOR_DURATION);
        this.scaleAnimator.setDuration((long)ChartView.ANIMATOR_DURATION);
        this.animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animatorSet.playTogether(new Animator[]{this.scaleAnimator, this.alphaAnimator});
        this.animatorSet.removeAllListeners();
        this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    ChartPercentageAnimator.this.chartLinesView.setAnimationInProcess(false);
                    if (ChartPercentageAnimator.this.animationChartLine != null) {
                        ChartPercentageAnimator.this.animationChartLine.setAnimationInProcess(false);
                    }
                    if (ChartPercentageAnimator.this.animationListener != null) {
                        ChartPercentageAnimator.this.animationListener.onAnimationEnd(ChartPercentageAnimator.this.scene);
                    }
                }, 100L);
            }
        });
    }

    void hide(BaseChartView chartLinesView, BaseChartView navigationChartLineView, ChartLine animationChartLine, boolean animateScale, boolean animateAlpha) {
        this.animatorSet.cancel();
        this.animateAlpha = animateAlpha;
        this.scene = chartLinesView.getScene();
        this.animationChartLine = animationChartLine;
        this.chartLinesView = chartLinesView;
        this.navigationChartLineView = navigationChartLineView;
        chartLinesView.setAnimationInProcess(true);
        if (animationChartLine != null) {
            animationChartLine.setAnimationInProcess(true);
        }
        if (animateScale) {
            this.initAnimation(1.0f, 0.0f, 255, 0);
        } else {
            this.initAnimation(1.0f, 0.0f, 255, 0);
        }
    }

    void show(BaseChartView chartLinesView, BaseChartView navigationChartLineView, ChartLine animationChartLine, boolean animateScale, boolean animateAlpha) {
        this.animatorSet.cancel();
        this.animateAlpha = animateAlpha;
        this.scene = chartLinesView.getScene();
        this.animationChartLine = animationChartLine;
        this.chartLinesView = chartLinesView;
        this.navigationChartLineView = navigationChartLineView;
        chartLinesView.setAnimationInProcess(true);
        if (animationChartLine != null) {
            animationChartLine.setAnimationInProcess(true);
        }
        if (animateScale) {
            this.initAnimation(0.0f, 1.0f, 0, 255);
        } else {
            this.initAnimation(0.0f, 1.0f, 0, 255);
        }
    }

    private void initAnimation(float scaleStart, float scaleStop, int alphaStart, int alphaStop) {
        this.alphaAnimator.setIntValues(new int[]{alphaStart, alphaStop});
        this.scaleAnimator.setFloatValues(new float[]{scaleStart, scaleStop});
        this.animatorSet.start();
    }

    void setAnimationListener(ChartLineAnimator.AnimationListener animationListener) {
        this.animationListener = animationListener;
    }

    public static interface AnimationListener {
        public void onAnimationEnd(Scene var1);
    }
}

