/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.DecelerateInterpolator;
import com.adi.lib.chart.BaseChartView;
import com.adi.lib.chart.ChartView;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.Scene;

class ChartLineAnimator {
    private AnimatorSet animatorSet = new AnimatorSet();
    private ValueAnimator maxYAnimator = new ValueAnimator();
    private ValueAnimator minYAnimator = new ValueAnimator();
    private ValueAnimator alphaAnimator = new ValueAnimator();
    private ValueAnimator percentAnimator = new ValueAnimator();
    private Scene scene;
    private ChartLine animationChartLine;
    private AnimationListener animationListener;
    private BaseChartView chartLinesView;
    private boolean animateAlpha;
    float minY;

    ChartLineAnimator() {
        this.alphaAnimator.addUpdateListener(a -> {
            if (this.animateAlpha) {
                this.animationChartLine.setAlpha((Integer)a.getAnimatedValue());
            }
        });
        this.maxYAnimator.addUpdateListener(a -> this.chartLinesView.animateChart(((Float)a.getAnimatedValue()).floatValue(), this.minY));
        this.minYAnimator.addUpdateListener(a -> {
            this.minY = ((Float)a.getAnimatedValue()).floatValue();
        });
        this.percentAnimator.addUpdateListener(a -> this.chartLinesView.animateChartPercent(((Float)a.getAnimatedValue()).floatValue()));
        this.animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animatorSet.playTogether(new Animator[]{this.maxYAnimator, this.minYAnimator, this.alphaAnimator, this.percentAnimator});
        this.animatorSet.removeAllListeners();
        this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                ChartLineAnimator.this.chartLinesView.setAnimationInProcess(false);
                if (ChartLineAnimator.this.animationChartLine != null) {
                    ChartLineAnimator.this.animationChartLine.setAnimationInProcess(false);
                }
                if (ChartLineAnimator.this.animationListener != null) {
                    ChartLineAnimator.this.animationListener.onAnimationEnd(ChartLineAnimator.this.scene);
                }
            }
        });
        this.animatorSet.setDuration((long)ChartView.ANIMATOR_DURATION);
    }

    void hide(BaseChartView chartLinesView, Scene newScene, ChartLine animationChartLine, boolean animateScale, boolean animateAlpha) {
        this.animatorSet.cancel();
        this.animateAlpha = animateAlpha;
        this.scene = chartLinesView.getScene();
        this.animationChartLine = animationChartLine;
        this.chartLinesView = chartLinesView;
        chartLinesView.setAnimationInProcess(true);
        if (animationChartLine != null) {
            animationChartLine.setAnimationInProcess(true);
        }
        if (animateScale) {
            this.initAnimation(this.scene, newScene, 255, 0, 1.0f, 0.0f);
        } else {
            this.initAnimation(this.scene, this.scene, 255, 0, 1.0f, 0.0f);
        }
    }

    void show(BaseChartView chartLinesView, Scene newScene, ChartLine animationChartLine, boolean animateScale, boolean animateAlpha) {
        this.animatorSet.cancel();
        this.animateAlpha = animateAlpha;
        this.scene = chartLinesView.getScene();
        this.animationChartLine = animationChartLine;
        this.chartLinesView = chartLinesView;
        chartLinesView.setAnimationInProcess(true);
        if (animationChartLine != null) {
            animationChartLine.setAnimationInProcess(true);
        }
        if (animateScale) {
            this.initAnimation(this.scene, newScene, 0, 255, 0.0f, 1.0f);
        } else {
            this.initAnimation(this.scene, this.scene, 0, 255, 0.0f, 1.0f);
        }
    }

    private void initAnimation(Scene oldScene, Scene newScene, int alphaStart, int alphaStop, float prcntStart, float prcntStop) {
        this.alphaAnimator.setIntValues(new int[]{alphaStart, alphaStop});
        this.maxYAnimator.setFloatValues(new float[]{(float)oldScene.getMaxY(), (float)newScene.getMaxY()});
        this.minYAnimator.setFloatValues(new float[]{(float)oldScene.getMinY(), (float)newScene.getMinY()});
        this.minY = (float)oldScene.getMinY();
        this.percentAnimator.setFloatValues(new float[]{prcntStart, prcntStop});
        this.animatorSet.start();
    }

    void setAnimationListener(AnimationListener animationListener) {
        this.animationListener = animationListener;
    }

    public static interface AnimationListener {
        public void onAnimationEnd(Scene var1);
    }
}

