/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v4.content.ContextCompat;
import android.view.View;
import com.adi.lib.R;
import com.adi.lib.chart.ChartCore;
import com.adi.lib.chart.ChartView;
import com.adi.lib.chart.entity.Chart;
import com.adi.lib.chart.entity.GridState;
import com.adi.lib.chart.entity.Scene;
import com.adi.lib.utils.AndroidUtils;

@SuppressLint(value={"ViewConstructor"})
public class ChartGridView
extends View {
    Paint paint = new Paint();
    Paint fontPaint = new Paint();
    Paint scaledFontPaint = new Paint();
    Paint bottomLinePaint = new Paint();
    Chart chart;
    Scene scene;
    int numberBottomPadding;
    float scaledTextRightPadding;
    private int height;
    Rect textBounds = new Rect();
    float topPadding = 0.0f;
    float linePadding;
    float lineStep;
    float gridScaleCoef;
    float fontAlpha;
    int[] gridNumbers;
    GridState grid1;
    GridState grid2;
    GridState scaledGrid1;
    GridState scaledGrid2;

    public ChartGridView(Context context, Chart chart) {
        super(context);
        this.chart = chart;
        this.init();
    }

    private void init() {
        this.paint.setStrokeWidth(AndroidUtils.dpToPx(this.getContext(), 1.0f));
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.bottomLinePaint.setStrokeWidth(AndroidUtils.dpToPx(this.getContext(), 1.0f));
        this.bottomLinePaint.setAntiAlias(true);
        this.bottomLinePaint.setStyle(Paint.Style.STROKE);
        this.fontPaint.setAntiAlias(true);
        this.fontPaint.setTextSize(AndroidUtils.dpToPx(this.getContext(), 12.0f));
        this.fontPaint.setStyle(Paint.Style.FILL);
        this.scaledFontPaint.setAntiAlias(true);
        this.scaledFontPaint.setTextSize(AndroidUtils.dpToPx(this.getContext(), 12.0f));
        this.scaledFontPaint.setStyle(Paint.Style.FILL);
        this.scaledFontPaint.setTextAlign(Paint.Align.RIGHT);
        this.numberBottomPadding = (int)AndroidUtils.dpToPx(this.getContext(), 7.0f);
        this.scaledTextRightPadding = (int)AndroidUtils.dpToPx(this.getContext(), 0.0f);
        this.applyTheme();
        this.fontPaint.getTextBounds("1", 0, 1, this.textBounds);
        this.linePadding = AndroidUtils.dpToPx(this.getContext(), 28.0f);
    }

    public void applyTheme() {
        if (ChartView.THEME == 0) {
            this.paint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.gridHorizontalLine));
            this.bottomLinePaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.gridHorizontalLineDark));
            if (this.chart.getChartLines().get(0).getType() == 1) {
                this.fontPaint.setColor(this.getResources().getColor(R.color.lineYText));
                this.fontAlpha = 1.0f;
            } else {
                this.fontPaint.setColor(this.getResources().getColor(R.color.barYText));
                this.fontAlpha = 0.5f;
            }
        } else {
            this.paint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkGridHorizontalLine));
            this.bottomLinePaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.darkGridHorizontalLineDark));
            if (this.chart.getChartLines().get(0).getType() == 1) {
                this.fontPaint.setColor(this.getResources().getColor(R.color.darkLineYText));
                this.fontAlpha = 0.6f;
            } else {
                this.fontPaint.setColor(this.getResources().getColor(R.color.darkBarYText));
                this.fontAlpha = 0.5f;
            }
        }
    }

    public void updateChartLines(Chart chart) {
        this.chart = chart;
    }

    public void updateScene(Scene newScene, Chart chart) {
        this.scene = newScene;
        if (chart.isyScaled()) {
            if (chart.getChartLines().get(this.scene.getNotScaledYIndex()).isVisible()) {
                if (this.grid1 == null) {
                    this.grid1 = new GridState();
                }
                this.grid1.set(this.scene.getMinY(), this.scene.getMaxY(), 255, 1.0f, false, chart.getChartLines().get(this.scene.getNotScaledYIndex()).getColor());
            } else {
                this.grid1 = null;
            }
            if (chart.getChartLines().get(this.scene.getScaledYIndex()).isVisible()) {
                if (this.scaledGrid1 == null) {
                    this.scaledGrid1 = new GridState();
                }
                this.scaledGrid1.set(this.scene.getMinY(), this.scene.getMaxY(), 255, 1.0f, true, chart.getChartLines().get(this.scene.getScaledYIndex()).getColor());
            } else {
                this.scaledGrid1 = null;
            }
        } else {
            if (this.grid1 == null) {
                this.grid1 = new GridState();
            }
            this.grid1.set(this.scene.getMinY(), this.scene.getMaxY(), 255, 1.0f, false);
            this.grid1.greedCenter = 1.0f;
        }
        this.invalidate();
    }

    public void update(GridState grid1, GridState grid2, GridState scaledGrid1, GridState scaledGrid2) {
        this.grid1 = grid1;
        this.grid2 = grid2;
        this.scaledGrid1 = scaledGrid1;
        this.scaledGrid2 = scaledGrid2;
        this.invalidate();
    }

    public void update(GridState sourceGrid, GridState targetGrid) {
        this.grid1 = sourceGrid;
        this.grid2 = targetGrid;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        this.gridScaleCoef = this.chart.isPercentage() ? 4.0f : 5.6f;
        if (this.grid1 != null) {
            this.drawGrid(canvas, this.grid1);
        }
        if (this.grid2 != null) {
            this.drawGrid(canvas, this.grid2);
        }
        if (this.scaledGrid1 != null) {
            this.drawGrid(canvas, this.scaledGrid1);
        }
        if (this.scaledGrid2 != null) {
            this.drawGrid(canvas, this.scaledGrid2);
        }
    }

    private void drawGrid(Canvas canvas, GridState grid) {
        int i;
        if (grid.color != -1) {
            this.fontPaint.setColor(grid.color);
            this.fontPaint.setAlpha(grid.alpha);
            if (grid.scaled) {
                this.scaledFontPaint.setColor(grid.color);
                this.scaledFontPaint.setAlpha(grid.alpha);
            }
        } else {
            this.fontPaint.setAlpha((int)((float)grid.alpha * this.fontAlpha));
        }
        this.gridNumbers = grid.scaled ? ChartCore.getGridNumbers(grid.minY / (double)this.scene.getyScaleFactor(), grid.maxY / (double)this.scene.getyScaleFactor(), this.gridScaleCoef) : ChartCore.getGridNumbers(grid.minY, grid.maxY, this.gridScaleCoef);
        this.paint.setAlpha((int)((float)grid.alpha * 0.1f));
        this.lineStep = (float)((grid.maxY - grid.minY) / (double)this.gridScaleCoef);
        double topScalePadding = 0.0;
        topScalePadding = grid.greedCenter == 0.0f ? (double)(((float)this.height * grid.scaleFactor - (float)this.height) / 2.0f) : (grid.greedCenter == -1.0f ? (double)((float)this.height * grid.scaleFactor - (float)this.height) : 0.0);
        if (!grid.scaled || !this.chart.getChartLines().get(this.scene.getNotScaledYIndex()).isVisible()) {
            for (i = 0; i < (int)this.gridScaleCoef + 1; ++i) {
                canvas.drawLine(0.0f, (float)((double)this.getScreenY(this.lineStep * (float)i, grid) + topScalePadding), (float)this.getWidth(), (float)((double)this.getScreenY(this.lineStep * (float)i, grid) + topScalePadding), this.paint);
            }
        }
        if (!grid.scaled) {
            for (i = 0; i < (int)this.gridScaleCoef + 1; ++i) {
                canvas.drawText(ChartCore.numberToString(this.gridNumbers[i]), 0.0f, (float)((double)this.getScreenY(this.lineStep * (float)i, grid) + topScalePadding) - (float)this.numberBottomPadding, this.fontPaint);
            }
        } else {
            for (i = 0; i < (int)this.gridScaleCoef + 1; ++i) {
                canvas.drawText(ChartCore.numberToString(this.gridNumbers[i]) + "", (float)this.getWidth() - this.scaledTextRightPadding, (float)((double)this.getScreenY(this.lineStep * (float)i, grid) + topScalePadding) - (float)this.numberBottomPadding, this.scaledFontPaint);
            }
        }
    }

    private float getScreenY(double y, GridState grid) {
        return (float)((double)this.height - y / (grid.maxY - grid.minY) * (double)grid.scaleFactor * (double)this.height) + this.topPadding;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.height = (int)((float)(bottom - top) - this.topPadding);
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setTopPadding(float topPadding) {
        this.topPadding = topPadding;
    }
}

