/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.adi.lib.R;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.utils.AndroidUtils;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class ChartFilter
extends View {
    float iconSize;
    float textPaddingTop;
    float checkHorizontalPadding;
    float textPaddingLeft;
    float textPaddingRight;
    float cornerRadius;
    float fontHeight;
    float paddingBetweenChecks;
    float rawSpaceWidth;
    float viewPadding;
    float clearBorder;
    float checkHeight;
    List<ChartLine> chartLines;
    RectF rectF = new RectF();
    Drawable icon;
    Rect textBounds = new Rect();
    RectF[] checkRects;
    float[] checkTextWidths;
    float[] checkTextHeights;
    float xPosition;
    int currentRawNumber;
    float lastXPosition;
    Paint paint = new Paint(1);
    Paint clear = new Paint(1);
    Paint fontPaint = new Paint(1);
    private FilterListener filterListener;
    GestureDetector gestureDetector;

    public ChartFilter(Context context, List<ChartLine> chartLines) {
        super(context);
        this.setLayerType(1, null);
        this.icon = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_check_white_24dp);
        this.clear.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.paint.setStrokeWidth(AndroidUtils.dpToPx(this.getContext(), 1.0f));
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStyle(Paint.Style.FILL);
        this.cornerRadius = AndroidUtils.dpToPx(this.getContext(), 20.0f);
        this.fontHeight = AndroidUtils.dpToPx(this.getContext(), 16.0f);
        this.fontPaint.setTextSize(this.fontHeight);
        this.fontPaint.setStyle(Paint.Style.FILL);
        this.fontPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)0));
        this.textPaddingTop = (int)AndroidUtils.dpToPx(this.getContext(), 1.0f);
        this.iconSize = (int)AndroidUtils.dpToPx(this.getContext(), 20.0f);
        this.checkHeight = (int)AndroidUtils.dpToPx(this.getContext(), 41.0f);
        this.checkHorizontalPadding = (int)AndroidUtils.dpToPx(this.getContext(), 11.0f);
        this.textPaddingLeft = (int)AndroidUtils.dpToPx(this.getContext(), 4.0f);
        this.textPaddingRight = (int)AndroidUtils.dpToPx(this.getContext(), 8.0f);
        this.paddingBetweenChecks = (int)AndroidUtils.dpToPx(this.getContext(), 6.0f);
        this.viewPadding = AndroidUtils.dpToPx(this.getContext(), 18.0f);
        this.clearBorder = AndroidUtils.dpToPx(this.getContext(), 2.0f);
        this.chartLines = chartLines;
        this.gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent e) {
                ChartFilter.this.click(e.getX(), e.getY());
                return true;
            }
        });
    }

    private void click(float x, float y) {
        for (int i = 0; i < this.checkRects.length; ++i) {
            if (!this.checkRects[i].contains(x, y)) continue;
            if (this.chartLines.get(i).isVisible()) {
                this.chartLines.get(i).setVisible(false);
                this.filterListener.hide(i);
                break;
            }
            this.chartLines.get(i).setVisible(true);
            this.filterListener.show(i);
            break;
        }
        this.invalidate();
    }

    public float calculate(float width) {
        this.rawSpaceWidth = width - this.viewPadding * 2.0f;
        this.checkTextWidths = new float[this.chartLines.size()];
        this.checkTextHeights = new float[this.chartLines.size()];
        this.checkRects = new RectF[this.chartLines.size()];
        this.currentRawNumber = 0;
        this.lastXPosition = this.viewPadding;
        for (int i = 0; i < this.chartLines.size(); ++i) {
            this.checkRects[i] = new RectF();
            this.fontPaint.getTextBounds(this.chartLines.get(i).getName(), 0, this.chartLines.get(i).getName().length, this.textBounds);
            this.checkTextWidths[i] = this.textBounds.width();
            this.checkTextHeights[i] = this.textBounds.height();
            this.xPosition = i == 0 ? this.lastXPosition : this.lastXPosition + this.paddingBetweenChecks;
            if (this.xPosition + this.getFullCheckWidth(this.textBounds.width()) > this.viewPadding + this.rawSpaceWidth) {
                ++this.currentRawNumber;
                this.xPosition = this.viewPadding;
            }
            this.lastXPosition = this.xPosition + this.getFullCheckWidth(this.textBounds.width());
            this.checkRects[i].left = this.xPosition;
            this.checkRects[i].right = this.checkRects[i].left + this.getFullCheckWidth(this.textBounds.width());
            this.checkRects[i].top = (float)this.currentRawNumber * this.checkHeight + (float)this.currentRawNumber * this.paddingBetweenChecks + this.viewPadding;
            this.checkRects[i].bottom = this.checkRects[i].top + this.checkHeight;
        }
        return this.viewPadding * 2.0f + (float)this.currentRawNumber * this.checkHeight + this.checkHeight + (float)this.currentRawNumber * this.paddingBetweenChecks;
    }

    protected void onDraw(Canvas canvas) {
        for (int i = 0; i < this.chartLines.size(); ++i) {
            this.drawCheck(canvas, this.chartLines.get(i), this.checkRects[i], i, this.chartLines.get(i).isVisible());
        }
    }

    private void drawCheck(Canvas canvas, ChartLine chartLine, RectF checkRect, int index, boolean checked) {
        this.paint.setColor(chartLine.getColor());
        canvas.drawRoundRect(checkRect, this.cornerRadius, this.cornerRadius, this.paint);
        if (!checked) {
            this.fontPaint.setColor(chartLine.getColor());
            this.rectF.set(checkRect.left + this.clearBorder, checkRect.top + this.clearBorder, checkRect.right - this.clearBorder, checkRect.bottom - this.clearBorder);
            canvas.drawRoundRect(this.rectF, this.cornerRadius, this.cornerRadius, this.clear);
            canvas.drawText(chartLine.getName(), 0, chartLine.getName().length, checkRect.left + (checkRect.right - checkRect.left - this.checkTextWidths[index]) / 2.0f, checkRect.top + (this.checkHeight - this.checkTextHeights[index]) / 2.0f + this.checkTextHeights[index] - this.textPaddingTop, this.fontPaint);
        } else {
            this.fontPaint.setColor(-1);
            this.icon.setBounds((int)checkRect.left + (int)this.checkHorizontalPadding, (int)checkRect.top + (int)((this.checkHeight - this.iconSize) / 2.0f), (int)checkRect.left + (int)this.iconSize + (int)this.checkHorizontalPadding, (int)checkRect.top + (int)this.iconSize + (int)((this.checkHeight - this.iconSize) / 2.0f));
            this.icon.draw(canvas);
            canvas.drawText(chartLine.getName(), 0, chartLine.getName().length, checkRect.left + (this.checkHorizontalPadding + this.iconSize + this.textPaddingLeft), checkRect.top + (this.checkHeight - this.checkTextHeights[index]) / 2.0f + this.checkTextHeights[index] - this.textPaddingTop, this.fontPaint);
        }
    }

    private float getFullCheckWidth(float textWidth) {
        return this.checkHorizontalPadding * 2.0f + this.iconSize + this.textPaddingLeft + this.textPaddingRight + textWidth;
    }

    public void setFilterListener(FilterListener filterListener) {
        this.filterListener = filterListener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.getParent().getParent().getParent().getParent().requestDisallowInterceptTouchEvent(true);
        if (this.gestureDetector.onTouchEvent(event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    public static interface FilterListener {
        public void hide(int var1);

        public void show(int var1);
    }
}

