/*
 * Decompiled with CFR 0.152.
 */
package com.adb.rxsensor;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.adb.rxsensor.CompassHelper;
import com.adb.rxsensor.FilterSensor;

class MagneticsAcceptListener
implements SensorEventListener {
    private static final String TAG = "MagneticsAcceptListener";
    final CompassHelper mHelper;
    private float[] b = new float[3];
    private float[] c = new float[3];
    private float[] geomagnetic = new float[3];
    private float[] gravity = new float[3];
    private float[] rotation = new float[16];
    private float[] orientation = new float[3];

    MagneticsAcceptListener(CompassHelper compassHelperVar) {
        this.mHelper = compassHelperVar;
    }

    public void onAccuracyChanged(Sensor sensor, int i) {
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        float toDegrees;
        switch (sensorEvent.sensor.getType()) {
            case 1: {
                this.gravity = FilterSensor.a(this.c, sensorEvent.values, this.gravity, 0.1f);
                break;
            }
            case 2: {
                this.geomagnetic = FilterSensor.a(this.b, sensorEvent.values, this.geomagnetic, 0.1f);
            }
        }
        SensorManager.getRotationMatrix((float[])this.rotation, null, (float[])this.gravity, (float[])this.geomagnetic);
        SensorManager.getOrientation((float[])this.rotation, (float[])this.orientation);
        for (toDegrees = (float)Math.toDegrees(this.orientation[0]); toDegrees < 0.0f; toDegrees += 360.0f) {
        }
        while (toDegrees >= 360.0f) {
            toDegrees -= 360.0f;
        }
        if (this.mHelper.threeSensorPresent) {
            this.mHelper.b(toDegrees);
        } else {
            this.mHelper.notifyValue(toDegrees);
        }
    }
}

