/*
 * Decompiled with CFR 0.152.
 */
package com.adb.rxsensor;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.view.Display;
import com.adb.rxsensor.MagneticsAcceptListener;
import com.adb.rxsensor.RotationVectorListener;
import com.adb.rxsensor.SensorUpdateCallback;
import java.util.ArrayList;
import java.util.Iterator;

public class CompassHelper {
    boolean threeSensorPresent = false;
    private ArrayList<SensorUpdateCallback> callbackList = new ArrayList();
    private boolean isAllSensorReg = false;
    private boolean isStarted = false;
    public float e = 0.0f;
    private long f = Long.MAX_VALUE;
    private Context mContext;
    private Display mDisplay;
    private SensorEventListener magnaticAccelListener = new MagneticsAcceptListener(this);
    private SensorEventListener rotationVectorListener = new RotationVectorListener(this);
    private int displayRotation = 0;

    public CompassHelper(Context context, Display display) {
        this.mContext = context;
        this.mDisplay = display;
    }

    public int getRotation() {
        switch (this.mDisplay.getRotation()) {
            case 1: {
                this.displayRotation = 90;
                break;
            }
            case 2: {
                this.displayRotation = 180;
                break;
            }
            case 3: {
                this.displayRotation = 270;
                break;
            }
            default: {
                this.displayRotation = 0;
            }
        }
        return this.displayRotation;
    }

    public void notifyValue(float f) {
        Iterator<SensorUpdateCallback> it = this.callbackList.iterator();
        while (it.hasNext()) {
            it.next().onBearingValue(f);
        }
    }

    public void b(float f) {
        float abs = Math.abs(f - this.e);
        while (abs > 180.0f) {
            abs = Math.abs(abs - 360.0f);
        }
        if (abs < 145.0f) {
            this.f = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.f > 800L) {
            this.unregisterSensorListener();
            this.registerSensorListener();
        }
    }

    private void registerSensorListener() {
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        if (sensorManager != null) {
            Sensor sensorMagneticField = sensorManager.getDefaultSensor(2);
            Sensor sensorAccelerometer = sensorManager.getDefaultSensor(1);
            Sensor sensorRotationVector = sensorManager.getDefaultSensor(11);
            this.threeSensorPresent = false;
            if (sensorRotationVector != null) {
                this.threeSensorPresent = true;
            } else {
                if (sensorAccelerometer == null) {
                    return;
                }
                if (sensorMagneticField == null) {
                    return;
                }
            }
            if (this.threeSensorPresent) {
                sensorManager.registerListener(this.rotationVectorListener, sensorRotationVector, 33000);
                sensorManager.registerListener(this.magnaticAccelListener, sensorMagneticField, 3);
                sensorManager.registerListener(this.magnaticAccelListener, sensorAccelerometer, 3);
            } else {
                sensorManager.registerListener(this.magnaticAccelListener, sensorMagneticField, 2);
                sensorManager.registerListener(this.magnaticAccelListener, sensorAccelerometer, 2);
            }
            this.isAllSensorReg = true;
        }
    }

    private void unregisterSensorListener() {
        if (this.isAllSensorReg) {
            SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
            sensorManager.unregisterListener(this.magnaticAccelListener, sensorManager.getDefaultSensor(2));
            sensorManager.unregisterListener(this.magnaticAccelListener, sensorManager.getDefaultSensor(1));
            sensorManager.unregisterListener(this.rotationVectorListener, sensorManager.getDefaultSensor(11));
            this.f = Long.MAX_VALUE;
            this.isAllSensorReg = false;
        }
    }

    public void registerAndStartListen(SensorUpdateCallback sensorUpdateCallbackVar) {
        this.callbackList.add(sensorUpdateCallbackVar);
        if (!this.isStarted && !this.isAllSensorReg) {
            this.registerSensorListener();
            this.isStarted = true;
        }
    }

    public void stopListen() {
        if (this.isAllSensorReg) {
            this.unregisterSensorListener();
            if (this.callbackList.size() > 0) {
                this.callbackList.clear();
            }
            this.isStarted = false;
        }
    }
}

