/*
 * Decompiled with CFR 0.152.
 */
package com.adaptr.android.playersdk;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import com.adaptr.android.playersdk.ADLog;
import com.adaptr.android.playersdk.StationDownloadListener;
import com.adaptr.android.playersdk.models.AudioFile;
import com.adaptr.android.playersdk.models.Play;
import com.adaptr.android.playersdk.models.Station;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 02\u00020\u0001:\u000201B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u001f\u001a\u00020\u001e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0005H\u0002J\b\u0010'\u001a\u00020\u001eH\u0002J\b\u0010(\u001a\u00020\u0005H\u0002J\b\u0010)\u001a\u00020\u001eH\u0002J\u0006\u0010*\u001a\u00020\u001eJ&\u0010+\u001a\u00020\u001e2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0-2\u0006\u0010!\u001a\u00020\"2\u0006\u0010.\u001a\u00020/H\u0002R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00062"}, d2={"Lcom/adaptr/android/playersdk/OfflineStationManager;", "", "station", "Lcom/adaptr/android/playersdk/models/Station;", "fileStoragePath", "", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Lcom/adaptr/android/playersdk/models/Station;Ljava/lang/String;Landroid/content/SharedPreferences;)V", "audioFiles", "", "Lcom/adaptr/android/playersdk/models/AudioFile;", "audioFilesAvailable", "getAudioFilesAvailable", "()Ljava/util/List;", "isStationAvailableOffline", "", "()Z", "log", "Lcom/adaptr/android/playersdk/ADLog;", "nextPlay", "Lcom/adaptr/android/playersdk/models/Play;", "getNextPlay", "()Lcom/adaptr/android/playersdk/models/Play;", "playList", "", "sharedPrefKey", "getStation", "()Lcom/adaptr/android/playersdk/models/Station;", "deleteConfig", "", "deleteFilesForAudioItems", "downloadStation", "stationDownloadListener", "Lcom/adaptr/android/playersdk/StationDownloadListener;", "getFilePathForId", "Ljava/io/File;", "id", "isFileAvailableOfflineForId", "loadConfig", "randomString", "saveConfig", "shuffleStation", "startNextDownload", "audioFileDownloadList", "Ljava/util/LinkedList;", "pastErrorCount", "", "Companion", "DownloadFilesTask", "PlayerSdk_exoDefaultRelease"})
public final class OfflineStationManager {
    private final ADLog log;
    private List<AudioFile> playList;
    private final List<AudioFile> audioFiles;
    private final String sharedPrefKey;
    @NotNull
    private final Station station;
    private final String fileStoragePath;
    private final SharedPreferences sharedPreferences;
    private static SecureRandom rnd;
    private static final String PLAYLIST_SHARED_PREF_KEY = ".playlist";
    public static final Companion Companion;

    public final boolean isStationAvailableOffline() {
        List<AudioFile> list = this.audioFiles;
        if (list != null) {
            List<AudioFile> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<AudioFile> it = list2;
            boolean bl3 = false;
            int count = it.size();
            int available = 0;
            for (AudioFile file : it) {
                if (!this.isFileAvailableOfflineForId(file.getId())) continue;
                ++available;
            }
            return count > 0 && available > count / 2;
        }
        return false;
    }

    @Nullable
    public final Play getNextPlay() {
        List<AudioFile> list = this.playList;
        if (list != null) {
            List<AudioFile> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<AudioFile> it = list2;
            boolean bl3 = false;
            Iterator<AudioFile> iterator = it.iterator();
            if (iterator.hasNext()) {
                AudioFile file = iterator.next();
                iterator.remove();
                if (this.isFileAvailableOfflineForId(file.getId())) {
                    Play play2 = new Play(this.randomString());
                    String string = this.getFilePathForId(file.getId()).getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePathForId(file.id).absolutePath");
                    file.setUrl(string);
                    play2.setAudioFile(file);
                    play2.setStation(this.station);
                    this.saveConfig();
                    return play2;
                }
            }
        }
        return null;
    }

    @NotNull
    public final List<AudioFile> getAudioFilesAvailable() {
        ArrayList<AudioFile> filesAvail = new ArrayList<AudioFile>();
        List<AudioFile> list = this.audioFiles;
        if (list != null) {
            List<AudioFile> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<AudioFile> it = list2;
            boolean bl3 = false;
            for (AudioFile file : it) {
                if (!this.isFileAvailableOfflineForId(file.getId())) continue;
                filesAvail.add(file);
            }
        }
        return filesAvail;
    }

    private final File getFilePathForId(String id) {
        File parentDir;
        File file = new File(this.fileStoragePath, id);
        File file2 = parentDir = file.getParentFile();
        if (file2 == null || !file2.exists()) {
            File file3 = parentDir;
            Boolean res = file3 != null ? Boolean.valueOf(file3.mkdirs()) : null;
            ADLog.e$default(this.log, "Unable to make path for local storage. Result = " + res, null, 2, null);
        }
        return file;
    }

    private final boolean isFileAvailableOfflineForId(String id) {
        File file = this.getFilePathForId(id);
        return file.exists();
    }

    public final void deleteFilesForAudioItems(@NotNull List<AudioFile> audioFiles) {
        Intrinsics.checkNotNullParameter(audioFiles, (String)"audioFiles");
        for (AudioFile audioFile : audioFiles) {
            File file = this.getFilePathForId(audioFile.getId());
            if (file.exists()) {
                boolean deleted = file.delete();
                if (deleted) {
                    ADLog.d$default(this.log, "Deleted audio file " + audioFile + " at path " + file, null, 2, null);
                    continue;
                }
                ADLog.e$default(this.log, "Unable to delete audio file " + audioFile + " at path " + file, null, 2, null);
                continue;
            }
            ADLog.w$default(this.log, "local file for " + audioFile + " does not seem to exist. Deleting, so ignoring.", null, 2, null);
        }
    }

    public final void shuffleStation() {
        block3: {
            List<AudioFile> list = this.audioFiles;
            if (list == null) break block3;
            List<AudioFile> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<AudioFile> it = list2;
            boolean bl3 = false;
            List<AudioFile> list3 = this.playList;
            if (list3 != null) {
                list3.clear();
            }
            List<AudioFile> list4 = this.playList;
            if (list4 != null) {
                list4.addAll((Collection<AudioFile>)it);
            }
            List<AudioFile> list5 = this.playList;
            if (list5 != null) {
                List<AudioFile> list6 = list5;
                boolean bl4 = false;
                Collections.shuffle(list6);
            }
        }
    }

    private final void saveConfig() {
        Gson gson = new Gson();
        String json = gson.toJson(this.playList);
        this.sharedPreferences.edit().putString(this.sharedPrefKey, json).apply();
    }

    private final void loadConfig() {
        Gson gson = new Gson();
        if (this.sharedPreferences.contains(this.sharedPrefKey)) {
            String json = this.sharedPreferences.getString(this.sharedPrefKey, "[]");
            this.playList = (List)gson.fromJson(json, new TypeToken<LinkedList<AudioFile>>(){}.getType());
            List<AudioFile> list = this.playList;
            if (list != null) {
                List<AudioFile> list2 = list;
                boolean bl = false;
                boolean bl2 = false;
                List<AudioFile> it = list2;
                boolean bl3 = false;
                if (it.size() > 0) {
                    return;
                }
            }
        }
        this.shuffleStation();
    }

    public final void deleteConfig() {
        String key = this.sharedPrefKey;
        if (this.sharedPreferences.contains(key)) {
            this.sharedPreferences.edit().remove(key).apply();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String randomString() {
        String AB = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder sb = new StringBuilder(8);
        int n = 0;
        int n2 = 7;
        while (n <= n2) {
            void i;
            sb.append(AB.charAt(rnd.nextInt(AB.length())));
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public final void downloadStation(@NotNull StationDownloadListener stationDownloadListener) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)stationDownloadListener, (String)"stationDownloadListener");
            LinkedList<AudioFile> audioFileDownloadList = new LinkedList<AudioFile>();
            List<AudioFile> list = this.audioFiles;
            if (list == null) break block0;
            List<AudioFile> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<AudioFile> it = list2;
            boolean bl3 = false;
            audioFileDownloadList.addAll((Collection)it);
            this.startNextDownload(audioFileDownloadList, stationDownloadListener, 0);
        }
    }

    private final void startNextDownload(LinkedList<AudioFile> audioFileDownloadList, StationDownloadListener stationDownloadListener, int pastErrorCount) {
        block3: {
            List<AudioFile> list = this.audioFiles;
            if (list == null) break block3;
            List<AudioFile> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<AudioFile> it = list2;
            boolean bl3 = false;
            stationDownloadListener.onDownloadProgress(this.station, it.size(), audioFileDownloadList.size(), pastErrorCount);
            if (audioFileDownloadList.size() == 0) {
                return;
            }
            try {
                AudioFile currentItem = audioFileDownloadList.removeLast();
                DownloadFilesTask filesTask = new DownloadFilesTask(audioFileDownloadList, stationDownloadListener, pastErrorCount);
                AsyncTask asyncTask = filesTask.execute(new String[]{currentItem.getUrl(), currentItem.getId()});
            }
            catch (Exception e) {
                ADLog.e$default(this.log, "Station download failed" + e, null, 2, null);
                stationDownloadListener.onDownloadProgress(this.station, this.audioFiles.size(), 0, pastErrorCount + audioFileDownloadList.size() + 1);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public final Station getStation() {
        return this.station;
    }

    public OfflineStationManager(@NotNull Station station, @NotNull String fileStoragePath, @NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)station, (String)"station");
        Intrinsics.checkNotNullParameter((Object)fileStoragePath, (String)"fileStoragePath");
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        this.station = station;
        this.fileStoragePath = fileStoragePath;
        this.sharedPreferences = sharedPreferences;
        this.log = new ADLog("com.adaptr.OfflineStationManager");
        this.station.setOfflineType(true);
        this.audioFiles = this.station.getAudioFiles();
        this.playList = new LinkedList();
        this.sharedPrefKey = this.station.getName() + PLAYLIST_SHARED_PREF_KEY;
        this.loadConfig();
        this.station.setAudioFiles(null);
    }

    static {
        Companion = new Companion(null);
        rnd = new SecureRandom();
    }

    public static final /* synthetic */ File access$getFilePathForId(OfflineStationManager $this, String id) {
        return $this.getFilePathForId(id);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0083\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u0001B%\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ#\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0014J%\u0010\u0013\u001a\u00020\u00102\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\r\"\u0004\u0018\u00010\u0003H\u0014\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/adaptr/android/playersdk/OfflineStationManager$DownloadFilesTask;", "Landroid/os/AsyncTask;", "", "", "audioFileDownloadList", "Ljava/util/LinkedList;", "Lcom/adaptr/android/playersdk/models/AudioFile;", "stationDownloadListener", "Lcom/adaptr/android/playersdk/StationDownloadListener;", "pastErrorCount", "(Lcom/adaptr/android/playersdk/OfflineStationManager;Ljava/util/LinkedList;Lcom/adaptr/android/playersdk/StationDownloadListener;I)V", "doInBackground", "info", "", "([Ljava/lang/String;)Ljava/lang/String;", "onCancelled", "", "result", "onPostExecute", "onProgressUpdate", "progress", "([Ljava/lang/Integer;)V", "PlayerSdk_exoDefaultRelease"})
    @SuppressLint(value={"StaticFieldLeak"})
    private final class DownloadFilesTask
    extends AsyncTask<String, Integer, String> {
        private final LinkedList<AudioFile> audioFileDownloadList;
        private final StationDownloadListener stationDownloadListener;
        private int pastErrorCount;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        protected String doInBackground(String ... info) {
            block34: {
                block33: {
                    block32: {
                        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                        input = null;
                        output = null;
                        connection = null;
                        try {
                            url = new URL(info[0]);
                            id = info[1];
                            file = OfflineStationManager.access$getFilePathForId(OfflineStationManager.this, id);
                            if (file.exists()) {
                                var8_13 = null;
                                ** try [egrp 1[TRYBLOCK] [0 : 62->67)] { 
lbl13:
                                // 1 sources

                                return var8_13;
                            }
                            v0 = url.openConnection();
                            if (v0 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                            }
                            connection = (HttpURLConnection)v0;
                            connection.connect();
                            if (connection.getResponseCode() != 200) {
                                var8_14 = "Server returned HTTP " + connection.getResponseCode() + " " + connection.getResponseMessage();
                                ** try [egrp 3[TRYBLOCK] [1 : 150->155)] { 
lbl22:
                                // 1 sources

                                break block32;
                            }
                            fileLength = connection.getContentLength();
                            input = connection.getInputStream();
                            output = new FileOutputStream(file);
                            data = new byte[4096];
                            total = 0L;
lbl29:
                            // 2 sources

                            while (true) {
                                byteCount = input.read(data);
                                if (byteCount >= 0) break block33;
                                ** try [egrp 7[TRYBLOCK] [3 : 333->353)] { 
lbl33:
                                // 1 sources

                                ** GOTO lbl-1000
                                break;
                            }
                        }
                        catch (Exception e) {
                            var6_9 = e.toString();
                            return var6_9;
                        }
lbl37:
                        // 1 sources

                        catch (IOException var9_16) {
                            // empty catch block
                        }
                        return var8_13;
lbl40:
                        // 1 sources

                        catch (IOException var9_17) {
                            // empty catch block
                        }
                    }
                    v1 = connection;
                    if (v1 == null) return var8_14;
                    v1.disconnect();
                    return var8_14;
lbl-1000:
                    // 1 sources

                    {
                        output.close();
                        v2 = input;
                        if (v2 != null) {
                            v2.close();
                        }
                        break block34;
                    }
lbl52:
                    // 1 sources

                    catch (IOException url) {
                        // empty catch block
                        break block34;
                    }
                }
                if (this.isCancelled()) {
                    v3 = input;
                    if (v3 != null) {
                        v3.close();
                    }
                    var13_21 = null;
                    try {
                        output.close();
                        v4 = input;
                        if (v4 != null) {
                            v4.close();
                        }
                    }
                    catch (IOException var14_22) {
                        // empty catch block
                    }
                    v5 = connection;
                    if (v5 == null) return var13_21;
                    v5.disconnect();
                    return var13_21;
                }
                total += (long)byteCount;
                if (fileLength > 0) {
                    this.publishProgress(new Integer[]{(int)(total * (long)100 / (long)fileLength)});
                }
                output.write(data, 0, byteCount);
                ** while (true)
            }
            v6 = connection;
            if (v6 == null) return null;
            v6.disconnect();
            return null;
            finally {
                try {
                    v7 = output;
                    if (v7 != null) {
                        v7.close();
                    }
                    v8 = input;
                    if (v8 != null) {
                        v8.close();
                    }
                }
                catch (IOException var7_12) {}
                v9 = connection;
                if (v9 != null) {
                    v9.disconnect();
                }
            }
        }

        protected void onProgressUpdate(Integer ... progress) {
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            ADLog.d$default(OfflineStationManager.this.log, "Progress = " + progress[0], null, 2, null);
        }

        protected void onPostExecute(@Nullable String result) {
            if (result != null) {
                int n = this.pastErrorCount;
                this.pastErrorCount = n + 1;
                ADLog.e$default(OfflineStationManager.this.log, "Download task error result = " + result, null, 2, null);
            }
            OfflineStationManager.this.startNextDownload(this.audioFileDownloadList, this.stationDownloadListener, this.pastErrorCount);
        }

        protected void onCancelled(@NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            ADLog.i$default(OfflineStationManager.this.log, "Download task cancelled", null, 2, null);
        }

        public DownloadFilesTask(@NotNull LinkedList<AudioFile> audioFileDownloadList, StationDownloadListener stationDownloadListener, int pastErrorCount) {
            Intrinsics.checkNotNullParameter(audioFileDownloadList, (String)"audioFileDownloadList");
            Intrinsics.checkNotNullParameter((Object)stationDownloadListener, (String)"stationDownloadListener");
            this.audioFileDownloadList = audioFileDownloadList;
            this.stationDownloadListener = stationDownloadListener;
            this.pastErrorCount = pastErrorCount;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adaptr/android/playersdk/OfflineStationManager$Companion;", "", "()V", "PLAYLIST_SHARED_PREF_KEY", "", "rnd", "Ljava/security/SecureRandom;", "PlayerSdk_exoDefaultRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

