/*
 * Decompiled with CFR 0.152.
 */
package com.adaptr.android.playersdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.adaptr.android.playersdk.ADLog;
import com.adaptr.android.playersdk.ExoSimulcastAudioPlayer;
import com.adaptr.android.playersdk.FeedSession;
import com.adaptr.android.playersdk.SimulcastApi;
import com.adaptr.android.playersdk.SimulcastEventListener;
import com.adaptr.android.playersdk.SimulcastPlaybackState;
import com.adaptr.android.playersdk.SimulcastStreamer;
import com.adaptr.android.playersdk.models.AudioFile;
import com.adaptr.android.playersdk.models.Play;
import com.adaptr.android.playersdk.models.webservice.SimulcastPlayResponse;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000w\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006*\u0001\"\u0018\u0000 >2\u00020\u0001:\u0001>B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00108\u001a\u000209H\u0002J\u0006\u0010:\u001a\u000209J\u0006\u0010;\u001a\u000209J\b\u0010<\u001a\u000209H\u0002J\b\u0010=\u001a\u000209H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR*\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\t0\u001bj\b\u0012\u0004\u0012\u00020\t`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u001fR\u000e\u0010 \u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R$\u00104\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0019\"\u0004\b6\u00107\u00a8\u0006?"}, d2={"Lcom/adaptr/android/playersdk/SimulcastStreamer;", "", "context", "Landroid/content/Context;", "token", "", "isPlayer", "", "eventListener", "Lcom/adaptr/android/playersdk/SimulcastEventListener;", "(Landroid/content/Context;Ljava/lang/String;ZLcom/adaptr/android/playersdk/SimulcastEventListener;)V", "clientId", "getContext", "()Landroid/content/Context;", "play", "Lcom/adaptr/android/playersdk/models/Play;", "currentItem", "getCurrentItem", "()Lcom/adaptr/android/playersdk/models/Play;", "setCurrentItem", "(Lcom/adaptr/android/playersdk/models/Play;)V", "<set-?>", "", "currentTime", "getCurrentTime", "()F", "eventListeners", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "fetchTimeInMs", "", "()Z", "lastConfirmedTrackPlayTimeByServerInSeconds", "listener", "com/adaptr/android/playersdk/SimulcastStreamer$listener$1", "Lcom/adaptr/android/playersdk/SimulcastStreamer$listener$1;", "log", "Lcom/adaptr/android/playersdk/ADLog;", "mMainHandler", "Landroid/os/Handler;", "mSimulcastApi", "Lcom/adaptr/android/playersdk/SimulcastApi;", "playFetchFlag", "player", "Lcom/adaptr/android/playersdk/ExoSimulcastAudioPlayer;", "state", "Lcom/adaptr/android/playersdk/SimulcastPlaybackState;", "getState", "()Lcom/adaptr/android/playersdk/SimulcastPlaybackState;", "getToken", "()Ljava/lang/String;", "value", "volume", "getVolume", "setVolume", "(F)V", "checkUpdateNeeded", "", "connect", "disconnect", "getCurrentPlay", "processUpdate", "Companion", "PlayerSdk_exoDefaultRelease"})
public final class SimulcastStreamer {
    private boolean playFetchFlag;
    private long fetchTimeInMs;
    private final ADLog log;
    private final ExoSimulcastAudioPlayer player;
    private float lastConfirmedTrackPlayTimeByServerInSeconds;
    private Handler mMainHandler;
    private final SimulcastApi mSimulcastApi;
    private String clientId;
    private float currentTime;
    private float volume;
    @Nullable
    private Play currentItem;
    @NotNull
    private final SimulcastPlaybackState state;
    private final ArrayList<SimulcastEventListener> eventListeners;
    private final listener.1 listener;
    @NotNull
    private final Context context;
    @NotNull
    private final String token;
    private final boolean isPlayer;
    private static final int UPDATE_MESSAGE;
    private static final int CANCEL_MESSAGE;
    private static final int UPDATE_INTERVAL;
    public static final Companion Companion;

    public final float getCurrentTime() {
        return this.currentTime;
    }

    public final float getVolume() {
        return this.volume;
    }

    public final void setVolume(float value) {
        this.player.setVolume(value);
        this.volume = value;
    }

    @Nullable
    public final Play getCurrentItem() {
        return this.player.getCurrentPlay();
    }

    public final void setCurrentItem(@Nullable Play play2) {
        block3: {
            Play it;
            block4: {
                this.playFetchFlag = false;
                Play play3 = play2;
                if (play3 == null) break block3;
                Play play4 = play3;
                boolean bl = false;
                boolean bl2 = false;
                it = play4;
                boolean bl3 = false;
                if (this.getCurrentItem() == null) break block4;
                Play play5 = this.getCurrentItem();
                if (!(Intrinsics.areEqual((Object)(play5 != null ? play5.getAudioFile() : null), (Object)it.getAudioFile()) ^ true)) break block3;
            }
            this.fetchTimeInMs = System.currentTimeMillis();
            this.currentItem = play2;
            this.lastConfirmedTrackPlayTimeByServerInSeconds = it.getElapsedSeconds();
            for (SimulcastEventListener event : this.eventListeners) {
                event.onPlayItemBeganPlayback(it);
            }
        }
    }

    @NotNull
    public final SimulcastPlaybackState getState() {
        return this.state;
    }

    public final void connect() {
        if (this.isPlayer) {
            this.player.play();
        } else {
            this.getCurrentPlay();
            this.mMainHandler.sendEmptyMessage(UPDATE_MESSAGE);
        }
    }

    public final void disconnect() {
        if (this.isPlayer) {
            this.player.stop();
        } else {
            this.mMainHandler.sendEmptyMessage(CANCEL_MESSAGE);
        }
    }

    private final void getCurrentPlay() {
        SimulcastApi.Companion.getHttpLog().level(HttpLoggingInterceptor.Level.BODY);
        Call<SimulcastPlayResponse> call = this.mSimulcastApi.simulcastGetInStudioPlay("cid=" + this.clientId, this.token);
        call.enqueue((Callback)new Callback<SimulcastPlayResponse>(this){
            final /* synthetic */ SimulcastStreamer this$0;

            public void onResponse(@NotNull Call<SimulcastPlayResponse> call, @NotNull Response<SimulcastPlayResponse> response) {
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter(response, (String)"response");
                        if (!response.isSuccessful()) break block4;
                        SimulcastPlayResponse simulcastPlayResponse = (SimulcastPlayResponse)response.body();
                        if (simulcastPlayResponse == null) break block5;
                        SimulcastPlayResponse simulcastPlayResponse2 = simulcastPlayResponse;
                        boolean bl = false;
                        boolean bl2 = false;
                        SimulcastPlayResponse it = simulcastPlayResponse2;
                        boolean bl3 = false;
                        SimulcastPlayResponse simulcastPlayResponse3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)simulcastPlayResponse3, (String)"it");
                        if (simulcastPlayResponse3.isSuccess()) {
                            if (it.getPlay() != null) {
                                this.this$0.setCurrentItem(it.getPlay());
                                ADLog.d$default(SimulcastStreamer.access$getLog$p(this.this$0), "Got new play " + this.this$0.getCurrentItem(), null, 2, null);
                            } else {
                                ADLog.e$default(SimulcastStreamer.access$getLog$p(this.this$0), "Server did not return a play object", null, 2, null);
                            }
                        } else {
                            ADLog.e$default(SimulcastStreamer.access$getLog$p(this.this$0), "Server returned an error", null, 2, null);
                            ADLog aDLog = SimulcastStreamer.access$getLog$p(this.this$0);
                            String string = it.getError().toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.error.toString()");
                            ADLog.e$default(aDLog, string, null, 2, null);
                        }
                        break block5;
                    }
                    Object object = response.errorBody();
                    if (object == null || (object = object.string()) == null) break block5;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl4 = false;
                    Object it = object2;
                    boolean bl5 = false;
                    ADLog.e$default(SimulcastStreamer.access$getLog$p(this.this$0), it, null, 2, null);
                }
            }

            public void onFailure(@NotNull Call<SimulcastPlayResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                ADLog aDLog = SimulcastStreamer.access$getLog$p(this.this$0);
                t.printStackTrace();
                ADLog.e$default(aDLog, Unit.INSTANCE, null, 2, null);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void processUpdate() {
        ADLog.d$default(this.log, "Processing update", null, 2, null);
        this.checkUpdateNeeded();
        long time = System.currentTimeMillis();
        float interval = (int)(time - this.fetchTimeInMs) / 1000;
        this.currentTime = this.lastConfirmedTrackPlayTimeByServerInSeconds + interval;
        Play play2 = this.getCurrentItem();
        if (play2 != null) {
            Play play3 = play2;
            boolean bl = false;
            boolean bl2 = false;
            Play it = play3;
            boolean bl3 = false;
            for (SimulcastEventListener event : this.eventListeners) {
                event.onProgressUpdate(it, this.currentTime, it.getAudioFile().getDurationInSeconds());
            }
        }
    }

    private final void checkUpdateNeeded() {
        if (this.getCurrentItem() != null) {
            Play play2 = this.getCurrentItem();
            AudioFile audioFile = play2 != null ? play2.getAudioFile() : null;
            Intrinsics.checkNotNull((Object)audioFile);
            if (this.currentTime - audioFile.getDurationInSeconds() > 0.0f && !this.playFetchFlag) {
                this.playFetchFlag = true;
                this.getCurrentPlay();
            }
        } else {
            this.getCurrentPlay();
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    public final boolean isPlayer() {
        return this.isPlayer;
    }

    public SimulcastStreamer(@NotNull Context context, @NotNull String token, boolean isPlayer, @NotNull SimulcastEventListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.context = context;
        this.token = token;
        this.isPlayer = isPlayer;
        this.log = new ADLog("fm.feed.FeedSimulcastStreamer");
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"Looper.getMainLooper()");
        this.player = new ExoSimulcastAudioPlayer(this.context, looper, this.token);
        Object object = SimulcastApi.Companion.getRetrofitInStudio().create(SimulcastApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SimulcastApi.retrofitInS\u2026SimulcastApi::class.java)");
        this.mSimulcastApi = (SimulcastApi)object;
        this.clientId = FeedSession.Companion.retrieveClientId(this.context);
        this.volume = 1.0f;
        this.state = SimulcastPlaybackState.Idle;
        this.eventListeners = new ArrayList();
        this.listener = new SimulcastEventListener(this){
            final /* synthetic */ SimulcastStreamer this$0;

            public void onPlayItemBeganPlayback(@NotNull Play play2) {
                Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
                for (SimulcastEventListener event : SimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                    event.onPlayItemBeganPlayback(play2);
                }
            }

            public void onPlayerStateChanged(@NotNull SimulcastPlaybackState playerState) {
                Intrinsics.checkNotNullParameter((Object)((Object)playerState), (String)"playerState");
                for (SimulcastEventListener event : SimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                    event.onPlayerStateChanged(playerState);
                }
            }

            public void onProgressUpdate(@NotNull Play play2, float elapsedTime, float duration) {
                Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
                for (SimulcastEventListener event : SimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                    event.onProgressUpdate(play2, elapsedTime, duration);
                }
            }

            public void onPlayerError(@NotNull Exception error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                for (SimulcastEventListener event : SimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                    event.onPlayerError(error);
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        if (this.isPlayer) {
            this.player.setEventListener(this.listener);
        }
        this.eventListeners.add(eventListener);
        this.mMainHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(@NotNull Message msg) {
                block1: {
                    int n;
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                        n = msg.what;
                        if (n != UPDATE_MESSAGE) break block0;
                        this.processUpdate();
                        this.removeMessages(UPDATE_MESSAGE);
                        this.sendEmptyMessageDelayed(UPDATE_MESSAGE, UPDATE_INTERVAL);
                        break block1;
                    }
                    if (n != CANCEL_MESSAGE) break block1;
                    this.removeMessages(UPDATE_MESSAGE);
                }
            }
        };
    }

    static {
        Companion = new Companion(null);
        UPDATE_MESSAGE = 1;
        CANCEL_MESSAGE = 2;
        UPDATE_INTERVAL = 1000;
    }

    public static final /* synthetic */ ADLog access$getLog$p(SimulcastStreamer $this) {
        return $this.log;
    }

    public static final /* synthetic */ ArrayList access$getEventListeners$p(SimulcastStreamer $this) {
        return $this.eventListeners;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adaptr/android/playersdk/SimulcastStreamer$Companion;", "", "()V", "CANCEL_MESSAGE", "", "UPDATE_INTERVAL", "UPDATE_MESSAGE", "PlayerSdk_exoDefaultRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

