/*
 * Decompiled with CFR 0.152.
 */
package com.adaptr.android.playersdk;

import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.IBinder;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.view.KeyEvent;
import com.adaptr.android.playersdk.ADLog;
import com.adaptr.android.playersdk.AdaptrPlayer;
import com.adaptr.android.playersdk.LikeStatusChangeListener;
import com.adaptr.android.playersdk.MediaNotificationManager;
import com.adaptr.android.playersdk.NotificationDataListener;
import com.adaptr.android.playersdk.PlayListener;
import com.adaptr.android.playersdk.PlayerService;
import com.adaptr.android.playersdk.PlayerService$WhenMappings;
import com.adaptr.android.playersdk.State;
import com.adaptr.android.playersdk.StateListener;
import com.adaptr.android.playersdk.models.AudioFile;
import com.adaptr.android.playersdk.models.NotificationStyle;
import com.adaptr.android.playersdk.models.Play;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008d\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e*\u0001\u000e\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002?@B\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020\u0019H\u0016J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0019H\u0016J\b\u0010)\u001a\u00020\u0019H\u0016J\u0012\u0010*\u001a\u00020\u00192\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J \u0010-\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J\u0010\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u000203H\u0016J \u00104\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u0015H\u0016J\u0010\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u001cH\u0016J\u000e\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\nJ\b\u0010;\u001a\u00020\u0019H\u0002J\b\u0010<\u001a\u00020\u0019H\u0002J\u0010\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u000203H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/adaptr/android/playersdk/PlayerService;", "Landroid/app/Service;", "Lcom/adaptr/android/playersdk/StateListener;", "Lcom/adaptr/android/playersdk/LikeStatusChangeListener;", "Lcom/adaptr/android/playersdk/PlayListener;", "Lcom/adaptr/android/playersdk/NotificationDataListener;", "()V", "log", "Lcom/adaptr/android/playersdk/ADLog;", "mAudioPlayer", "Lcom/adaptr/android/playersdk/AdaptrPlayer;", "mBinder", "Landroid/os/IBinder;", "mCallback", "com/adaptr/android/playersdk/PlayerService$mCallback$1", "Lcom/adaptr/android/playersdk/PlayerService$mCallback$1;", "mMediaSession", "Landroid/support/v4/media/session/MediaSessionCompat;", "mNotificationManager", "Lcom/adaptr/android/playersdk/MediaNotificationManager;", "mState", "", "createDefaultContentIntent", "Landroid/app/PendingIntent;", "destroyMediaSession", "", "mapStateToState", "playerState", "Lcom/adaptr/android/playersdk/State;", "onArtWorkChanged", "bitmap", "Landroid/graphics/Bitmap;", "onBind", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onLikeStatusChanged", "audioFile", "Lcom/adaptr/android/playersdk/models/AudioFile;", "onNotificationStyleChanged", "onPendingIntentChanged", "onPlayStarted", "play", "Lcom/adaptr/android/playersdk/models/Play;", "onProgressUpdate", "elapsedTime", "", "duration", "onSkipStatusChanged", "status", "", "onStartCommand", "flags", "startId", "onStateChanged", "state", "setPlayer", "player", "setPs", "updateMetaData", "updateState", "forceUpdateNotification", "LocalBinder", "RemoteReceiver", "PlayerSdk_exoDefaultRelease"})
public final class PlayerService
extends Service
implements StateListener,
LikeStatusChangeListener,
PlayListener,
NotificationDataListener {
    private final ADLog log = new ADLog("fm.feed.PlayerService");
    private IBinder mBinder = (IBinder)new LocalBinder();
    private AdaptrPlayer mAudioPlayer;
    private MediaSessionCompat mMediaSession;
    private int mState;
    private MediaNotificationManager mNotificationManager;
    private final mCallback.1 mCallback = new MediaSessionCompat.Callback(this){
        final /* synthetic */ PlayerService this$0;

        public void onPlay() {
            ADLog.d$default(PlayerService.access$getLog$p(this.this$0), "media session play", null, 2, null);
            PlayerService.access$getMAudioPlayer$p(this.this$0).play();
        }

        public void onPause() {
            ADLog.d$default(PlayerService.access$getLog$p(this.this$0), "media session paused", null, 2, null);
            PlayerService.access$getMAudioPlayer$p(this.this$0).pause();
        }

        public void onSkipToNext() {
            ADLog.d$default(PlayerService.access$getLog$p(this.this$0), "media session skip", null, 2, null);
            PlayerService.access$getMAudioPlayer$p(this.this$0).skip();
        }

        public void onStop() {
            ADLog.d$default(PlayerService.access$getLog$p(this.this$0), "media session stopped", null, 2, null);
            PlayerService.access$getMAudioPlayer$p(this.this$0).pause();
            PlayerService.access$destroyMediaSession(this.this$0);
        }

        public void onSetRating(@NotNull RatingCompat rating) {
            Intrinsics.checkNotNullParameter((Object)rating, (String)"rating");
            if (rating.getRatingStyle() == 2) {
                Play.LikeState likeState;
                Play.LikeState likeState2;
                if (PlayerService.access$getMAudioPlayer$p(this.this$0).getCurrentPlay() != null) {
                    Play play2 = PlayerService.access$getMAudioPlayer$p(this.this$0).getCurrentPlay();
                    Intrinsics.checkNotNull((Object)play2);
                    likeState2 = play2.getLikeState();
                } else {
                    likeState2 = likeState = Play.LikeState.NONE;
                }
                if (rating.isThumbUp()) {
                    if (likeState == Play.LikeState.LIKED) {
                        AdaptrPlayer adaptrPlayer = PlayerService.access$getMAudioPlayer$p(this.this$0);
                        Play play3 = PlayerService.access$getMAudioPlayer$p(this.this$0).getCurrentPlay();
                        Intrinsics.checkNotNull((Object)play3);
                        adaptrPlayer.unlike(play3.getAudioFile());
                    } else {
                        PlayerService.access$getMAudioPlayer$p(this.this$0).like();
                    }
                } else if (likeState == Play.LikeState.DISLIKED) {
                    AdaptrPlayer adaptrPlayer = PlayerService.access$getMAudioPlayer$p(this.this$0);
                    Play play4 = PlayerService.access$getMAudioPlayer$p(this.this$0).getCurrentPlay();
                    Intrinsics.checkNotNull((Object)play4);
                    adaptrPlayer.unlike(play4.getAudioFile());
                } else {
                    PlayerService.access$getMAudioPlayer$p(this.this$0).dislike();
                }
            }
        }
        {
            this.this$0 = this$0;
        }
    };

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return this.mBinder;
    }

    public final void setPlayer(@NotNull AdaptrPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AdaptrPlayer adaptrPlayer = this.mAudioPlayer = player;
        if (adaptrPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        adaptrPlayer.addStateListener(this);
        AdaptrPlayer adaptrPlayer2 = this.mAudioPlayer;
        if (adaptrPlayer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        adaptrPlayer2.addLikeStatusChangeListener(this);
        AdaptrPlayer adaptrPlayer3 = this.mAudioPlayer;
        if (adaptrPlayer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        adaptrPlayer3.addPlayListener(this);
        AdaptrPlayer adaptrPlayer4 = this.mAudioPlayer;
        if (adaptrPlayer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        adaptrPlayer4.setNotificationDataListener$PlayerSdk_exoDefaultRelease(this);
        AdaptrPlayer adaptrPlayer5 = this.mAudioPlayer;
        if (adaptrPlayer5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        this.mState = this.mapStateToState(adaptrPlayer5.getState());
        this.updateState(true);
        this.updateMetaData();
    }

    @Override
    public void onStateChanged(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.mState = this.mapStateToState(state);
        this.updateState(false);
    }

    @Override
    public void onSkipStatusChanged(boolean status) {
        this.updateState(false);
    }

    @Override
    public void onProgressUpdate(@NotNull Play play2, float elapsedTime, float duration) {
        Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
    }

    @Override
    public void onPlayStarted(@Nullable Play play2) {
        this.updateMetaData();
    }

    @Override
    public void onLikeStatusChanged(@NotNull AudioFile audioFile) {
        Intrinsics.checkNotNullParameter((Object)audioFile, (String)"audioFile");
        this.updateMetaData();
    }

    @Override
    public void onPendingIntentChanged() {
        this.updateState(true);
    }

    @Override
    public void onNotificationStyleChanged() {
        this.updateState(true);
        if (this.mNotificationManager != null) {
            AdaptrPlayer adaptrPlayer = this.mAudioPlayer;
            if (adaptrPlayer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
            }
            if (adaptrPlayer.getNotificationStyle() != null) {
                MediaNotificationManager mediaNotificationManager = this.mNotificationManager;
                Intrinsics.checkNotNull((Object)((Object)mediaNotificationManager));
                AdaptrPlayer adaptrPlayer2 = this.mAudioPlayer;
                if (adaptrPlayer2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
                }
                NotificationStyle notificationStyle = adaptrPlayer2.getNotificationStyle();
                Intrinsics.checkNotNull((Object)notificationStyle);
                mediaNotificationManager.setNotificationIcons(notificationStyle);
            }
        }
    }

    @Override
    public void onArtWorkChanged(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.updateMetaData();
    }

    public void onCreate() {
        super.onCreate();
    }

    public void onDestroy() {
        if (this.mNotificationManager != null) {
            MediaNotificationManager mediaNotificationManager = this.mNotificationManager;
            Intrinsics.checkNotNull((Object)((Object)mediaNotificationManager));
            mediaNotificationManager.cancelNotification();
        }
        super.onDestroy();
    }

    public int onStartCommand(@NotNull Intent intent, int flags, int startId) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return 2;
    }

    private final PendingIntent createDefaultContentIntent() {
        PackageManager manager = this.getPackageManager();
        Intent intent = manager.getLaunchIntentForPackage(this.getApplicationInfo().packageName);
        if (intent == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"manager.getLaunchIntentF\u2026ckageName) ?: return null");
        Intent i = intent;
        i.addFlags(0x20400000);
        return PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)i, (int)0x10000000);
    }

    private final int mapStateToState(State playerState) {
        switch (PlayerService$WhenMappings.$EnumSwitchMapping$0[playerState.ordinal()]) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: 
            case 4: {
                return 6;
            }
            case 5: {
                return 0;
            }
            case 6: 
            case 7: {
                return 1;
            }
        }
        return 1;
    }

    private final void updateState(boolean forceUpdateNotification) {
        if (this.mMediaSession == null || forceUpdateNotification) {
            PendingIntent intent;
            if (this.mState != 3) {
                ADLog.d$default(this.log, "Ignoring state update since playback hasn't started yet", null, 2, null);
                return;
            }
            ADLog.d$default(this.log, "Creating new media session", null, 2, null);
            ComponentName receiver = new ComponentName(this.getPackageName(), RemoteReceiver.class.getName());
            MediaSessionCompat mediaSessionCompat = this.mMediaSession = new MediaSessionCompat((Context)this, "Feed Music Service", receiver, null);
            Intrinsics.checkNotNull((Object)mediaSessionCompat);
            mediaSessionCompat.setFlags(3);
            MediaSessionCompat mediaSessionCompat2 = this.mMediaSession;
            Intrinsics.checkNotNull((Object)mediaSessionCompat2);
            mediaSessionCompat2.setCallback((MediaSessionCompat.Callback)this.mCallback);
            MediaSessionCompat mediaSessionCompat3 = this.mMediaSession;
            Intrinsics.checkNotNull((Object)mediaSessionCompat3);
            mediaSessionCompat3.setActive(true);
            AdaptrPlayer adaptrPlayer = this.mAudioPlayer;
            if (adaptrPlayer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
            }
            if ((intent = adaptrPlayer.getPendingIntent()) == null) {
                intent = this.createDefaultContentIntent();
            }
            this.setPs();
            this.updateMetaData();
            AdaptrPlayer adaptrPlayer2 = this.mAudioPlayer;
            if (adaptrPlayer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
            }
            MediaSessionCompat mediaSessionCompat4 = this.mMediaSession;
            Intrinsics.checkNotNull((Object)mediaSessionCompat4);
            MediaControllerCompat mediaControllerCompat = mediaSessionCompat4.getController();
            AdaptrPlayer adaptrPlayer3 = this.mAudioPlayer;
            if (adaptrPlayer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
            }
            this.mNotificationManager = new MediaNotificationManager(adaptrPlayer2, this, mediaControllerCompat, intent, adaptrPlayer3.getNotificationStyle());
        } else if (this.mState == 0 || this.mState == 1) {
            this.destroyMediaSession();
            return;
        }
        long capabilities = 641L;
        AdaptrPlayer adaptrPlayer = this.mAudioPlayer;
        if (adaptrPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        if (adaptrPlayer.canSkip()) {
            capabilities |= 0x20L;
        }
        float rate = this.mState == 3 ? 1.0f : 0.0f;
        ADLog.d$default(this.log, "Updating playback state", null, 2, null);
        PlaybackStateCompat.Builder builder = new PlaybackStateCompat.Builder();
        AdaptrPlayer adaptrPlayer4 = this.mAudioPlayer;
        if (adaptrPlayer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        PlaybackStateCompat ps = builder.setState(this.mState, (long)adaptrPlayer4.getCurrentPlaybackTime() * (long)1000, rate).setActions(capabilities).build();
        MediaSessionCompat mediaSessionCompat = this.mMediaSession;
        Intrinsics.checkNotNull((Object)mediaSessionCompat);
        mediaSessionCompat.setPlaybackState(ps);
    }

    private final void setPs() {
        long capabilities = 641L;
        AdaptrPlayer adaptrPlayer = this.mAudioPlayer;
        if (adaptrPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        if (adaptrPlayer.canSkip()) {
            capabilities |= 0x20L;
        }
        float rate = this.mState == 3 ? 1.0f : 0.0f;
        ADLog.d$default(this.log, "Updating playback state", null, 2, null);
        PlaybackStateCompat.Builder builder = new PlaybackStateCompat.Builder();
        AdaptrPlayer adaptrPlayer2 = this.mAudioPlayer;
        if (adaptrPlayer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        PlaybackStateCompat ps = builder.setState(this.mState, (long)(adaptrPlayer2.getCurrentPlaybackTime() * (float)1000), rate).setActions(capabilities).build();
        MediaSessionCompat mediaSessionCompat = this.mMediaSession;
        Intrinsics.checkNotNull((Object)mediaSessionCompat);
        mediaSessionCompat.setPlaybackState(ps);
    }

    private final void updateMetaData() {
        if (this.mMediaSession == null) {
            return;
        }
        MediaMetadataCompat.Builder builder = new MediaMetadataCompat.Builder();
        AdaptrPlayer adaptrPlayer = this.mAudioPlayer;
        if (adaptrPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        if (adaptrPlayer.getCurrentPlay() == null) {
            ADLog.d$default(this.log, "(metadata will be empty)", null, 2, null);
        } else {
            AdaptrPlayer adaptrPlayer2 = this.mAudioPlayer;
            if (adaptrPlayer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
            }
            if (adaptrPlayer2.getCurrentPlay() != null) {
                AdaptrPlayer adaptrPlayer3 = this.mAudioPlayer;
                if (adaptrPlayer3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
                }
                Play play2 = adaptrPlayer3.getCurrentPlay();
                Intrinsics.checkNotNull((Object)play2);
                MediaMetadataCompat.Builder builder2 = builder.putString("android.media.metadata.TITLE", play2.getAudioFile().getTrack().getTitle());
                AdaptrPlayer adaptrPlayer4 = this.mAudioPlayer;
                if (adaptrPlayer4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
                }
                Play play3 = adaptrPlayer4.getCurrentPlay();
                Intrinsics.checkNotNull((Object)play3);
                MediaMetadataCompat.Builder builder3 = builder2.putString("android.media.metadata.ARTIST", play3.getAudioFile().getArtist().getName());
                AdaptrPlayer adaptrPlayer5 = this.mAudioPlayer;
                if (adaptrPlayer5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
                }
                Play play4 = adaptrPlayer5.getCurrentPlay();
                Intrinsics.checkNotNull((Object)play4);
                builder3.putString("android.media.metadata.ALBUM", play4.getAudioFile().getRelease().getTitle());
            }
            AdaptrPlayer adaptrPlayer6 = this.mAudioPlayer;
            if (adaptrPlayer6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
            }
            if (adaptrPlayer6.getArtWork() != null) {
                AdaptrPlayer adaptrPlayer7 = this.mAudioPlayer;
                if (adaptrPlayer7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
                }
                builder.putBitmap("android.media.metadata.ART", adaptrPlayer7.getArtWork());
                AdaptrPlayer adaptrPlayer8 = this.mAudioPlayer;
                if (adaptrPlayer8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
                }
                builder.putBitmap("android.media.metadata.ALBUM_ART", adaptrPlayer8.getArtWork());
            }
            AdaptrPlayer adaptrPlayer9 = this.mAudioPlayer;
            if (adaptrPlayer9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
            }
            Play play5 = adaptrPlayer9.getCurrentPlay();
            Intrinsics.checkNotNull((Object)play5);
            Play.LikeState likeState = play5.getLikeState();
            if (likeState == Play.LikeState.LIKED) {
                builder.putRating("android.media.metadata.RATING", RatingCompat.newThumbRating((boolean)true));
            } else if (likeState == Play.LikeState.DISLIKED) {
                builder.putRating("android.media.metadata.RATING", RatingCompat.newThumbRating((boolean)false));
            }
        }
        MediaMetadataCompat md = builder.build();
        MediaSessionCompat mediaSessionCompat = this.mMediaSession;
        Intrinsics.checkNotNull((Object)mediaSessionCompat);
        mediaSessionCompat.setMetadata(md);
    }

    private final void destroyMediaSession() {
        ADLog.d$default(this.log, "releasing media session", null, 2, null);
        if (this.mMediaSession != null) {
            MediaSessionCompat mediaSessionCompat = this.mMediaSession;
            Intrinsics.checkNotNull((Object)mediaSessionCompat);
            mediaSessionCompat.release();
            this.mMediaSession = null;
            if (this.mNotificationManager != null) {
                MediaNotificationManager mediaNotificationManager = this.mNotificationManager;
                Intrinsics.checkNotNull((Object)((Object)mediaNotificationManager));
                mediaNotificationManager.cancelNotification();
                this.mNotificationManager = null;
            }
        }
    }

    public static final /* synthetic */ AdaptrPlayer access$getMAudioPlayer$p(PlayerService $this) {
        AdaptrPlayer adaptrPlayer = $this.mAudioPlayer;
        if (adaptrPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAudioPlayer");
        }
        return adaptrPlayer;
    }

    public static final /* synthetic */ void access$setMAudioPlayer$p(PlayerService $this, AdaptrPlayer adaptrPlayer) {
        $this.mAudioPlayer = adaptrPlayer;
    }

    public static final /* synthetic */ void access$destroyMediaSession(PlayerService $this) {
        $this.destroyMediaSession();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/adaptr/android/playersdk/PlayerService$LocalBinder;", "Landroid/os/Binder;", "(Lcom/adaptr/android/playersdk/PlayerService;)V", "playerInstance", "Lcom/adaptr/android/playersdk/PlayerService;", "getPlayerInstance", "()Lcom/adaptr/android/playersdk/PlayerService;", "PlayerSdk_exoDefaultRelease"})
    public final class LocalBinder
    extends Binder {
        @NotNull
        public final PlayerService getPlayerInstance() {
            return PlayerService.this;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/adaptr/android/playersdk/PlayerService$RemoteReceiver;", "Landroid/content/BroadcastReceiver;", "(Lcom/adaptr/android/playersdk/PlayerService;)V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "PlayerSdk_exoDefaultRelease"})
    public final class RemoteReceiver
    extends BroadcastReceiver {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (Intrinsics.areEqual((Object)"android.intent.action.MEDIA_BUTTON", (Object)intent.getAction())) {
                KeyEvent event = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
                if (event == null || event.getAction() != 0) return;
                State state = PlayerService.access$getMAudioPlayer$p(PlayerService.this).getState();
                ADLog.d$default(PlayerService.this.log, "received media action button", null, 2, null);
                switch (event.getKeyCode()) {
                    case 85: {
                        if (state == State.PAUSED) {
                            PlayerService.access$getMAudioPlayer$p(PlayerService.this).play();
                            return;
                        }
                        if (state != State.PLAYING) return;
                        PlayerService.access$getMAudioPlayer$p(PlayerService.this).pause();
                        return;
                    }
                    case 127: {
                        if (state != State.PLAYING) return;
                        PlayerService.access$getMAudioPlayer$p(PlayerService.this).pause();
                        return;
                    }
                    case 126: {
                        if (state != State.PAUSED) return;
                        PlayerService.access$getMAudioPlayer$p(PlayerService.this).play();
                        return;
                    }
                    default: {
                        return;
                    }
                }
            } else {
                ADLog aDLog = PlayerService.this.log;
                StringBuilder stringBuilder = new StringBuilder().append(" unknown action: ");
                String string = intent.getAction();
                Intrinsics.checkNotNull((Object)string);
                ADLog.d$default(aDLog, stringBuilder.append(string).toString(), null, 2, null);
            }
        }
    }
}

