/*
 * Decompiled with CFR 0.152.
 */
package com.adaptr.android.playersdk;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.adaptr.android.playersdk.ADLog;
import com.adaptr.android.playersdk.ExoSimulcastAudioPlayer;
import com.adaptr.android.playersdk.FeedSession;
import com.adaptr.android.playersdk.SimulcastApi;
import com.adaptr.android.playersdk.SimulcastEventListener;
import com.adaptr.android.playersdk.SimulcastPlaybackState;
import com.adaptr.android.playersdk.models.Play;
import com.adaptr.android.playersdk.models.webservice.PlayResponse;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;
import fm.feed.android.playersdk.PlayerProxy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u007f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b*\u00010\b\u0000\u0018\u0000 C2\u00020\u0001:\u0001CB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u00104\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020:H\u0002J\u0006\u0010\n\u001a\u00020:J\b\u0010=\u001a\u00020:H\u0002J\u0010\u0010>\u001a\u00020:2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010?\u001a\u00020:2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010@\u001a\u00020:J\u0010\u0010A\u001a\u00020:2\u0006\u0010B\u001a\u00020.H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0015\"\u0004\b7\u00108\u00a8\u0006D"}, d2={"Lcom/adaptr/android/playersdk/ExoSimulcastAudioPlayer;", "", "mContext", "Landroid/content/Context;", "looper", "Landroid/os/Looper;", "token", "", "(Landroid/content/Context;Landroid/os/Looper;Ljava/lang/String;)V", "clientId", "play", "Lcom/adaptr/android/playersdk/models/Play;", "currentPlay", "getCurrentPlay", "()Lcom/adaptr/android/playersdk/models/Play;", "setCurrentPlay", "(Lcom/adaptr/android/playersdk/models/Play;)V", "<set-?>", "", "currentTime", "getCurrentTime", "()F", "errorCount", "", "eventListener", "Lcom/adaptr/android/playersdk/SimulcastEventListener;", "fetchTimeInMs", "", "lastConfirmedTrackPlayTimeByServerInSeconds", "log", "Lcom/adaptr/android/playersdk/ADLog;", "getLooper", "()Landroid/os/Looper;", "mMainHandler", "Landroid/os/Handler;", "mSimulcastApi", "Lcom/adaptr/android/playersdk/SimulcastApi;", "playFetchFlag", "", "player", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "getPlayer$PlayerSdk_exoDefaultRelease", "()Lcom/google/android/exoplayer2/SimpleExoPlayer;", "setPlayer$PlayerSdk_exoDefaultRelease", "(Lcom/google/android/exoplayer2/SimpleExoPlayer;)V", "playerState", "Lcom/adaptr/android/playersdk/SimulcastPlaybackState;", "primaryEventListener", "com/adaptr/android/playersdk/ExoSimulcastAudioPlayer$primaryEventListener$1", "Lcom/adaptr/android/playersdk/ExoSimulcastAudioPlayer$primaryEventListener$1;", "getToken", "()Ljava/lang/String;", "url", "volume", "getVolume", "setVolume", "(F)V", "checkUpdateNeeded", "", "createMediaSource", "Lcom/google/android/exoplayer2/source/MediaSource;", "processUpdate", "setCurrentTime", "setEventListener", "stop", "updateToState", "state", "Companion", "PlayerSdk_exoDefaultRelease"})
public final class ExoSimulcastAudioPlayer {
    @NotNull
    private SimpleExoPlayer player;
    private SimulcastPlaybackState playerState;
    private long fetchTimeInMs;
    private final ADLog log;
    private final SimulcastApi mSimulcastApi;
    private String clientId;
    private final String url;
    private float lastConfirmedTrackPlayTimeByServerInSeconds;
    private float currentTime;
    private float volume;
    private int errorCount;
    private SimulcastEventListener eventListener;
    private boolean playFetchFlag;
    private Handler mMainHandler;
    @Nullable
    private Play currentPlay;
    private final primaryEventListener.1 primaryEventListener;
    private final Context mContext;
    @NotNull
    private final Looper looper;
    @NotNull
    private final String token;
    private static final int UPDATE_MESSAGE;
    private static final int CANCEL_MESSAGE;
    private static final int UPDATE_INTERVAL;
    public static final Companion Companion;

    @NotNull
    public final SimpleExoPlayer getPlayer$PlayerSdk_exoDefaultRelease() {
        return this.player;
    }

    public final void setPlayer$PlayerSdk_exoDefaultRelease(@NotNull SimpleExoPlayer simpleExoPlayer) {
        Intrinsics.checkNotNullParameter((Object)simpleExoPlayer, (String)"<set-?>");
        this.player = simpleExoPlayer;
    }

    public final float getCurrentTime() {
        return this.currentTime;
    }

    public final float getVolume() {
        return this.volume;
    }

    public final void setVolume(float volume2) {
        this.volume = volume2;
        this.player.setVolume(volume2);
    }

    @Nullable
    public final Play getCurrentPlay() {
        return this.currentPlay;
    }

    public final void setCurrentPlay(@Nullable Play play2) {
        block1: {
            Play it;
            block2: {
                this.playFetchFlag = false;
                Play play3 = play2;
                if (play3 == null) break block1;
                Play play4 = play3;
                boolean bl = false;
                boolean bl2 = false;
                it = play4;
                boolean bl3 = false;
                if (this.currentPlay == null) break block2;
                Play play5 = this.currentPlay;
                if (!(Intrinsics.areEqual((Object)(play5 != null ? play5.getAudioFile() : null), (Object)it.getAudioFile()) ^ true)) break block1;
            }
            this.fetchTimeInMs = System.currentTimeMillis();
            this.currentPlay = play2;
            this.setCurrentTime(it.getElapsedSeconds());
            SimulcastEventListener simulcastEventListener = this.eventListener;
            if (simulcastEventListener != null) {
                simulcastEventListener.onPlayItemBeganPlayback(it);
            }
        }
    }

    public final void setEventListener(@NotNull SimulcastEventListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.eventListener = eventListener;
    }

    private final void setCurrentTime(float currentTime) {
        this.lastConfirmedTrackPlayTimeByServerInSeconds = currentTime;
    }

    private final void processUpdate() {
        block1: {
            ADLog.d$default(this.log, "Processing update", null, 2, null);
            this.checkUpdateNeeded();
            long time = System.currentTimeMillis();
            float interval = (int)(time - this.fetchTimeInMs) / 1000;
            this.currentTime = this.lastConfirmedTrackPlayTimeByServerInSeconds + interval;
            Play play2 = this.currentPlay;
            if (play2 == null) break block1;
            Play play3 = play2;
            boolean bl = false;
            boolean bl2 = false;
            Play it = play3;
            boolean bl3 = false;
            SimulcastEventListener simulcastEventListener = this.eventListener;
            if (simulcastEventListener != null) {
                simulcastEventListener.onProgressUpdate(it, this.currentTime, it.getAudioFile().getDurationInSeconds());
            }
        }
    }

    private final void checkUpdateNeeded() {
        Play play2 = this.currentPlay;
        if (play2 != null) {
            Play play3 = play2;
            boolean bl = false;
            boolean bl2 = false;
            Play it = play3;
            boolean bl3 = false;
            if (this.currentTime - it.getAudioFile().getDurationInSeconds() > 0.0f && !this.playFetchFlag) {
                this.getCurrentPlay();
                this.playFetchFlag = true;
            }
        }
        if (this.currentPlay == null) {
            this.getCurrentPlay();
            this.playFetchFlag = true;
        }
    }

    private final void updateToState(SimulcastPlaybackState state) {
        block1: {
            if (this.playerState == state) break block1;
            this.playerState = state;
            SimulcastEventListener simulcastEventListener = this.eventListener;
            if (simulcastEventListener != null) {
                simulcastEventListener.onPlayerStateChanged(this.playerState);
            }
        }
    }

    private final MediaSource createMediaSource(String url) {
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(this.mContext, Util.getUserAgent((Context)this.mContext, (String)"FeedAndroidSdk"));
        DefaultExtractorsFactory extractorsFactory = new DefaultExtractorsFactory();
        ExtractorMediaSource.Factory extractorsMSFactory = new ExtractorMediaSource.Factory((DataSource.Factory)dataSourceFactory).setExtractorsFactory((ExtractorsFactory)extractorsFactory);
        ExtractorMediaSource extractorMediaSource = extractorsMSFactory.createMediaSource(Uri.parse((String)url));
        Intrinsics.checkNotNullExpressionValue((Object)extractorMediaSource, (String)"extractorsMSFactory.crea\u2026diaSource(Uri.parse(url))");
        return (MediaSource)extractorMediaSource;
    }

    public final void play() {
        this.getCurrentPlay();
        MediaSource mediaSource = this.createMediaSource(this.url);
        this.player.prepare(mediaSource);
        this.player.setPlayWhenReady(true);
        PlayerProxy playerProxy = new PlayerProxy(this.primaryEventListener);
        this.player.addListener(playerProxy.getExoListener());
    }

    public final void stop() {
        Handler handler = this.mMainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mMainHandler");
        }
        handler.sendEmptyMessageDelayed(CANCEL_MESSAGE, (long)UPDATE_INTERVAL);
        this.player.stop();
        this.updateToState(SimulcastPlaybackState.Stopped);
    }

    private final void getCurrentPlay() {
        Call<PlayResponse> call = this.mSimulcastApi.simulcastGetPlay("cid=" + this.clientId, this.token);
        call.enqueue((Callback)new Callback<PlayResponse>(this){
            final /* synthetic */ ExoSimulcastAudioPlayer this$0;

            public void onResponse(@NotNull Call<PlayResponse> call, @NotNull Response<PlayResponse> response) {
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter(response, (String)"response");
                        if (!response.isSuccessful()) break block4;
                        PlayResponse playResponse = (PlayResponse)response.body();
                        if (playResponse == null) break block5;
                        PlayResponse playResponse2 = playResponse;
                        boolean bl = false;
                        boolean bl2 = false;
                        PlayResponse it = playResponse2;
                        boolean bl3 = false;
                        PlayResponse playResponse3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)playResponse3, (String)"it");
                        if (playResponse3.isSuccess()) {
                            if (it.getPlay() != null) {
                                this.this$0.setCurrentPlay(it.getPlay());
                                ADLog.d$default(ExoSimulcastAudioPlayer.access$getLog$p(this.this$0), "Got new play " + this.this$0.getCurrentPlay(), null, 2, null);
                            } else {
                                ADLog.e$default(ExoSimulcastAudioPlayer.access$getLog$p(this.this$0), "Server did not return a play object", null, 2, null);
                            }
                        } else {
                            ADLog.e$default(ExoSimulcastAudioPlayer.access$getLog$p(this.this$0), "Server returned an error", null, 2, null);
                            ADLog aDLog = ExoSimulcastAudioPlayer.access$getLog$p(this.this$0);
                            String string = it.getError().toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.error.toString()");
                            ADLog.e$default(aDLog, string, null, 2, null);
                        }
                        break block5;
                    }
                    Object object = response.errorBody();
                    if (object == null || (object = object.string()) == null) break block5;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl4 = false;
                    Object it = object2;
                    boolean bl5 = false;
                    ADLog.e$default(ExoSimulcastAudioPlayer.access$getLog$p(this.this$0), it, null, 2, null);
                }
            }

            public void onFailure(@NotNull Call<PlayResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                ADLog aDLog = ExoSimulcastAudioPlayer.access$getLog$p(this.this$0);
                t.printStackTrace();
                ADLog.e$default(aDLog, Unit.INSTANCE, null, 2, null);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    @NotNull
    public final Looper getLooper() {
        return this.looper;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    public ExoSimulcastAudioPlayer(@NotNull Context mContext, @NotNull Looper looper, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.mContext = mContext;
        this.looper = looper;
        this.token = token;
        this.player = PlayerProxy.Companion.createSimpleExoplayer(this.mContext, this.looper);
        this.playerState = SimulcastPlaybackState.Idle;
        this.log = new ADLog("fm.feed.ExoSimulcastAudioPlayer");
        Object object = SimulcastApi.Companion.getRetrofit().create(SimulcastApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SimulcastApi.retrofit.cr\u2026SimulcastApi::class.java)");
        this.mSimulcastApi = (SimulcastApi)object;
        this.clientId = FeedSession.Companion.retrieveClientId(this.mContext);
        this.url = SimulcastApi.Companion.getRetrofit().baseUrl() + this.token;
        this.volume = 1.0f;
        this.primaryEventListener = new PlayerProxy.ExoEventListener(this){
            final /* synthetic */ ExoSimulcastAudioPlayer this$0;

            public void onLoadingChanged(boolean isLoading) {
            }

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                if (playWhenReady && playbackState == 3) {
                    ExoSimulcastAudioPlayer.access$getMMainHandler$p(this.this$0).sendEmptyMessageDelayed(ExoSimulcastAudioPlayer.access$getUPDATE_MESSAGE$cp(), (long)ExoSimulcastAudioPlayer.access$getUPDATE_INTERVAL$cp());
                    ExoSimulcastAudioPlayer.access$updateToState(this.this$0, SimulcastPlaybackState.Playing);
                    ExoSimulcastAudioPlayer.access$setErrorCount$p(this.this$0, 0);
                } else if (playbackState != 3) {
                    if (playbackState == 2) {
                        ExoSimulcastAudioPlayer.access$updateToState(this.this$0, SimulcastPlaybackState.Stalled);
                    } else if (playbackState == 1) {
                        ExoSimulcastAudioPlayer.access$updateToState(this.this$0, SimulcastPlaybackState.Stopped);
                    } else if (playbackState == 4) {
                        ExoSimulcastAudioPlayer.access$updateToState(this.this$0, SimulcastPlaybackState.Idle);
                    }
                }
            }

            public void onPlayerError(@Nullable ExoPlaybackException error) {
                block2: {
                    block1: {
                        if (error == null || ExoSimulcastAudioPlayer.access$getErrorCount$p(this.this$0) >= 3) break block1;
                        ADLog aDLog = ExoSimulcastAudioPlayer.access$getLog$p(this.this$0);
                        error.printStackTrace();
                        ADLog.e$default(aDLog, Unit.INSTANCE, null, 2, null);
                        this.this$0.play();
                        ExoSimulcastAudioPlayer exoSimulcastAudioPlayer = this.this$0;
                        int n = ExoSimulcastAudioPlayer.access$getErrorCount$p(exoSimulcastAudioPlayer);
                        ExoSimulcastAudioPlayer.access$setErrorCount$p(exoSimulcastAudioPlayer, n + 1);
                        break block2;
                    }
                    ExoPlaybackException exoPlaybackException = error;
                    if (exoPlaybackException == null) break block2;
                    ExoPlaybackException exoPlaybackException2 = exoPlaybackException;
                    boolean bl = false;
                    boolean bl2 = false;
                    ExoPlaybackException it = exoPlaybackException2;
                    boolean bl3 = false;
                    SimulcastEventListener simulcastEventListener = ExoSimulcastAudioPlayer.access$getEventListener$p(this.this$0);
                    if (simulcastEventListener != null) {
                        simulcastEventListener.onPlayerError((Exception)it);
                    }
                }
            }

            public void onSeekProcessed() {
            }
            {
                this.this$0 = this$0;
            }
        };
        this.updateToState(SimulcastPlaybackState.Idle);
        this.mMainHandler = new Handler(this.looper){

            public void handleMessage(@NotNull Message msg) {
                block1: {
                    int n;
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                        n = msg.what;
                        if (n != UPDATE_MESSAGE) break block0;
                        this.processUpdate();
                        this.removeMessages(UPDATE_MESSAGE);
                        this.sendEmptyMessageDelayed(UPDATE_MESSAGE, UPDATE_INTERVAL);
                        break block1;
                    }
                    if (n != CANCEL_MESSAGE) break block1;
                    this.removeMessages(UPDATE_MESSAGE);
                }
            }
        };
    }

    static {
        Companion = new Companion(null);
        UPDATE_MESSAGE = 1;
        CANCEL_MESSAGE = 2;
        UPDATE_INTERVAL = 500;
    }

    public static final /* synthetic */ ADLog access$getLog$p(ExoSimulcastAudioPlayer $this) {
        return $this.log;
    }

    public static final /* synthetic */ Handler access$getMMainHandler$p(ExoSimulcastAudioPlayer $this) {
        Handler handler = $this.mMainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mMainHandler");
        }
        return handler;
    }

    public static final /* synthetic */ void access$setMMainHandler$p(ExoSimulcastAudioPlayer $this, Handler handler) {
        $this.mMainHandler = handler;
    }

    public static final /* synthetic */ void access$updateToState(ExoSimulcastAudioPlayer $this, SimulcastPlaybackState state) {
        $this.updateToState(state);
    }

    public static final /* synthetic */ int access$getErrorCount$p(ExoSimulcastAudioPlayer $this) {
        return $this.errorCount;
    }

    public static final /* synthetic */ void access$setErrorCount$p(ExoSimulcastAudioPlayer $this, int n) {
        $this.errorCount = n;
    }

    public static final /* synthetic */ SimulcastEventListener access$getEventListener$p(ExoSimulcastAudioPlayer $this) {
        return $this.eventListener;
    }

    public static final /* synthetic */ void access$setEventListener$p(ExoSimulcastAudioPlayer $this, SimulcastEventListener simulcastEventListener) {
        $this.eventListener = simulcastEventListener;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adaptr/android/playersdk/ExoSimulcastAudioPlayer$Companion;", "", "()V", "CANCEL_MESSAGE", "", "UPDATE_INTERVAL", "UPDATE_MESSAGE", "PlayerSdk_exoDefaultRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

