/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid.util;

import com.activeandroid.util.IOUtils;
import com.activeandroid.util.Tokenizer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SqlParser {
    public static final int STATE_NONE = 0;
    public static final int STATE_STRING = 1;
    public static final int STATE_COMMENT = 2;
    public static final int STATE_COMMENT_BLOCK = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> parse(InputStream stream) throws IOException {
        BufferedInputStream buffer = new BufferedInputStream(stream);
        ArrayList<String> commands = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        try {
            Tokenizer tokenizer = new Tokenizer(buffer);
            int state = 0;
            while (tokenizer.hasNext()) {
                char c = (char)tokenizer.next();
                if (state == 3) {
                    if (!tokenizer.skip("*/")) continue;
                    state = 0;
                    continue;
                }
                if (state == 2) {
                    if (!SqlParser.isNewLine(c)) continue;
                    state = 0;
                    continue;
                }
                if (state == 0 && tokenizer.skip("/*")) {
                    state = 3;
                    continue;
                }
                if (state == 0 && tokenizer.skip("--")) {
                    state = 2;
                    continue;
                }
                if (state == 0 && c == ';') {
                    String command = sb.toString().trim();
                    commands.add(command);
                    sb.setLength(0);
                    continue;
                }
                if (state == 0 && c == '\'') {
                    state = 1;
                } else if (state == 1 && c == '\'') {
                    state = 0;
                }
                if (state != 0 && state != 1) continue;
                if (state == 0 && SqlParser.isWhitespace(c)) {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    sb.append(' ');
                    continue;
                }
                sb.append(c);
            }
        }
        finally {
            IOUtils.closeQuietly(buffer);
        }
        if (sb.length() > 0) {
            commands.add(sb.toString().trim());
        }
        return commands;
    }

    private static boolean isNewLine(char c) {
        return c == '\r' || c == '\n';
    }

    private static boolean isWhitespace(char c) {
        return c == '\r' || c == '\n' || c == '\t' || c == ' ';
    }
}

