/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid.util;

import android.database.Cursor;
import android.os.Build;
import android.text.TextUtils;
import com.activeandroid.Cache;
import com.activeandroid.Model;
import com.activeandroid.TableInfo;
import com.activeandroid.annotation.Column;
import com.activeandroid.serializer.TypeSerializer;
import com.activeandroid.util.Log;
import com.activeandroid.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SQLiteUtils {
    public static final boolean FOREIGN_KEYS_SUPPORTED = Build.VERSION.SDK_INT >= 8;
    private static final HashMap<Class<?>, SQLiteType> TYPE_MAP = new HashMap<Class<?>, SQLiteType>(){
        {
            this.put(Byte.TYPE, SQLiteType.INTEGER);
            this.put(Short.TYPE, SQLiteType.INTEGER);
            this.put(Integer.TYPE, SQLiteType.INTEGER);
            this.put(Long.TYPE, SQLiteType.INTEGER);
            this.put(Float.TYPE, SQLiteType.REAL);
            this.put(Double.TYPE, SQLiteType.REAL);
            this.put(Boolean.TYPE, SQLiteType.INTEGER);
            this.put(Character.TYPE, SQLiteType.TEXT);
            this.put(byte[].class, SQLiteType.BLOB);
            this.put(Byte.class, SQLiteType.INTEGER);
            this.put(Short.class, SQLiteType.INTEGER);
            this.put(Integer.class, SQLiteType.INTEGER);
            this.put(Long.class, SQLiteType.INTEGER);
            this.put(Float.class, SQLiteType.REAL);
            this.put(Double.class, SQLiteType.REAL);
            this.put(Boolean.class, SQLiteType.INTEGER);
            this.put(Character.class, SQLiteType.TEXT);
            this.put(String.class, SQLiteType.TEXT);
            this.put(Byte[].class, SQLiteType.BLOB);
        }
    };
    private static HashMap<String, List<String>> sIndexGroupMap;
    private static HashMap<String, List<String>> sUniqueGroupMap;
    private static HashMap<String, Column.ConflictAction> sOnUniqueConflictsMap;

    public static void execSql(String sql) {
        Cache.openDatabase().execSQL(sql);
    }

    public static void execSql(String sql, Object[] bindArgs) {
        Cache.openDatabase().execSQL(sql, bindArgs);
    }

    public static <T extends Model> List<T> rawQuery(Class<? extends Model> type, String sql, String[] selectionArgs) {
        Cursor cursor = Cache.openDatabase().rawQuery(sql, selectionArgs);
        List<T> entities = SQLiteUtils.processCursor(type, cursor);
        cursor.close();
        return entities;
    }

    public static int intQuery(String sql, String[] selectionArgs) {
        Cursor cursor = Cache.openDatabase().rawQuery(sql, selectionArgs);
        int number = SQLiteUtils.processIntCursor(cursor);
        cursor.close();
        return number;
    }

    public static <T extends Model> T rawQuerySingle(Class<? extends Model> type, String sql, String[] selectionArgs) {
        List<T> entities = SQLiteUtils.rawQuery(type, sql, selectionArgs);
        if (entities.size() > 0) {
            return (T)((Model)entities.get(0));
        }
        return null;
    }

    public static ArrayList<String> createUniqueDefinition(TableInfo tableInfo) {
        ArrayList<String> definitions = new ArrayList<String>();
        sUniqueGroupMap = new HashMap();
        sOnUniqueConflictsMap = new HashMap();
        for (Field field : tableInfo.getFields()) {
            SQLiteUtils.createUniqueColumnDefinition(tableInfo, field);
        }
        if (sUniqueGroupMap.isEmpty()) {
            return definitions;
        }
        Set<String> keySet = sUniqueGroupMap.keySet();
        for (String key : keySet) {
            List<String> group = sUniqueGroupMap.get(key);
            Column.ConflictAction conflictAction = sOnUniqueConflictsMap.get(key);
            definitions.add(String.format("UNIQUE (%s) ON CONFLICT %s", TextUtils.join((CharSequence)", ", group), conflictAction.toString()));
        }
        return definitions;
    }

    public static void createUniqueColumnDefinition(TableInfo tableInfo, Field field) {
        Column.ConflictAction[] conflictActions;
        String name = tableInfo.getColumnName(field);
        Column column = field.getAnnotation(Column.class);
        if (field.getName().equals("mId")) {
            return;
        }
        String[] groups = column.uniqueGroups();
        if (groups.length != (conflictActions = column.onUniqueConflicts()).length) {
            return;
        }
        for (int i = 0; i < groups.length; ++i) {
            String group = groups[i];
            Column.ConflictAction conflictAction = conflictActions[i];
            if (TextUtils.isEmpty((CharSequence)group)) continue;
            List<String> list = sUniqueGroupMap.get(group);
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(name);
            sUniqueGroupMap.put(group, list);
            sOnUniqueConflictsMap.put(group, conflictAction);
        }
    }

    public static String[] createIndexDefinition(TableInfo tableInfo) {
        ArrayList<String> definitions = new ArrayList<String>();
        sIndexGroupMap = new HashMap();
        for (Field field : tableInfo.getFields()) {
            SQLiteUtils.createIndexColumnDefinition(tableInfo, field);
        }
        if (sIndexGroupMap.isEmpty()) {
            return new String[0];
        }
        for (Map.Entry entry : sIndexGroupMap.entrySet()) {
            definitions.add(String.format("CREATE INDEX IF NOT EXISTS %s on %s(%s);", "index_" + tableInfo.getTableName() + "_" + (String)entry.getKey(), tableInfo.getTableName(), TextUtils.join((CharSequence)", ", (Iterable)((Iterable)entry.getValue()))));
        }
        return definitions.toArray(new String[definitions.size()]);
    }

    public static void createIndexColumnDefinition(TableInfo tableInfo, Field field) {
        String[] groups;
        String name = tableInfo.getColumnName(field);
        Column column = field.getAnnotation(Column.class);
        if (field.getName().equals("mId")) {
            return;
        }
        if (column.index()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(name);
            sIndexGroupMap.put(name, list);
        }
        for (String group : groups = column.indexGroups()) {
            if (TextUtils.isEmpty((CharSequence)group)) continue;
            List<String> list = sIndexGroupMap.get(group);
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(name);
            sIndexGroupMap.put(group, list);
        }
    }

    public static String createTableDefinition(TableInfo tableInfo) {
        ArrayList<String> definitions = new ArrayList<String>();
        for (Field field : tableInfo.getFields()) {
            String definition = SQLiteUtils.createColumnDefinition(tableInfo, field);
            if (TextUtils.isEmpty((CharSequence)definition)) continue;
            definitions.add(definition);
        }
        definitions.addAll(SQLiteUtils.createUniqueDefinition(tableInfo));
        return String.format("CREATE TABLE IF NOT EXISTS %s (%s);", tableInfo.getTableName(), TextUtils.join((CharSequence)", ", definitions));
    }

    public static String createColumnDefinition(TableInfo tableInfo, Field field) {
        StringBuilder definition = new StringBuilder();
        Class<?> type = field.getType();
        String name = tableInfo.getColumnName(field);
        TypeSerializer typeSerializer = Cache.getParserForType(field.getType());
        Column column = field.getAnnotation(Column.class);
        if (typeSerializer != null) {
            type = typeSerializer.getSerializedType();
        }
        if (TYPE_MAP.containsKey(type)) {
            definition.append(name);
            definition.append(" ");
            definition.append(TYPE_MAP.get(type).toString());
        } else if (ReflectionUtils.isModel(type)) {
            definition.append(name);
            definition.append(" ");
            definition.append(SQLiteType.INTEGER.toString());
        } else if (ReflectionUtils.isSubclassOf(type, Enum.class)) {
            definition.append(name);
            definition.append(" ");
            definition.append(SQLiteType.TEXT.toString());
        }
        if (!TextUtils.isEmpty((CharSequence)definition)) {
            if (name.equals(tableInfo.getIdName())) {
                definition.append(" PRIMARY KEY AUTOINCREMENT");
            } else if (column != null) {
                if (column.length() > -1) {
                    definition.append("(");
                    definition.append(column.length());
                    definition.append(")");
                }
                if (column.notNull()) {
                    definition.append(" NOT NULL ON CONFLICT ");
                    definition.append(column.onNullConflict().toString());
                }
                if (column.unique()) {
                    definition.append(" UNIQUE ON CONFLICT ");
                    definition.append(column.onUniqueConflict().toString());
                }
            }
            if (FOREIGN_KEYS_SUPPORTED && ReflectionUtils.isModel(type)) {
                definition.append(" REFERENCES ");
                definition.append(Cache.getTableInfo(type).getTableName());
                definition.append("(" + tableInfo.getIdName() + ")");
                definition.append(" ON DELETE ");
                definition.append(column.onDelete().toString().replace("_", " "));
                definition.append(" ON UPDATE ");
                definition.append(column.onUpdate().toString().replace("_", " "));
            }
        } else {
            Log.e("No type mapping for: " + type.toString());
        }
        return definition.toString();
    }

    public static <T extends Model> List<T> processCursor(Class<? extends Model> type, Cursor cursor) {
        TableInfo tableInfo = Cache.getTableInfo(type);
        String idName = tableInfo.getIdName();
        ArrayList<Model> entities = new ArrayList<Model>();
        try {
            Constructor<? extends Model> entityConstructor = type.getConstructor(new Class[0]);
            if (cursor.moveToFirst()) {
                ArrayList<String> columnsOrdered = new ArrayList<String>(Arrays.asList(cursor.getColumnNames()));
                do {
                    Model entity;
                    if ((entity = Cache.getEntity(type, cursor.getLong(columnsOrdered.indexOf(idName)))) == null) {
                        entity = entityConstructor.newInstance(new Object[0]);
                    }
                    entity.loadFromCursor(cursor);
                    entities.add(entity);
                } while (cursor.moveToNext());
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Your model " + type.getName() + " does not define a default " + "constructor. The default constructor is required for " + "now in ActiveAndroid models, as the process to " + "populate the ORM model is : " + "1. instantiate default model " + "2. populate fields");
        }
        catch (Exception e) {
            Log.e("Failed to process cursor.", e);
        }
        return entities;
    }

    private static int processIntCursor(Cursor cursor) {
        if (cursor.moveToFirst()) {
            return cursor.getInt(0);
        }
        return 0;
    }

    public static List<String> lexSqlScript(String sqlScript) {
        ArrayList<String> sl = new ArrayList<String>();
        boolean inString = false;
        boolean quoteNext = false;
        StringBuilder b = new StringBuilder(100);
        for (int i = 0; i < sqlScript.length(); ++i) {
            char c = sqlScript.charAt(i);
            if (c == ';' && !inString && !quoteNext) {
                sl.add(b.toString());
                b = new StringBuilder(100);
                inString = false;
                quoteNext = false;
                continue;
            }
            if (c == '\'' && !quoteNext) {
                inString = !inString;
            }
            quoteNext = c == '\\' && !quoteNext;
            b.append(c);
        }
        if (b.length() > 0) {
            sl.add(b.toString());
        }
        return sl;
    }

    public static enum SQLiteType {
        INTEGER,
        REAL,
        TEXT,
        BLOB;

    }
}

