/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid.query;

import com.activeandroid.query.Sqlable;
import com.activeandroid.query.Update;
import com.activeandroid.util.SQLiteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Set
implements Sqlable {
    private Update mUpdate;
    private String mSet;
    private String mWhere;
    private List<Object> mSetArguments;
    private List<Object> mWhereArguments;

    public Set(Update queryBase, String set) {
        this.mUpdate = queryBase;
        this.mSet = set;
        this.mSetArguments = new ArrayList<Object>();
        this.mWhereArguments = new ArrayList<Object>();
    }

    public Set(Update queryBase, String set, Object ... args) {
        this.mUpdate = queryBase;
        this.mSet = set;
        this.mSetArguments = new ArrayList<Object>();
        this.mWhereArguments = new ArrayList<Object>();
        this.mSetArguments.addAll(Arrays.asList(args));
    }

    public Set where(String where) {
        this.mWhere = where;
        this.mWhereArguments.clear();
        return this;
    }

    public Set where(String where, Object ... args) {
        this.mWhere = where;
        this.mWhereArguments.clear();
        this.mWhereArguments.addAll(Arrays.asList(args));
        return this;
    }

    @Override
    public String toSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.mUpdate.toSql());
        sql.append("SET ");
        sql.append(this.mSet);
        sql.append(" ");
        if (this.mWhere != null) {
            sql.append("WHERE ");
            sql.append(this.mWhere);
            sql.append(" ");
        }
        return sql.toString();
    }

    public void execute() {
        SQLiteUtils.execSql(this.toSql(), this.getArguments());
    }

    public String[] getArguments() {
        int i;
        int setSize = this.mSetArguments.size();
        int whereSize = this.mWhereArguments.size();
        String[] args = new String[setSize + whereSize];
        for (i = 0; i < setSize; ++i) {
            args[i] = this.mSetArguments.get(i).toString();
        }
        for (i = 0; i < whereSize; ++i) {
            args[i + setSize] = this.mWhereArguments.get(i).toString();
        }
        return args;
    }
}

