/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid.query;

import android.text.TextUtils;
import com.activeandroid.Model;
import com.activeandroid.query.From;
import com.activeandroid.query.Sqlable;

public final class Select
implements Sqlable {
    private String[] mColumns;
    private boolean mDistinct = false;
    private boolean mAll = false;

    public Select() {
    }

    public Select(String ... columns) {
        this.mColumns = columns;
    }

    public Select(Column ... columns) {
        int size = columns.length;
        this.mColumns = new String[size];
        for (int i = 0; i < size; ++i) {
            this.mColumns[i] = columns[i].name + " AS " + columns[i].alias;
        }
    }

    public Select distinct() {
        this.mDistinct = true;
        this.mAll = false;
        return this;
    }

    public Select all() {
        this.mDistinct = false;
        this.mAll = true;
        return this;
    }

    public From from(Class<? extends Model> table) {
        return new From(table, this);
    }

    @Override
    public String toSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        if (this.mDistinct) {
            sql.append("DISTINCT ");
        } else if (this.mAll) {
            sql.append("ALL ");
        }
        if (this.mColumns != null && this.mColumns.length > 0) {
            sql.append(TextUtils.join((CharSequence)", ", (Object[])this.mColumns) + " ");
        } else {
            sql.append("* ");
        }
        return sql.toString();
    }

    public static class Column {
        String name;
        String alias;

        public Column(String name, String alias) {
            this.name = name;
            this.alias = alias;
        }
    }
}

