/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid.query;

import android.text.TextUtils;
import com.activeandroid.Cache;
import com.activeandroid.Model;
import com.activeandroid.content.ContentProvider;
import com.activeandroid.query.Join;
import com.activeandroid.query.Select;
import com.activeandroid.query.Sqlable;
import com.activeandroid.util.Log;
import com.activeandroid.util.SQLiteUtils;
import java.util.ArrayList;
import java.util.List;

public final class From
implements Sqlable {
    private final StringBuilder mWhere = new StringBuilder();
    private Sqlable mQueryBase;
    private Class<? extends Model> mType;
    private String mAlias;
    private List<Join> mJoins;
    private String mGroupBy;
    private String mHaving;
    private String mOrderBy;
    private String mLimit;
    private String mOffset;
    private List<Object> mArguments;

    public From(Class<? extends Model> table, Sqlable queryBase) {
        this.mType = table;
        this.mJoins = new ArrayList<Join>();
        this.mQueryBase = queryBase;
        this.mJoins = new ArrayList<Join>();
        this.mArguments = new ArrayList<Object>();
    }

    public From as(String alias) {
        this.mAlias = alias;
        return this;
    }

    public Join join(Class<? extends Model> table) {
        Join join = new Join(this, table, null);
        this.mJoins.add(join);
        return join;
    }

    public Join leftJoin(Class<? extends Model> table) {
        Join join = new Join(this, table, Join.JoinType.LEFT);
        this.mJoins.add(join);
        return join;
    }

    public Join outerJoin(Class<? extends Model> table) {
        Join join = new Join(this, table, Join.JoinType.OUTER);
        this.mJoins.add(join);
        return join;
    }

    public Join innerJoin(Class<? extends Model> table) {
        Join join = new Join(this, table, Join.JoinType.INNER);
        this.mJoins.add(join);
        return join;
    }

    public Join crossJoin(Class<? extends Model> table) {
        Join join = new Join(this, table, Join.JoinType.CROSS);
        this.mJoins.add(join);
        return join;
    }

    public From where(String clause) {
        if (this.mWhere.length() > 0) {
            this.mWhere.append(" AND ");
        }
        this.mWhere.append(clause);
        return this;
    }

    public From where(String clause, Object ... args) {
        this.where(clause).addArguments(args);
        return this;
    }

    public From and(String clause) {
        return this.where(clause);
    }

    public From and(String clause, Object ... args) {
        return this.where(clause, args);
    }

    public From or(String clause) {
        if (this.mWhere.length() > 0) {
            this.mWhere.append(" OR ");
        }
        this.mWhere.append(clause);
        return this;
    }

    public From or(String clause, Object ... args) {
        this.or(clause).addArguments(args);
        return this;
    }

    public From groupBy(String groupBy) {
        this.mGroupBy = groupBy;
        return this;
    }

    public From having(String having) {
        this.mHaving = having;
        return this;
    }

    public From orderBy(String orderBy) {
        this.mOrderBy = orderBy;
        return this;
    }

    public From limit(int limit) {
        return this.limit(String.valueOf(limit));
    }

    public From limit(String limit) {
        this.mLimit = limit;
        return this;
    }

    public From offset(int offset) {
        return this.offset(String.valueOf(offset));
    }

    public From offset(String offset) {
        this.mOffset = offset;
        return this;
    }

    void addArguments(Object[] args) {
        for (Object arg : args) {
            if (arg.getClass() == Boolean.TYPE || arg.getClass() == Boolean.class) {
                arg = arg.equals(true) ? 1 : 0;
            }
            this.mArguments.add(arg);
        }
    }

    private void addFrom(StringBuilder sql) {
        sql.append("FROM ");
        sql.append(Cache.getTableName(this.mType)).append(" ");
        if (this.mAlias != null) {
            sql.append("AS ");
            sql.append(this.mAlias);
            sql.append(" ");
        }
    }

    private void addJoins(StringBuilder sql) {
        for (Join join : this.mJoins) {
            sql.append(join.toSql());
        }
    }

    private void addWhere(StringBuilder sql) {
        if (this.mWhere.length() > 0) {
            sql.append("WHERE ");
            sql.append((CharSequence)this.mWhere);
            sql.append(" ");
        }
    }

    private void addGroupBy(StringBuilder sql) {
        if (this.mGroupBy != null) {
            sql.append("GROUP BY ");
            sql.append(this.mGroupBy);
            sql.append(" ");
        }
    }

    private void addHaving(StringBuilder sql) {
        if (this.mHaving != null) {
            sql.append("HAVING ");
            sql.append(this.mHaving);
            sql.append(" ");
        }
    }

    private void addOrderBy(StringBuilder sql) {
        if (this.mOrderBy != null) {
            sql.append("ORDER BY ");
            sql.append(this.mOrderBy);
            sql.append(" ");
        }
    }

    private void addLimit(StringBuilder sql) {
        if (this.mLimit != null) {
            sql.append("LIMIT ");
            sql.append(this.mLimit);
            sql.append(" ");
        }
    }

    private void addOffset(StringBuilder sql) {
        if (this.mOffset != null) {
            sql.append("OFFSET ");
            sql.append(this.mOffset);
            sql.append(" ");
        }
    }

    private String sqlString(StringBuilder sql) {
        String sqlString = sql.toString().trim();
        if (Log.isEnabled()) {
            Log.v(sqlString + " " + TextUtils.join((CharSequence)",", (Object[])this.getArguments()));
        }
        return sqlString;
    }

    @Override
    public String toSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.mQueryBase.toSql());
        this.addFrom(sql);
        this.addJoins(sql);
        this.addWhere(sql);
        this.addGroupBy(sql);
        this.addHaving(sql);
        this.addOrderBy(sql);
        this.addLimit(sql);
        this.addOffset(sql);
        return this.sqlString(sql);
    }

    public String toExistsSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT EXISTS(SELECT 1 ");
        this.addFrom(sql);
        this.addJoins(sql);
        this.addWhere(sql);
        this.addGroupBy(sql);
        this.addHaving(sql);
        this.addLimit(sql);
        this.addOffset(sql);
        sql.append(")");
        return this.sqlString(sql);
    }

    public String toCountSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(*) ");
        this.addFrom(sql);
        this.addJoins(sql);
        this.addWhere(sql);
        this.addGroupBy(sql);
        this.addHaving(sql);
        this.addLimit(sql);
        this.addOffset(sql);
        return this.sqlString(sql);
    }

    public <T extends Model> List<T> execute() {
        if (this.mQueryBase instanceof Select) {
            return SQLiteUtils.rawQuery(this.mType, this.toSql(), this.getArguments());
        }
        SQLiteUtils.execSql(this.toSql(), this.getArguments());
        Cache.getContext().getContentResolver().notifyChange(ContentProvider.createUri(this.mType, null), null);
        return null;
    }

    public <T extends Model> T executeSingle() {
        if (this.mQueryBase instanceof Select) {
            this.limit(1);
            return SQLiteUtils.rawQuerySingle(this.mType, this.toSql(), this.getArguments());
        }
        this.limit(1);
        ((Model)SQLiteUtils.rawQuerySingle(this.mType, this.toSql(), this.getArguments())).delete();
        return null;
    }

    public boolean exists() {
        return SQLiteUtils.intQuery(this.toExistsSql(), this.getArguments()) != 0;
    }

    public int count() {
        return SQLiteUtils.intQuery(this.toCountSql(), this.getArguments());
    }

    public String[] getArguments() {
        int size = this.mArguments.size();
        String[] args = new String[size];
        for (int i = 0; i < size; ++i) {
            args[i] = this.mArguments.get(i).toString();
        }
        return args;
    }
}

