/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid.content;

import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.util.SparseArray;
import com.activeandroid.ActiveAndroid;
import com.activeandroid.Cache;
import com.activeandroid.Configuration;
import com.activeandroid.Model;
import com.activeandroid.TableInfo;
import java.util.ArrayList;

public class ContentProvider
extends android.content.ContentProvider {
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static final SparseArray<Class<? extends Model>> TYPE_CODES = new SparseArray();
    private static String sAuthority;
    private static SparseArray<String> sMimeTypeCache;

    public static Uri createUri(Class<? extends Model> type, Long id) {
        StringBuilder uri = new StringBuilder();
        uri.append("content://");
        uri.append(sAuthority);
        uri.append("/");
        uri.append(Cache.getTableName(type).toLowerCase());
        if (id != null) {
            uri.append("/");
            uri.append(id.toString());
        }
        return Uri.parse((String)uri.toString());
    }

    public boolean onCreate() {
        ActiveAndroid.initialize(this.getConfiguration());
        sAuthority = this.getAuthority();
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>(Cache.getTableInfos());
        int size = tableInfos.size();
        for (int i = 0; i < size; ++i) {
            TableInfo tableInfo = (TableInfo)tableInfos.get(i);
            int tableKey = i * 2 + 1;
            int itemKey = i * 2 + 2;
            URI_MATCHER.addURI(sAuthority, tableInfo.getTableName().toLowerCase(), tableKey);
            TYPE_CODES.put(tableKey, tableInfo.getType());
            URI_MATCHER.addURI(sAuthority, tableInfo.getTableName().toLowerCase() + "/#", itemKey);
            TYPE_CODES.put(itemKey, tableInfo.getType());
        }
        return true;
    }

    public String getType(Uri uri) {
        int match = URI_MATCHER.match(uri);
        String cachedMimeType = (String)sMimeTypeCache.get(match);
        if (cachedMimeType != null) {
            return cachedMimeType;
        }
        Class<? extends Model> type = this.getModelType(uri);
        boolean single = match % 2 == 0;
        StringBuilder mimeType = new StringBuilder();
        mimeType.append("vnd");
        mimeType.append("");
        mimeType.append(sAuthority);
        mimeType.append("");
        mimeType.append(single ? "item" : "dir");
        mimeType.append("/");
        mimeType.append("vnd");
        mimeType.append("");
        mimeType.append(sAuthority);
        mimeType.append("");
        mimeType.append(Cache.getTableName(type));
        sMimeTypeCache.append(match, (Object)mimeType.toString());
        return mimeType.toString();
    }

    public Uri insert(Uri uri, ContentValues values) {
        Class<? extends Model> type = this.getModelType(uri);
        Long id = Cache.openDatabase().insert(Cache.getTableName(type), null, values);
        if (id != null && id > 0L) {
            Uri retUri = ContentProvider.createUri(type, id);
            this.notifyChange(retUri);
            return retUri;
        }
        return null;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        Class<? extends Model> type = this.getModelType(uri);
        int count = Cache.openDatabase().update(Cache.getTableName(type), values, selection, selectionArgs);
        this.notifyChange(uri);
        return count;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        Class<? extends Model> type = this.getModelType(uri);
        int count = Cache.openDatabase().delete(Cache.getTableName(type), selection, selectionArgs);
        this.notifyChange(uri);
        return count;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Class<? extends Model> type = this.getModelType(uri);
        Cursor cursor = Cache.openDatabase().query(Cache.getTableName(type), projection, selection, selectionArgs, null, null, sortOrder);
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    protected String getAuthority() {
        return this.getContext().getPackageName();
    }

    protected Configuration getConfiguration() {
        return new Configuration.Builder(this.getContext()).create();
    }

    private Class<? extends Model> getModelType(Uri uri) {
        int code = URI_MATCHER.match(uri);
        if (code != -1) {
            return (Class)TYPE_CODES.get(code);
        }
        return null;
    }

    private void notifyChange(Uri uri) {
        this.getContext().getContentResolver().notifyChange(uri, null);
    }

    static {
        sMimeTypeCache = new SparseArray();
    }
}

