/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid;

import android.text.TextUtils;
import android.util.Log;
import com.activeandroid.Model;
import com.activeandroid.annotation.Column;
import com.activeandroid.annotation.Table;
import com.activeandroid.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public final class TableInfo {
    private Class<? extends Model> mType;
    private String mTableName;
    private String mIdName = "Id";
    private Map<Field, String> mColumnNames = new LinkedHashMap<Field, String>();

    public TableInfo(Class<? extends Model> type) {
        this.mType = type;
        Table tableAnnotation = type.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            this.mTableName = tableAnnotation.name();
            this.mIdName = tableAnnotation.id();
        } else {
            this.mTableName = type.getSimpleName();
        }
        Field idField = this.getIdField(type);
        this.mColumnNames.put(idField, this.mIdName);
        LinkedList<Field> fields = new LinkedList<Field>(ReflectionUtils.getDeclaredColumnFields(type));
        Collections.reverse(fields);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            Column columnAnnotation = field.getAnnotation(Column.class);
            String columnName = columnAnnotation.name();
            if (TextUtils.isEmpty((CharSequence)columnName)) {
                columnName = field.getName();
            }
            this.mColumnNames.put(field, columnName);
        }
    }

    public Class<? extends Model> getType() {
        return this.mType;
    }

    public String getTableName() {
        return this.mTableName;
    }

    public String getIdName() {
        return this.mIdName;
    }

    public Collection<Field> getFields() {
        return this.mColumnNames.keySet();
    }

    public String getColumnName(Field field) {
        return this.mColumnNames.get(field);
    }

    private Field getIdField(Class<?> type) {
        if (type.equals(Model.class)) {
            try {
                return type.getDeclaredField("mId");
            }
            catch (NoSuchFieldException e) {
                Log.e((String)"Impossible!", (String)e.toString());
            }
        } else if (type.getSuperclass() != null) {
            return this.getIdField(type.getSuperclass());
        }
        return null;
    }
}

