/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid;

import android.content.Context;
import com.activeandroid.Configuration;
import com.activeandroid.Model;
import com.activeandroid.TableInfo;
import com.activeandroid.serializer.CalendarSerializer;
import com.activeandroid.serializer.FileSerializer;
import com.activeandroid.serializer.SqlDateSerializer;
import com.activeandroid.serializer.TypeSerializer;
import com.activeandroid.serializer.UtilDateSerializer;
import com.activeandroid.util.Log;
import com.activeandroid.util.ReflectionUtils;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ModelInfo {
    private Map<Class<? extends Model>, TableInfo> mTableInfos = new HashMap<Class<? extends Model>, TableInfo>();
    private Map<Class<?>, TypeSerializer> mTypeSerializers = new HashMap<Class<?>, TypeSerializer>(){
        {
            this.put(Calendar.class, new CalendarSerializer());
            this.put(Date.class, new SqlDateSerializer());
            this.put(java.util.Date.class, new UtilDateSerializer());
            this.put(File.class, new FileSerializer());
        }
    };

    public ModelInfo(Configuration configuration) {
        if (!this.loadModelFromMetaData(configuration)) {
            try {
                this.scanForModel(configuration.getContext());
            }
            catch (IOException e) {
                Log.e("Couldn't open source path.", e);
            }
        }
        Log.i("ModelInfo loaded.");
    }

    public Collection<TableInfo> getTableInfos() {
        return this.mTableInfos.values();
    }

    public TableInfo getTableInfo(Class<? extends Model> type) {
        return this.mTableInfos.get(type);
    }

    public TypeSerializer getTypeSerializer(Class<?> type) {
        return this.mTypeSerializers.get(type);
    }

    private boolean loadModelFromMetaData(Configuration configuration) {
        List<Class<? extends TypeSerializer>> typeSerializers;
        if (!configuration.isValid()) {
            return false;
        }
        List<Class<? extends Model>> models = configuration.getModelClasses();
        if (models != null) {
            for (Class<? extends Model> model : models) {
                this.mTableInfos.put(model, new TableInfo(model));
            }
        }
        if ((typeSerializers = configuration.getTypeSerializers()) != null) {
            for (Class<? extends TypeSerializer> typeSerializer : typeSerializers) {
                try {
                    TypeSerializer instance = typeSerializer.newInstance();
                    this.mTypeSerializers.put(instance.getDeserializedType(), instance);
                }
                catch (InstantiationException e) {
                    Log.e("Couldn't instantiate TypeSerializer.", e);
                }
                catch (IllegalAccessException e) {
                    Log.e("IllegalAccessException", e);
                }
            }
        }
        return true;
    }

    private void scanForModel(Context context) throws IOException {
        String packageName = context.getPackageName();
        String sourcePath = context.getApplicationInfo().sourceDir;
        ArrayList paths = new ArrayList();
        if (sourcePath != null && !new File(sourcePath).isDirectory()) {
            DexFile dexfile = new DexFile(sourcePath);
            Enumeration entries = dexfile.entries();
            while (entries.hasMoreElements()) {
                paths.add(entries.nextElement());
            }
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = classLoader.getResources("");
            while (resources.hasMoreElements()) {
                String path = resources.nextElement().getFile();
                if (!path.contains("bin") && !path.contains("classes")) continue;
                paths.add(path);
            }
        }
        for (String path : paths) {
            File file = new File(path);
            this.scanForModelClasses(file, packageName, context.getClassLoader());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanForModelClasses(File path, String packageName, ClassLoader classLoader) {
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                this.scanForModelClasses(file, packageName, classLoader);
            }
            return;
        } else {
            String className = path.getName();
            if (!path.getPath().equals(className)) {
                className = path.getPath();
                if (!className.endsWith(".class")) {
                    return;
                }
                className = className.substring(0, className.length() - 6);
                className = className.replace(System.getProperty("file.separator"), "");
                int packageNameIndex = className.lastIndexOf(packageName);
                if (packageNameIndex < 0) {
                    return;
                }
                className = className.substring(packageNameIndex);
            }
            try {
                Class<?> discoveredClass = Class.forName(className, false, classLoader);
                if (ReflectionUtils.isModel(discoveredClass)) {
                    Class<?> modelClass = discoveredClass;
                    this.mTableInfos.put(modelClass, new TableInfo(modelClass));
                    return;
                }
                if (!ReflectionUtils.isTypeSerializer(discoveredClass)) return;
                TypeSerializer instance = (TypeSerializer)discoveredClass.newInstance();
                this.mTypeSerializers.put(instance.getDeserializedType(), instance);
                return;
            }
            catch (ClassNotFoundException e) {
                Log.e("Couldn't create class.", e);
                return;
            }
            catch (InstantiationException e) {
                Log.e("Couldn't instantiate TypeSerializer.", e);
                return;
            }
            catch (IllegalAccessException e) {
                Log.e("IllegalAccessException", e);
            }
        }
    }
}

