/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.activeandroid.Cache;
import com.activeandroid.TableInfo;
import com.activeandroid.content.ContentProvider;
import com.activeandroid.query.Delete;
import com.activeandroid.query.Select;
import com.activeandroid.serializer.TypeSerializer;
import com.activeandroid.util.Log;
import com.activeandroid.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class Model {
    private static final int HASH_PRIME = 739;
    private final TableInfo mTableInfo = Cache.getTableInfo(this.getClass());
    private final String idName = this.mTableInfo.getIdName();
    private Long mId = null;

    public static void delete(Class<? extends Model> type, long id) {
        TableInfo tableInfo = Cache.getTableInfo(type);
        new Delete().from(type).where(tableInfo.getIdName() + "=?", id).execute();
    }

    public static <T extends Model> T load(Class<T> type, long id) {
        TableInfo tableInfo = Cache.getTableInfo(type);
        return new Select().from(type).where(tableInfo.getIdName() + "=?", id).executeSingle();
    }

    public final Long getId() {
        return this.mId;
    }

    public final void delete() {
        Cache.openDatabase().delete(this.mTableInfo.getTableName(), this.idName + "=?", new String[]{this.getId().toString()});
        Cache.removeEntity(this);
        Cache.getContext().getContentResolver().notifyChange(ContentProvider.createUri(this.mTableInfo.getType(), this.mId), null);
    }

    public final Long save() {
        SQLiteDatabase db = Cache.openDatabase();
        ContentValues values = new ContentValues();
        for (Field field : this.mTableInfo.getFields()) {
            String fieldName = this.mTableInfo.getColumnName(field);
            Class<?> fieldType = field.getType();
            field.setAccessible(true);
            try {
                TypeSerializer typeSerializer;
                Object value = field.get(this);
                if (value != null && (typeSerializer = Cache.getParserForType(fieldType)) != null && (value = typeSerializer.serialize(value)) != null && !(fieldType = value.getClass()).equals(typeSerializer.getSerializedType())) {
                    Log.w(String.format("TypeSerializer returned wrong type: expected a %s but got a %s", typeSerializer.getSerializedType(), fieldType));
                }
                if (value == null) {
                    values.putNull(fieldName);
                    continue;
                }
                if (fieldType.equals(Byte.class) || fieldType.equals(Byte.TYPE)) {
                    values.put(fieldName, (Byte)value);
                    continue;
                }
                if (fieldType.equals(Short.class) || fieldType.equals(Short.TYPE)) {
                    values.put(fieldName, (Short)value);
                    continue;
                }
                if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                    values.put(fieldName, (Integer)value);
                    continue;
                }
                if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                    values.put(fieldName, (Long)value);
                    continue;
                }
                if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
                    values.put(fieldName, (Float)value);
                    continue;
                }
                if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                    values.put(fieldName, (Double)value);
                    continue;
                }
                if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                    values.put(fieldName, (Boolean)value);
                    continue;
                }
                if (fieldType.equals(Character.class) || fieldType.equals(Character.TYPE)) {
                    values.put(fieldName, value.toString());
                    continue;
                }
                if (fieldType.equals(String.class)) {
                    values.put(fieldName, value.toString());
                    continue;
                }
                if (fieldType.equals(Byte[].class) || fieldType.equals(byte[].class)) {
                    values.put(fieldName, (byte[])value);
                    continue;
                }
                if (ReflectionUtils.isModel(fieldType)) {
                    values.put(fieldName, ((Model)value).getId());
                    continue;
                }
                if (!ReflectionUtils.isSubclassOf(fieldType, Enum.class)) continue;
                values.put(fieldName, ((Enum)value).name());
            }
            catch (IllegalArgumentException e) {
                Log.e(e.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                Log.e(e.getClass().getName(), e);
            }
        }
        if (this.mId == null) {
            this.mId = db.insert(this.mTableInfo.getTableName(), null, values);
        } else {
            db.update(this.mTableInfo.getTableName(), values, this.idName + "=" + this.mId, null);
        }
        Cache.getContext().getContentResolver().notifyChange(ContentProvider.createUri(this.mTableInfo.getType(), this.mId), null);
        return this.mId;
    }

    public final void loadFromCursor(Cursor cursor) {
        ArrayList<String> columnsOrdered = new ArrayList<String>(Arrays.asList(cursor.getColumnNames()));
        for (Field field : this.mTableInfo.getFields()) {
            String fieldName = this.mTableInfo.getColumnName(field);
            Class<?> fieldType = field.getType();
            int columnIndex = columnsOrdered.indexOf(fieldName);
            if (columnIndex < 0) continue;
            field.setAccessible(true);
            try {
                boolean columnIsNull = cursor.isNull(columnIndex);
                TypeSerializer typeSerializer = Cache.getParserForType(fieldType);
                Object value = null;
                if (typeSerializer != null) {
                    fieldType = typeSerializer.getSerializedType();
                }
                if (columnIsNull) {
                    field = null;
                } else if (fieldType.equals(Byte.class) || fieldType.equals(Byte.TYPE)) {
                    value = cursor.getInt(columnIndex);
                } else if (fieldType.equals(Short.class) || fieldType.equals(Short.TYPE)) {
                    value = cursor.getInt(columnIndex);
                } else if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                    value = cursor.getInt(columnIndex);
                } else if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                    value = cursor.getLong(columnIndex);
                } else if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
                    value = Float.valueOf(cursor.getFloat(columnIndex));
                } else if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                    value = cursor.getDouble(columnIndex);
                } else if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                    value = cursor.getInt(columnIndex) != 0;
                } else if (fieldType.equals(Character.class) || fieldType.equals(Character.TYPE)) {
                    value = Character.valueOf(cursor.getString(columnIndex).charAt(0));
                } else if (fieldType.equals(String.class)) {
                    value = cursor.getString(columnIndex);
                } else if (fieldType.equals(Byte[].class) || fieldType.equals(byte[].class)) {
                    value = cursor.getBlob(columnIndex);
                } else if (ReflectionUtils.isModel(fieldType)) {
                    Class<?> entityType = fieldType;
                    long entityId = cursor.getLong(columnIndex);
                    Model entity = Cache.getEntity(entityType, entityId);
                    if (entity == null) {
                        entity = new Select().from(entityType).where(this.idName + "=?", entityId).executeSingle();
                    }
                    value = entity;
                } else if (ReflectionUtils.isSubclassOf(fieldType, Enum.class)) {
                    Class<?> enumType = fieldType;
                    value = Enum.valueOf(enumType, cursor.getString(columnIndex));
                }
                if (typeSerializer != null && !columnIsNull) {
                    value = typeSerializer.deserialize(value);
                }
                if (value == null) continue;
                field.set(this, value);
            }
            catch (IllegalArgumentException e) {
                Log.e(e.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                Log.e(e.getClass().getName(), e);
            }
            catch (SecurityException e) {
                Log.e(e.getClass().getName(), e);
            }
        }
        if (this.mId != null) {
            Cache.addEntity(this);
        }
    }

    protected final <T extends Model> List<T> getMany(Class<T> type, String foreignKey) {
        return new Select().from(type).where(Cache.getTableName(type) + "" + foreignKey + "=?", this.getId()).execute();
    }

    public String toString() {
        return this.mTableInfo.getTableName() + "@" + this.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Model && this.mId != null) {
            Model other = (Model)obj;
            return this.mId.equals(other.mId) && this.mTableInfo.getTableName().equals(other.mTableInfo.getTableName());
        }
        return this == obj;
    }

    public int hashCode() {
        int hash = 739;
        hash += 739 * (this.mId == null ? super.hashCode() : this.mId.hashCode());
        return hash += 739 * this.mTableInfo.getTableName().hashCode();
    }
}

