/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import com.activeandroid.Cache;
import com.activeandroid.Configuration;
import com.activeandroid.TableInfo;
import com.activeandroid.util.IOUtils;
import com.activeandroid.util.Log;
import com.activeandroid.util.NaturalOrderComparator;
import com.activeandroid.util.SQLiteUtils;
import com.activeandroid.util.SqlParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DatabaseHelper
extends SQLiteOpenHelper {
    public static final String MIGRATION_PATH = "migrations";
    private final String mSqlParser;

    public DatabaseHelper(Configuration configuration) {
        super(configuration.getContext(), configuration.getDatabaseName(), null, configuration.getDatabaseVersion());
        this.copyAttachedDatabase(configuration.getContext(), configuration.getDatabaseName());
        this.mSqlParser = configuration.getSqlParser();
    }

    public void onOpen(SQLiteDatabase db) {
        this.executePragmas(db);
    }

    public void onConfigure(SQLiteDatabase db) {
        db.enableWriteAheadLogging();
        db.setForeignKeyConstraintsEnabled(true);
        db.setMaxSqlCacheSize(100);
        this.executePragmas(db);
    }

    public void onCreate(SQLiteDatabase db) {
        this.executePragmas(db);
        this.executeCreate(db);
        this.executeMigrations(db, -1, db.getVersion());
        this.executeCreateIndex(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.executePragmas(db);
        this.executeCreate(db);
        this.executeMigrations(db, oldVersion, newVersion);
    }

    public void copyAttachedDatabase(Context context, String databaseName) {
        File dbPath = context.getDatabasePath(databaseName);
        if (dbPath.exists()) {
            return;
        }
        dbPath.getParentFile().mkdirs();
        try {
            int length;
            InputStream inputStream = context.getAssets().open(databaseName);
            FileOutputStream output = new FileOutputStream(dbPath);
            byte[] buffer = new byte[8192];
            while ((length = inputStream.read(buffer, 0, 8192)) > 0) {
                ((OutputStream)output).write(buffer, 0, length);
            }
            output.flush();
            ((OutputStream)output).close();
            inputStream.close();
        }
        catch (IOException e) {
            Log.e("Failed to open file", e);
        }
    }

    private void executePragmas(SQLiteDatabase db) {
        if (SQLiteUtils.FOREIGN_KEYS_SUPPORTED) {
            db.execSQL("PRAGMA foreign_keys=ON;");
            Log.i("Foreign Keys supported. Enabling foreign key features.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCreateIndex(SQLiteDatabase db) {
        db.beginTransaction();
        try {
            for (TableInfo tableInfo : Cache.getTableInfos()) {
                String[] definitions;
                for (String definition : definitions = SQLiteUtils.createIndexDefinition(tableInfo)) {
                    db.execSQL(definition);
                }
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCreate(SQLiteDatabase db) {
        db.beginTransaction();
        try {
            for (TableInfo tableInfo : Cache.getTableInfos()) {
                db.execSQL(SQLiteUtils.createTableDefinition(tableInfo));
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeMigrations(SQLiteDatabase db, int oldVersion, int newVersion) {
        boolean migrationExecuted = false;
        try {
            List<String> files = Arrays.asList(Cache.getContext().getAssets().list(MIGRATION_PATH));
            Collections.sort(files, new NaturalOrderComparator());
            db.beginTransaction();
            try {
                for (String file : files) {
                    try {
                        int version = Integer.valueOf(file.replace(".sql", ""));
                        if (version <= oldVersion || version > newVersion) continue;
                        this.executeSqlScript(db, file);
                        migrationExecuted = true;
                        Log.i(file + " executed succesfully.");
                    }
                    catch (NumberFormatException e) {
                        Log.w("Skipping invalidly named file: " + file, e);
                    }
                }
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }
        catch (IOException e) {
            Log.e("Failed to execute migrations.", e);
        }
        return migrationExecuted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSqlScript(SQLiteDatabase db, String file) {
        InputStream stream;
        block5: {
            stream = null;
            try {
                stream = Cache.getContext().getAssets().open("migrations/" + file);
                if ("delimited".equalsIgnoreCase(this.mSqlParser)) {
                    this.executeDelimitedSqlScript(db, stream);
                    break block5;
                }
                this.executeLegacySqlScript(db, stream);
            }
            catch (IOException e) {
                try {
                    Log.e("Failed to execute " + file, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly(stream);
            }
        }
        IOUtils.closeQuietly(stream);
    }

    private void executeDelimitedSqlScript(SQLiteDatabase db, InputStream stream) throws IOException {
        List<String> commands = SqlParser.parse(stream);
        for (String command : commands) {
            db.execSQL(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLegacySqlScript(SQLiteDatabase db, InputStream stream) throws IOException {
        InputStreamReader reader = null;
        BufferedReader buffer = null;
        try {
            reader = new InputStreamReader(stream);
            buffer = new BufferedReader(reader);
            String line = null;
            while ((line = buffer.readLine()) != null) {
                if (TextUtils.isEmpty((CharSequence)(line = line.replace(";", "").trim()))) continue;
                db.execSQL(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(buffer);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(buffer);
        IOUtils.closeQuietly(reader);
    }
}

