/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid;

import android.content.Context;
import com.activeandroid.Model;
import com.activeandroid.serializer.TypeSerializer;
import com.activeandroid.util.Log;
import com.activeandroid.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Configuration {
    public static final String SQL_PARSER_LEGACY = "legacy";
    public static final String SQL_PARSER_DELIMITED = "delimited";
    public static final int MAX_SQL_CACHE_SIZE = 100;
    private Context mContext;
    private String mDatabaseName;
    private int mDatabaseVersion;
    private String mSqlParser;
    private List<Class<? extends Model>> mModelClasses;
    private List<Class<? extends TypeSerializer>> mTypeSerializers;
    private int mCacheSize;

    private Configuration(Context context) {
        this.mContext = context;
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getDatabaseName() {
        return this.mDatabaseName;
    }

    public int getDatabaseVersion() {
        return this.mDatabaseVersion;
    }

    public String getSqlParser() {
        return this.mSqlParser;
    }

    public List<Class<? extends Model>> getModelClasses() {
        return this.mModelClasses;
    }

    public List<Class<? extends TypeSerializer>> getTypeSerializers() {
        return this.mTypeSerializers;
    }

    public int getCacheSize() {
        return this.mCacheSize;
    }

    public boolean isValid() {
        return this.mModelClasses != null && this.mModelClasses.size() > 0;
    }

    public static class Builder {
        private static final String AA_DB_NAME = "AA_DB_NAME";
        private static final String AA_DB_VERSION = "AA_DB_VERSION";
        private static final String AA_MODELS = "AA_MODELS";
        private static final String AA_SERIALIZERS = "AA_SERIALIZERS";
        private static final String AA_SQL_PARSER = "AA_SQL_PARSER";
        private static final int DEFAULT_CACHE_SIZE = 1024;
        private static final String DEFAULT_DB_NAME = "Application.db";
        private static final String DEFAULT_SQL_PARSER = "legacy";
        private Context mContext;
        private Integer mCacheSize;
        private String mDatabaseName;
        private Integer mDatabaseVersion;
        private String mSqlParser;
        private List<Class<? extends Model>> mModelClasses;
        private List<Class<? extends TypeSerializer>> mTypeSerializers;

        public Builder(Context context) {
            this.mContext = context.getApplicationContext();
            this.mCacheSize = 1024;
        }

        public Builder setCacheSize(int cacheSize) {
            this.mCacheSize = cacheSize;
            return this;
        }

        public Builder setDatabaseName(String databaseName) {
            this.mDatabaseName = databaseName;
            return this;
        }

        public Builder setDatabaseVersion(int databaseVersion) {
            this.mDatabaseVersion = databaseVersion;
            return this;
        }

        public Builder setSqlParser(String sqlParser) {
            this.mSqlParser = sqlParser;
            return this;
        }

        public Builder addModelClass(Class<? extends Model> modelClass) {
            if (this.mModelClasses == null) {
                this.mModelClasses = new ArrayList<Class<? extends Model>>();
            }
            this.mModelClasses.add(modelClass);
            return this;
        }

        public Builder addModelClasses(Class<? extends Model> ... modelClasses) {
            if (this.mModelClasses == null) {
                this.mModelClasses = new ArrayList<Class<? extends Model>>();
            }
            this.mModelClasses.addAll(Arrays.asList(modelClasses));
            return this;
        }

        public Builder setModelClasses(Class<? extends Model> ... modelClasses) {
            this.mModelClasses = Arrays.asList(modelClasses);
            return this;
        }

        public Builder addTypeSerializer(Class<? extends TypeSerializer> typeSerializer) {
            if (this.mTypeSerializers == null) {
                this.mTypeSerializers = new ArrayList<Class<? extends TypeSerializer>>();
            }
            this.mTypeSerializers.add(typeSerializer);
            return this;
        }

        public Builder addTypeSerializers(Class<? extends TypeSerializer> ... typeSerializers) {
            if (this.mTypeSerializers == null) {
                this.mTypeSerializers = new ArrayList<Class<? extends TypeSerializer>>();
            }
            this.mTypeSerializers.addAll(Arrays.asList(typeSerializers));
            return this;
        }

        public Builder setTypeSerializers(Class<? extends TypeSerializer> ... typeSerializers) {
            this.mTypeSerializers = Arrays.asList(typeSerializers);
            return this;
        }

        public Configuration create() {
            Configuration configuration = new Configuration(this.mContext);
            configuration.mCacheSize = this.mCacheSize;
            if (this.mDatabaseName != null) {
                configuration.mDatabaseName = this.mDatabaseName;
            } else {
                configuration.mDatabaseName = this.getMetaDataDatabaseNameOrDefault();
            }
            if (this.mDatabaseVersion != null) {
                configuration.mDatabaseVersion = this.mDatabaseVersion;
            } else {
                configuration.mDatabaseVersion = this.getMetaDataDatabaseVersionOrDefault();
            }
            if (this.mSqlParser != null) {
                configuration.mSqlParser = this.mSqlParser;
            } else {
                configuration.mSqlParser = this.getMetaDataSqlParserOrDefault();
            }
            if (this.mModelClasses != null) {
                configuration.mModelClasses = this.mModelClasses;
            } else {
                String modelList = (String)ReflectionUtils.getMetaData(this.mContext, AA_MODELS);
                if (modelList != null) {
                    configuration.mModelClasses = this.loadModelList(modelList.split(","));
                }
            }
            if (this.mTypeSerializers != null) {
                configuration.mTypeSerializers = this.mTypeSerializers;
            } else {
                String serializerList = (String)ReflectionUtils.getMetaData(this.mContext, AA_SERIALIZERS);
                if (serializerList != null) {
                    configuration.mTypeSerializers = this.loadSerializerList(serializerList.split(","));
                }
            }
            return configuration;
        }

        private String getMetaDataDatabaseNameOrDefault() {
            String aaName = (String)ReflectionUtils.getMetaData(this.mContext, AA_DB_NAME);
            if (aaName == null) {
                aaName = DEFAULT_DB_NAME;
            }
            return aaName;
        }

        private int getMetaDataDatabaseVersionOrDefault() {
            Integer aaVersion = (Integer)ReflectionUtils.getMetaData(this.mContext, AA_DB_VERSION);
            if (aaVersion == null || aaVersion == 0) {
                aaVersion = 1;
            }
            return aaVersion;
        }

        private String getMetaDataSqlParserOrDefault() {
            String mode = (String)ReflectionUtils.getMetaData(this.mContext, AA_SQL_PARSER);
            if (mode == null) {
                return "legacy";
            }
            return mode;
        }

        private List<Class<? extends Model>> loadModelList(String[] models) {
            ArrayList<Class<? extends Model>> modelClasses = new ArrayList<Class<? extends Model>>();
            ClassLoader classLoader = this.mContext.getClass().getClassLoader();
            for (String model : models) {
                try {
                    Class<?> modelClass = Class.forName(model.trim(), false, classLoader);
                    if (!ReflectionUtils.isModel(modelClass)) continue;
                    modelClasses.add(modelClass);
                }
                catch (ClassNotFoundException e) {
                    Log.e("Couldn't create class.", e);
                }
            }
            return modelClasses;
        }

        private List<Class<? extends TypeSerializer>> loadSerializerList(String[] serializers) {
            ArrayList<Class<? extends TypeSerializer>> typeSerializers = new ArrayList<Class<? extends TypeSerializer>>();
            ClassLoader classLoader = this.mContext.getClass().getClassLoader();
            for (String serializer : serializers) {
                try {
                    Class<?> serializerClass = Class.forName(serializer.trim(), false, classLoader);
                    if (!ReflectionUtils.isTypeSerializer(serializerClass)) continue;
                    typeSerializers.add(serializerClass);
                }
                catch (ClassNotFoundException e) {
                    Log.e("Couldn't create class.", e);
                }
            }
            return typeSerializers;
        }
    }
}

