/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.support.v4.util.LruCache;
import com.activeandroid.Configuration;
import com.activeandroid.DatabaseHelper;
import com.activeandroid.Model;
import com.activeandroid.ModelInfo;
import com.activeandroid.TableInfo;
import com.activeandroid.serializer.TypeSerializer;
import com.activeandroid.util.Log;
import java.util.Collection;

public final class Cache {
    public static final int DEFAULT_CACHE_SIZE = 1024;
    private static Context sContext;
    private static ModelInfo sModelInfo;
    private static DatabaseHelper sDatabaseHelper;
    private static LruCache<String, Model> sEntities;
    private static boolean sIsInitialized;

    private Cache() {
    }

    public static synchronized void initialize(Configuration configuration) {
        if (sIsInitialized) {
            Log.v("ActiveAndroid already initialized.");
            return;
        }
        sContext = configuration.getContext();
        sModelInfo = new ModelInfo(configuration);
        sDatabaseHelper = new DatabaseHelper(configuration);
        sEntities = new LruCache(configuration.getCacheSize());
        Cache.openDatabase();
        sIsInitialized = true;
        Log.v("ActiveAndroid initialized successfully.");
    }

    public static synchronized void clear() {
        sEntities.evictAll();
        Log.v("Cache cleared.");
    }

    public static synchronized void dispose() {
        Cache.closeDatabase();
        sEntities = null;
        sModelInfo = null;
        sDatabaseHelper = null;
        sIsInitialized = false;
        Log.v("ActiveAndroid disposed. Call initialize to use library.");
    }

    public static boolean isInitialized() {
        return sIsInitialized;
    }

    public static synchronized SQLiteDatabase openDatabase() {
        return sDatabaseHelper.getWritableDatabase();
    }

    public static synchronized void closeDatabase() {
        sDatabaseHelper.close();
    }

    public static Context getContext() {
        return sContext;
    }

    public static String getIdentifier(Class<? extends Model> type, Long id) {
        return Cache.getTableName(type) + "@" + id;
    }

    public static String getIdentifier(Model entity) {
        return Cache.getIdentifier(entity.getClass(), entity.getId());
    }

    public static synchronized void addEntity(Model entity) {
        sEntities.put((Object)Cache.getIdentifier(entity), (Object)entity);
    }

    public static synchronized Model getEntity(Class<? extends Model> type, long id) {
        return (Model)sEntities.get((Object)Cache.getIdentifier(type, id));
    }

    public static synchronized void removeEntity(Model entity) {
        sEntities.remove((Object)Cache.getIdentifier(entity));
    }

    public static synchronized Collection<TableInfo> getTableInfos() {
        return sModelInfo.getTableInfos();
    }

    public static synchronized TableInfo getTableInfo(Class<? extends Model> type) {
        return sModelInfo.getTableInfo(type);
    }

    public static synchronized TypeSerializer getParserForType(Class<?> type) {
        return sModelInfo.getTypeSerializer(type);
    }

    public static synchronized String getTableName(Class<? extends Model> type) {
        return sModelInfo.getTableInfo(type).getTableName();
    }

    static {
        sIsInitialized = false;
    }
}

